/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.LogFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;

public class FilterManager {
    private static FilterManager instance;
    private static LogFilter logFilter;
    private static int CurrentlyInRun;

    public FilterManager() {
        logFilter = new LogFilter();
        Logger logger = (Logger)LogManager.getRootLogger();
        logger.addFilter((Filter)logFilter);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                FilterManager.this.setLogFilterPrior();
            }
        };
        SCore.schedulerHook.runTask(r, 100L);
    }

    public void reload() {
        logFilter.reload();
    }

    public static FilterManager getInstance() {
        if (instance == null) {
            instance = new FilterManager();
        }
        return instance;
    }

    public void showDebug() {
        Logger logger = (Logger)LogManager.getRootLogger();
        logger.getFilters().forEachRemaining(f -> SsomarDev.testMsg(">> FilterManager " + f.toString(), true));
    }

    public void setLogFilterPrior() {
        if (SCore.is1v12Less()) {
            return;
        }
        Logger logger = (Logger)LogManager.getRootLogger();
        logger.getFilters().forEachRemaining(f -> {
            if (!(f instanceof LogFilter)) {
                logger.get().removeFilter(f);
                logger.addFilter(f);
            }
        });
    }

    public boolean isSilenceOuput() {
        return CurrentlyInRun > 0;
    }

    public void incCurrentlyInRun() {
        ++CurrentlyInRun;
    }

    public void decrCurrentlyInRun() {
        --CurrentlyInRun;
    }

    public int getCurrentlyInRun() {
        return CurrentlyInRun;
    }

    static {
        CurrentlyInRun = 0;
    }
}

