/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.AllCommandsManager;
import com.ssomar.score.commands.runnable.NothingObject;
import com.ssomar.score.commands.runnable.RunCommand;
import com.ssomar.score.commands.runnable.util.commands.DelayTick;
import com.ssomar.score.commands.runnable.util.commands.LoopEnd;
import com.ssomar.score.commands.runnable.util.commands.LoopStart;
import com.ssomar.score.commands.runnable.util.commands.RandomEnd;
import com.ssomar.score.commands.runnable.util.commands.RandomRun;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public abstract class RunCommandsBuilder {
    public static SendMessage sm = new SendMessage();
    private List<String> commands;
    private ActionInfo actionInfo;
    private TreeMap<Integer, List<RunCommand>> finalCommands = new TreeMap();
    public static Map<String, String> nothingMap = new HashMap<String, String>(){
        {
            this.put("nothing*", "nothing\\*");
            this.put("NOTHING*", "NOTHING\\*");
        }
    };

    public RunCommandsBuilder(List<String> commands, ActionInfo actionInfo) {
        this.actionInfo = actionInfo;
        this.commands = commands;
        this.init();
    }

    public static SendMessage getSm() {
        return sm;
    }

    public static void setSm(SendMessage sm) {
        RunCommandsBuilder.sm = sm;
    }

    public void init() {
        this.commands = this.replaceFor(this.commands);
        this.commands = this.replaceLoop(this.commands);
        this.initFinalCommands();
    }

    public List<String> selectRandomCommands(List<String> commands, Integer amount, @Nullable NothingObject nothingObject) {
        ArrayList<String> commandsList = new ArrayList<String>(commands);
        ArrayList<String> result = new ArrayList<String>();
        int nothingTotal = 0;
        if (nothingObject != null) {
            nothingTotal = nothingObject.getNothingCount();
        }
        for (int i = 0; i < amount; ++i) {
            int commandsSize = commandsList.size();
            if (commandsSize == 0) {
                return result;
            }
            int rdn = (int)(Math.random() * (double)(commandsSize + nothingTotal));
            if (rdn >= commandsSize) {
                --nothingTotal;
                if (!nothingObject.hasNothingString()) continue;
                result.add(nothingObject.getNothingString());
                continue;
            }
            result.add((String)commandsList.get(rdn));
            commandsList.remove(rdn);
        }
        return result;
    }

    public List<String> replaceLoop(List<String> commands) {
        ArrayList<String> result = new ArrayList<String>();
        boolean isInLoop = false;
        int loopAmount = 0;
        ArrayList<String> commandsInLoop = new ArrayList<String>();
        for (String s : commands) {
            String command = s;
            if (!command.contains("+++")) {
                if (LoopStart.checkContains(command)) {
                    try {
                        String secondPart = LoopStart.extractIterations(command);
                        if (secondPart == null) continue;
                        if (secondPart.contains("%")) {
                            secondPart = this.actionInfo.getSp().replacePlaceholder(secondPart, true);
                        }
                        loopAmount = Double.valueOf(secondPart).intValue();
                        isInLoop = true;
                    }
                    catch (Exception e) {
                        loopAmount = 0;
                        isInLoop = false;
                    }
                    continue;
                }
                if (LoopEnd.checkContains(command)) {
                    for (int k = 0; k < loopAmount; ++k) {
                        result.addAll(commandsInLoop);
                    }
                    loopAmount = 0;
                    isInLoop = false;
                    commandsInLoop.clear();
                    continue;
                }
            } else {
                command = StringConverter.coloredString(s);
            }
            if (isInLoop) {
                commandsInLoop.add(command);
                continue;
            }
            result.add(command);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<String> replaceFor(List<String> commands) {
        while (this.containsFor(commands)) {
            boolean isInFor = false;
            int forStart = -1;
            int forEnd = -1;
            ArrayList<String> commandsInFor = new ArrayList<String>();
            ArrayList<Integer> indexToRemove = new ArrayList<Integer>();
            int index = 0;
            String forId = "";
            for (String s : commands) {
                block13: {
                    String command = s;
                    if (command.contains("FOR")) {
                        command = this.actionInfo.getSp().replacePlaceholder(command, true);
                    }
                    if (!command.contains("+++")) {
                        if (command.contains("FOR [") && command.contains("]") && !isInFor) {
                            if (command.contains(">")) {
                                forId = command.split(">")[1];
                                forId = forId.replaceAll(" ", "");
                            }
                            commandsInFor.clear();
                            forStart = index;
                            isInFor = true;
                            commandsInFor.add(command);
                            indexToRemove.add(index);
                        } else {
                            if (command.contains("END_FOR") || command.contains("ENDFOR")) {
                                if (!(forId.equals("") || command.split(" ").length >= 2 && command.split(" ")[1].equals(forId))) {
                                    commandsInFor.add(command);
                                    indexToRemove.add(index);
                                    break block13;
                                } else {
                                    forEnd = index;
                                    commandsInFor.add(command);
                                    indexToRemove.add(index);
                                    break;
                                }
                            }
                            if (isInFor) {
                                commandsInFor.add(command);
                                indexToRemove.add(index);
                            }
                        }
                    }
                }
                ++index;
            }
            if (forStart == -1) return commands;
            if (forEnd == -1) {
                return commands;
            }
            List<String> commandsToReplaceWith = this.transformFor(commandsInFor);
            Collections.sort(indexToRemove, Collections.reverseOrder());
            Iterator iterator = indexToRemove.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                commands.remove(i);
            }
            commands.addAll(forStart, commandsToReplaceWith);
        }
        return commands;
    }

    public boolean containsFor(List<String> commands) {
        for (String s : commands) {
            if (s.contains("FOR")) {
                s = this.actionInfo.getSp().replacePlaceholder(s, true);
            }
            if (!s.contains("FOR [") || !s.contains("]") || s.contains("+++")) continue;
            return true;
        }
        return false;
    }

    public List<String> transformFor(List<String> commands) {
        if (commands != null && commands.size() > 2) {
            ArrayList<String> results = new ArrayList<String>();
            String forCommand = commands.get(0);
            commands.remove(0);
            commands.remove(commands.size() - 1);
            if (forCommand.contains("FOR [") && forCommand.contains("]")) {
                String[] split3;
                String[] split = forCommand.split("FOR \\[");
                String[] split2 = split[1].split("]");
                String values = split2[0];
                Optional<Object> optionalID = Optional.empty();
                try {
                    optionalID = Optional.of("%" + split2[1].split("\\>")[1].trim() + "%");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (String s : split3 = values.split(",")) {
                    s = s.trim();
                    for (String command : commands) {
                        results.add(command.replaceAll(optionalID.orElse("%for%"), s));
                    }
                }
            }
            return results;
        }
        return new ArrayList<String>();
    }

    public abstract RunCommand buildRunCommand(Integer var1, String var2, ActionInfo var3);

    public void inserFinalCommands(Integer delay, String command) {
        RunCommand runCommand = this.buildRunCommand(delay, command, this.actionInfo);
        if (this.finalCommands.containsKey(delay)) {
            this.finalCommands.get(delay).add(runCommand);
        } else {
            ArrayList<RunCommand> result = new ArrayList<RunCommand>(Collections.singletonList(runCommand));
            this.finalCommands.put(delay, result);
        }
    }

    public Optional<NothingObject> replaceNothing(String command) {
        for (Map.Entry<String, String> entry : nothingMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!command.contains(key)) continue;
            command = this.actionInfo.getSp().replacePlaceholder(command, true);
            try {
                int m;
                String nothingString = "";
                if (command.contains("//") && !command.contains("https://")) {
                    m = Double.valueOf(command.split(value)[1].split("//")[0].trim()).intValue();
                    nothingString = "SEND_MESSAGE " + command.split("//")[1];
                } else {
                    m = Double.valueOf(command.split(value)[1]).intValue();
                }
                NothingObject nothingObject = new NothingObject(m, nothingString);
                return Optional.of(nothingObject);
            }
            catch (Exception err) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public List<String> replaceRandomCommands(List<String> commands) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> commandsRandom = new ArrayList<String>();
        NothingObject nothingObject = null;
        boolean inRandom = false;
        int nbRandom = 0;
        for (String command : commands) {
            if (RandomRun.checkContains(command) && !AllCommandsManager.getInstance().startsWithCommandThatRunCommands(command)) {
                String secondPart = RandomRun.extractSelectionCount(command);
                if (secondPart == null) continue;
                if (secondPart.contains("%")) {
                    SsomarDev.testMsg("secondPart: " + secondPart, true);
                    secondPart = this.actionInfo.getSp().replacePlaceholder(secondPart, true);
                }
                nbRandom = Integer.parseInt(secondPart);
                inRandom = true;
                continue;
            }
            if (RandomEnd.checkContains(command) && !AllCommandsManager.getInstance().startsWithCommandThatRunCommands(command)) {
                result.addAll(this.selectRandomCommands(commandsRandom, nbRandom, nothingObject));
                inRandom = false;
                commandsRandom.clear();
                nbRandom = 0;
                continue;
            }
            if (inRandom) {
                Optional<NothingObject> nothingObjectOpt = this.replaceNothing(command);
                if (nothingObjectOpt.isPresent()) {
                    nothingObject = nothingObjectOpt.get();
                    continue;
                }
                commandsRandom.add(command);
                continue;
            }
            result.add(command);
        }
        if (!commandsRandom.isEmpty()) {
            result.addAll(this.selectRandomCommands(commandsRandom, nbRandom, nothingObject));
        }
        return result;
    }

    public List<String> decompMultipleCommandsAndMsg(List<String> commands) {
        ArrayList<String> result = new ArrayList<String>();
        for (String command : commands) {
            String[] tab = command.contains("+++") ? command.split("\\+\\+\\+") : new String[]{command};
            for (String s : tab) {
                while (s.startsWith(" ")) {
                    s = s.substring(1);
                }
                while (s.endsWith(" ")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.startsWith("/")) {
                    s = s.substring(1);
                }
                result.add(s);
            }
            String s = command;
            if (!result.isEmpty()) {
                s = (String)result.get(result.size() - 1);
                result.remove(result.size() - 1);
            }
            if (s.contains("//") && !command.contains("https://")) {
                String[] spliter = s.split("//");
                String commandF = spliter[0];
                result.add(commandF);
                String message = "";
                if (spliter.length < 2) continue;
                message = spliter[1].charAt(0) != ' ' ? "SEND_MESSAGE " + spliter[1] : "SEND_MESSAGE" + spliter[1];
                result.add(message);
                continue;
            }
            result.add(s);
        }
        return result;
    }

    public boolean initFinalCommands() {
        int delay = 0;
        this.commands = this.replaceRandomCommands(this.commands);
        this.commands = this.decompMultipleCommandsAndMsg(this.commands);
        this.commands = this.replaceFor(this.commands);
        this.commands = this.replaceLoop(this.commands);
        for (String command : this.commands) {
            String secondPart;
            String[] tab;
            String delayStr;
            if (command.trim().length() == 0) continue;
            if (command.startsWith("score run-")) {
                this.inserFinalCommands(delay, command);
                continue;
            }
            if (DelayTick.checkContains(command) && !command.startsWith("IF") && !AllCommandsManager.getInstance().startsWithCommandThatRunCommands(command)) {
                delayStr = command;
                if (command.contains("+++")) {
                    for (String s : tab = command.split("\\+\\+\\+")) {
                        if (!DelayTick.checkContains(s)) continue;
                        delayStr = s;
                    }
                }
                if ((secondPart = DelayTick.replaceCommand(delayStr).replaceAll(" ", "")).contains("%")) {
                    secondPart = this.actionInfo.getSp().replacePlaceholder(secondPart, true);
                }
                delay += Integer.parseInt(secondPart);
                continue;
            }
            if (command.contains("DELAY ") && !command.startsWith("IF") && !AllCommandsManager.getInstance().startsWithCommandThatRunCommands(command)) {
                delayStr = command;
                if (command.contains("+++")) {
                    for (String s : tab = command.split("\\+\\+\\+")) {
                        if (!s.contains("DELAY ")) continue;
                        delayStr = s;
                    }
                }
                if ((secondPart = delayStr.replaceAll("DELAY ", "").replaceAll(" ", "")).contains("%")) {
                    secondPart = this.actionInfo.getSp().replacePlaceholder(secondPart, true);
                }
                delay += Integer.parseInt(secondPart) * 20;
                continue;
            }
            this.inserFinalCommands(delay, command);
        }
        return true;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public ActionInfo getActionInfo() {
        return this.actionInfo;
    }

    public void setActionInfo(ActionInfo actionInfo) {
        this.actionInfo = actionInfo;
    }

    public TreeMap<Integer, List<RunCommand>> getFinalCommands() {
        return this.finalCommands;
    }

    public void setFinalCommands(TreeMap<Integer, List<RunCommand>> finalCommands) {
        this.finalCommands = finalCommands;
    }
}

