/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.fly.FlyManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class FlyOff
extends PlayerCommand {
    public FlyOff() {
        CommandSetting teleportOnTheGround = new CommandSetting("teleportOnTheGround", 0, Boolean.class, (Object)true);
        List<CommandSetting> settings = this.getSettings();
        settings.add(teleportOnTheGround);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        boolean teleport = (Boolean)sCommandToExec.getSettingValue("teleportOnTheGround");
        if (teleport && !receiver.isOnGround()) {
            Location playerLocation = receiver.getLocation();
            boolean isVoid = false;
            while (playerLocation.getBlock().isEmpty()) {
                if (playerLocation.getY() <= 1.0) {
                    isVoid = true;
                    break;
                }
                playerLocation.subtract(0.0, 1.0, 0.0);
            }
            if (!isVoid) {
                playerLocation.add(0.0, 1.0, 0.0);
                receiver.teleport(playerLocation);
            }
        }
        receiver.setAllowFlight(false);
        receiver.setFlying(false);
        FlyManager.getInstance().removePlayerWithFly(receiver);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("FLY_OFF");
        names.add("FLY OFF");
        return names;
    }

    @Override
    public String getTemplate() {
        return "FLY_OFF teleportOnTheGround:true";
    }

    @Override
    public ChatColor getColor() {
        return ChatColor.BLUE;
    }

    @Override
    public ChatColor getExtraColor() {
        return ChatColor.AQUA;
    }
}

