/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands.absorption;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.player.commands.absorption.AbsorptionObject;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class AbsorptionManager {
    public static AbsorptionManager instance;
    private List<AbsorptionObject> absorptionList;

    public AbsorptionManager() {
        instance = this;
        this.absorptionList = new ArrayList<AbsorptionObject>();
    }

    public void addAbsorption(AbsorptionObject absorption) {
        this.absorptionList.add(absorption);
    }

    public AbsorptionObject applyAbsorption(final AbsorptionObject absorption) {
        Player receiver;
        if (absorption.getTask() != null) {
            absorption.getTask().cancel();
        }
        if ((receiver = SCore.plugin.getServer().getPlayer(absorption.getPlayerUUID())) == null) {
            return absorption;
        }
        double currentabsorption = receiver.getAbsorptionAmount();
        long remainingTimeTiksTime = absorption.getTime() - System.currentTimeMillis();
        if ((remainingTimeTiksTime /= 50L) <= 0L) {
            absorption.setToRemove(true);
            return absorption;
        }
        SsomarDev.testMsg("currentAbso: " + currentabsorption + " abso to add " + absorption.getAbsorption(), true);
        receiver.setAbsorptionAmount(currentabsorption + absorption.getAbsorption());
        SsomarDev.testMsg("newAbso: " + receiver.getAbsorptionAmount(), true);
        Runnable runnable3 = new Runnable(){

            @Override
            public void run() {
                SsomarDev.testMsg("REMOVE receiver: " + receiver.getUniqueId() + " ABSORPTION: " + absorption.getAbsorption(), true);
                if (!receiver.isDead()) {
                    try {
                        receiver.setAbsorptionAmount(receiver.getAbsorptionAmount() - absorption.getAbsorption());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                AbsorptionManager.this.absorptionList.remove(absorption);
            }
        };
        absorption.setTask(SCore.schedulerHook.runEntityTask(runnable3, null, (Entity)receiver, remainingTimeTiksTime));
        return absorption;
    }

    public void onConnect(Player player) {
        ArrayList<AbsorptionObject> toRemove = new ArrayList<AbsorptionObject>();
        for (AbsorptionObject absorption : this.absorptionList) {
            if (!absorption.getPlayerUUID().equals(player.getUniqueId()) || !this.applyAbsorption(absorption).isToRemove()) continue;
            toRemove.add(absorption);
        }
        this.absorptionList.removeAll(toRemove);
    }

    public void onDisconnect(Player player) {
        for (AbsorptionObject absorption : this.absorptionList) {
            if (!absorption.getPlayerUUID().equals(player.getUniqueId())) continue;
            absorption.getTask().cancel();
            player.setAbsorptionAmount(player.getAbsorptionAmount() - absorption.getAbsorption());
        }
    }

    public static AbsorptionManager getInstance() {
        if (instance == null) {
            instance = new AbsorptionManager();
        }
        return instance;
    }
}

