/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.events;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class EntitiesFromSpawnerListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onEntitySpawnEvent(CreatureSpawnEvent e) {
        LivingEntity entity = e.getEntity();
        try {
            CreatureSpawnEvent.SpawnReason spawnReason = e.getSpawnReason();
            if (spawnReason == CreatureSpawnEvent.SpawnReason.SPAWNER && !GeneralConfig.getInstance().isDisableCustomMetadataOnEntities()) {
                entity.setMetadata("fromSpawner", (MetadataValue)new FixedMetadataValue(SCore.pluginHolder, (Object)1));
            }
        }
        catch (NoSuchMethodError ex) {
            e.getHandlers().unregister((Listener)this);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntitySpawnEvent(EntityDeathEvent e) {
        LivingEntity entity = e.getEntity();
        List values = entity.getMetadata("fromSpawner");
        for (MetadataValue value : values) {
            Plugin owningPlugin = value.getOwningPlugin();
            if (owningPlugin == null) continue;
            entity.removeMetadata("fromSpawner", owningPlugin);
        }
    }
}

