/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.hiders;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class Hiders
extends FeatureWithHisOwnEditor<Hiders, Hiders, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItem {
    private BooleanFeature hideEnchantments;
    private BooleanFeature hideUnbreakable;
    private BooleanFeature hideAttributes;
    private BooleanFeature hidePotionEffects;
    private BooleanFeature hideUsage;
    private BooleanFeature hideDye;
    private BooleanFeature hideArmorTrim;
    private BooleanFeature hideDestroys;
    private BooleanFeature hidePlacedOn;
    private BooleanFeature hideAdditionalTooltip;
    private BooleanFeature hideTooltip;

    public Hiders(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.hiders);
        this.reset();
    }

    @Override
    public void reset() {
        this.hideEnchantments = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.hideEnchantments);
        this.hideUnbreakable = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.hideUnbreakable);
        this.hideAttributes = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.hideAttributes);
        this.hidePotionEffects = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.hidePotionEffects);
        this.hideUsage = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.hideUsage);
        this.hideDye = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.hideDye);
        this.hideArmorTrim = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.hideArmorTrim);
        this.hideDestroys = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.hideDestroys);
        this.hidePlacedOn = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.hidePlacedOn);
        this.hideAdditionalTooltip = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.hideAdditionalTooltip);
        this.hideTooltip = new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.hideTooltip);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            this.hideEnchantments.load(plugin, section, isPremiumLoading);
            this.hideUnbreakable.load(plugin, section, isPremiumLoading);
            this.hideAttributes.load(plugin, section, isPremiumLoading);
            this.hideUsage.load(plugin, section, isPremiumLoading);
            if (!SCore.is1v11Less()) {
                this.hideDestroys.load(plugin, section, isPremiumLoading);
                this.hidePlacedOn.load(plugin, section, isPremiumLoading);
            }
            if (SCore.is1v17Plus()) {
                this.hideDye.load(plugin, section, isPremiumLoading);
            }
            if (SCore.is1v20Plus()) {
                this.hideArmorTrim.load(plugin, section, isPremiumLoading);
            }
            if (SCore.is1v20v5Plus()) {
                this.hideAdditionalTooltip.load(plugin, section, isPremiumLoading);
                this.hideTooltip.load(plugin, section, isPremiumLoading);
            } else {
                this.hidePotionEffects.load(plugin, section, isPremiumLoading);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.hideEnchantments.save(section);
        this.hideUnbreakable.save(section);
        this.hideAttributes.save(section);
        this.hideUsage.save(section);
        if (!SCore.is1v11Less()) {
            this.hideDestroys.save(section);
            this.hidePlacedOn.save(section);
        }
        if (SCore.is1v17Plus()) {
            this.hideDye.save(section);
        }
        if (SCore.is1v20Plus()) {
            this.hideArmorTrim.save(section);
        }
        if (SCore.is1v20v5Plus()) {
            this.hideAdditionalTooltip.save(section);
            this.hideTooltip.save(section);
        } else {
            this.hidePotionEffects.save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public Hiders getValue() {
        return this;
    }

    @Override
    public Hiders initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 11];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 11] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 10] = !SCore.is1v20v5Plus() ? "&7Hide tooltip: &6&lONLY 1.20.5 & +" : (this.hideTooltip.getValue() != false ? "&7Hide tooltip: &a&l\u2714" : "&7Hide tooltip: &c&l\u2718");
        finalDescription[finalDescription.length - 9] = this.hideDestroys.getValue() != false ? "&7Hide destroys: &a&l\u2714" : "&7Hide destroys: &c&l\u2718";
        finalDescription[finalDescription.length - 8] = this.hidePlacedOn.getValue() != false ? "&7Hide placedOn: &a&l\u2714" : "&7Hide placedOn: &c&l\u2718";
        finalDescription[finalDescription.length - 7] = this.hideEnchantments.getValue() != false ? "&7Hide enchantments: &a&l\u2714" : "&7Hide enchantments: &c&l\u2718";
        finalDescription[finalDescription.length - 6] = this.hideUnbreakable.getValue() != false ? "&7Hide unbreakable: &a&l\u2714" : "&7Hide unbreakable: &c&l\u2718";
        finalDescription[finalDescription.length - 5] = this.hideAttributes.getValue() != false ? "&7Hide attributes: &a&l\u2714" : "&7Hide attributes: &c&l\u2718";
        finalDescription[finalDescription.length - 4] = this.hideUsage.getValue() != false ? "&7Hide usage: &a&l\u2714" : "&7Hide usage: &c&l\u2718";
        finalDescription[finalDescription.length - 3] = !SCore.is1v17Plus() ? "&7Hide dye: &6&lONLY 1.17 & +" : (this.hideDye.getValue() != false ? "&7Hide dye: &a&l\u2714" : "&7Hide dye: &c&l\u2718");
        finalDescription[finalDescription.length - 2] = !SCore.is1v20Plus() ? "&7Hide armor trim: &6&lONLY 1.20 & +" : (this.hideArmorTrim.getValue() != false ? "&7Hide armor trim: &a&l\u2714" : "&7Hide armor trim: &c&l\u2718");
        finalDescription[finalDescription.length - 1] = SCore.is1v20v5Plus() ? (this.hideAdditionalTooltip.getValue().booleanValue() ? "&7Hide additional tooltip: &a&l\u2714" : "&7Hide additional tooltip: &c&l\u2718") : (this.hidePotionEffects.getValue() != false ? "&7Hide effects / banner tags: &a&l\u2714" : "&7Hide effects / banner tags: &c&l\u2718");
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public Hiders clone(FeatureParentInterface newParent) {
        Hiders dropFeatures = new Hiders(newParent);
        dropFeatures.hideEnchantments = this.hideEnchantments.clone(dropFeatures);
        dropFeatures.hideUnbreakable = this.hideUnbreakable.clone(dropFeatures);
        dropFeatures.hideAttributes = this.hideAttributes.clone(dropFeatures);
        dropFeatures.hidePotionEffects = this.hidePotionEffects.clone(dropFeatures);
        dropFeatures.hideUsage = this.hideUsage.clone(dropFeatures);
        dropFeatures.hideDye = this.hideDye.clone(dropFeatures);
        dropFeatures.hideArmorTrim = this.hideArmorTrim.clone(dropFeatures);
        dropFeatures.hideDestroys = this.hideDestroys.clone(dropFeatures);
        dropFeatures.hidePlacedOn = this.hidePlacedOn.clone(dropFeatures);
        dropFeatures.hideAdditionalTooltip = this.hideAdditionalTooltip.clone(dropFeatures);
        dropFeatures.hideTooltip = this.hideTooltip.clone(dropFeatures);
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.hideEnchantments);
        features.add(this.hideUnbreakable);
        features.add(this.hideAttributes);
        features.add(this.hideUsage);
        if (!SCore.is1v11Less()) {
            features.add(this.hideDestroys);
            features.add(this.hidePlacedOn);
        }
        if (SCore.is1v17Plus()) {
            features.add(this.hideDye);
        }
        if (SCore.is1v20Plus()) {
            features.add(this.hideArmorTrim);
        }
        if (SCore.is1v20v5Plus()) {
            features.add(this.hideTooltip);
            features.add(this.hideAdditionalTooltip);
        } else {
            features.add(this.hidePotionEffects);
        }
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof Hiders)) continue;
            Hiders hiders = (Hiders)feature;
            hiders.setHideEnchantments(this.hideEnchantments);
            hiders.setHideUnbreakable(this.hideUnbreakable);
            hiders.setHideAttributes(this.hideAttributes);
            hiders.setHideUsage(this.hideUsage);
            if (!SCore.is1v11Less()) {
                hiders.setHideDestroys(this.hideDestroys);
                hiders.setHidePlacedOn(this.hidePlacedOn);
            }
            if (SCore.is1v17Plus()) {
                hiders.setHideDye(this.hideDye);
            }
            if (SCore.is1v20Plus()) {
                hiders.setHideArmorTrim(this.hideArmorTrim);
            }
            if (SCore.is1v20v5Plus()) {
                hiders.setHideAdditionalTooltip(this.hideAdditionalTooltip);
                hiders.setHideTooltip(this.hideTooltip);
                break;
            }
            hiders.setHidePotionEffects(this.hidePotionEffects);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return true;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        ItemFlag additionalFlag = SCore.is1v20v5Plus() ? ItemFlag.HIDE_ADDITIONAL_TOOLTIP : ItemFlag.valueOf((String)"HIDE_POTION_EFFECTS");
        meta.removeItemFlags(new ItemFlag[]{additionalFlag, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE});
        if (SCore.is1v20v5Plus()) {
            if (this.getHideAdditionalTooltip().getValue().booleanValue()) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            }
            if (this.getHideTooltip().getValue().booleanValue()) {
                meta.setHideTooltip(true);
            }
        } else if (this.getHidePotionEffects().getValue().booleanValue()) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)"HIDE_POTION_EFFECTS")});
        }
        if (this.getHideAttributes().getValue().booleanValue()) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        if (this.getHideEnchantments().getValue().booleanValue()) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (this.getHideUnbreakable().getValue().booleanValue()) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        if (this.getHideDye().getValue().booleanValue() && SCore.is1v17Plus()) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
        }
        if (SCore.is1v20Plus() && this.getHideArmorTrim().getValue().booleanValue()) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        ItemFlag additionalFlag;
        ItemMeta meta = args.getMeta();
        ItemFlag itemFlag = additionalFlag = SCore.is1v20v5Plus() ? ItemFlag.HIDE_ADDITIONAL_TOOLTIP : ItemFlag.valueOf((String)"HIDE_POTION_EFFECTS");
        if (meta.hasItemFlag(additionalFlag)) {
            if (SCore.is1v20v5Plus()) {
                this.getHideAdditionalTooltip().setValue(true);
            } else {
                this.getHidePotionEffects().setValue(true);
            }
        }
        if (meta.hasItemFlag(ItemFlag.HIDE_ATTRIBUTES)) {
            this.getHideAttributes().setValue(true);
        }
        if (meta.hasItemFlag(ItemFlag.HIDE_ENCHANTS)) {
            this.getHideEnchantments().setValue(true);
        }
        if (meta.hasItemFlag(ItemFlag.HIDE_UNBREAKABLE)) {
            this.getHideUnbreakable().setValue(true);
        }
        if (SCore.is1v17Plus() && meta.hasItemFlag(ItemFlag.HIDE_DYE)) {
            this.getHideDye().setValue(true);
        }
        if (SCore.is1v20Plus() && meta.hasItemFlag(ItemFlag.HIDE_ARMOR_TRIM)) {
            this.getHideArmorTrim().setValue(true);
        }
        if (SCore.is1v20v5Plus() && meta.isHideTooltip()) {
            this.getHideTooltip().setValue(true);
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.HIDERS;
    }

    @Generated
    public BooleanFeature getHideEnchantments() {
        return this.hideEnchantments;
    }

    @Generated
    public BooleanFeature getHideUnbreakable() {
        return this.hideUnbreakable;
    }

    @Generated
    public BooleanFeature getHideAttributes() {
        return this.hideAttributes;
    }

    @Generated
    public BooleanFeature getHidePotionEffects() {
        return this.hidePotionEffects;
    }

    @Generated
    public BooleanFeature getHideUsage() {
        return this.hideUsage;
    }

    @Generated
    public BooleanFeature getHideDye() {
        return this.hideDye;
    }

    @Generated
    public BooleanFeature getHideArmorTrim() {
        return this.hideArmorTrim;
    }

    @Generated
    public BooleanFeature getHideDestroys() {
        return this.hideDestroys;
    }

    @Generated
    public BooleanFeature getHidePlacedOn() {
        return this.hidePlacedOn;
    }

    @Generated
    public BooleanFeature getHideAdditionalTooltip() {
        return this.hideAdditionalTooltip;
    }

    @Generated
    public BooleanFeature getHideTooltip() {
        return this.hideTooltip;
    }

    @Generated
    public void setHideEnchantments(BooleanFeature hideEnchantments) {
        this.hideEnchantments = hideEnchantments;
    }

    @Generated
    public void setHideUnbreakable(BooleanFeature hideUnbreakable) {
        this.hideUnbreakable = hideUnbreakable;
    }

    @Generated
    public void setHideAttributes(BooleanFeature hideAttributes) {
        this.hideAttributes = hideAttributes;
    }

    @Generated
    public void setHidePotionEffects(BooleanFeature hidePotionEffects) {
        this.hidePotionEffects = hidePotionEffects;
    }

    @Generated
    public void setHideUsage(BooleanFeature hideUsage) {
        this.hideUsage = hideUsage;
    }

    @Generated
    public void setHideDye(BooleanFeature hideDye) {
        this.hideDye = hideDye;
    }

    @Generated
    public void setHideArmorTrim(BooleanFeature hideArmorTrim) {
        this.hideArmorTrim = hideArmorTrim;
    }

    @Generated
    public void setHideDestroys(BooleanFeature hideDestroys) {
        this.hideDestroys = hideDestroys;
    }

    @Generated
    public void setHidePlacedOn(BooleanFeature hidePlacedOn) {
        this.hidePlacedOn = hidePlacedOn;
    }

    @Generated
    public void setHideAdditionalTooltip(BooleanFeature hideAdditionalTooltip) {
        this.hideAdditionalTooltip = hideAdditionalTooltip;
    }

    @Generated
    public void setHideTooltip(BooleanFeature hideTooltip) {
        this.hideTooltip = hideTooltip;
    }
}

