/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.particles.particle;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BukkitColorFeature;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.MaterialFeature;
import com.ssomar.score.features.types.ParticleTypeFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ParticleFeature
extends FeatureWithHisOwnEditor<ParticleFeature, ParticleFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private String id;
    private ParticleTypeFeature particlesType;
    private IntegerFeature particlesAmount;
    private DoubleFeature particlesOffSet;
    private DoubleFeature particlesSpeed;
    private IntegerFeature particlesDelay;
    private IntegerFeature particlesDensity;
    private BukkitColorFeature redstoneColor;
    private MaterialFeature blockType;

    public ParticleFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.particle);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.particlesType = new ParticleTypeFeature(this, Optional.of(Particle.FLAME), FeatureSettingsSCore.particlesType);
        this.particlesAmount = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.particlesAmount);
        this.particlesOffSet = new DoubleFeature(this, Optional.of(1.0), FeatureSettingsSCore.particlesOffSet);
        this.particlesSpeed = new DoubleFeature(this, Optional.of(1.0), FeatureSettingsSCore.particlesSpeed);
        this.particlesDelay = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.particlesDelay);
        this.particlesDensity = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.particlesDensity);
        this.blockType = new MaterialFeature(this, Optional.of(Material.STONE), FeatureSettingsSCore.blockType);
        this.redstoneColor = new BukkitColorFeature(this, Optional.of(Color.RED), FeatureSettingsSCore.redstoneColor);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.particlesType.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.particlesAmount.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.particlesOffSet.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.particlesSpeed.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.particlesDelay.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.particlesDensity.load(plugin, enchantmentConfig, isPremiumLoading));
            if (this.canHaveRedstoneColor()) {
                errors.addAll(this.redstoneColor.load(plugin, enchantmentConfig, isPremiumLoading));
            } else if (this.canHaveBlocktype()) {
                errors.addAll(this.blockType.load(plugin, enchantmentConfig, isPremiumLoading));
            }
        } else {
            errors.add("&cERROR, Couldn't load the Particle because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection enchantmentConfig = config.createSection(this.id);
        this.particlesType.save(enchantmentConfig);
        this.particlesAmount.save(enchantmentConfig);
        this.particlesOffSet.save(enchantmentConfig);
        this.particlesSpeed.save(enchantmentConfig);
        this.particlesDelay.save(enchantmentConfig);
        this.particlesDensity.save(enchantmentConfig);
        if (this.canHaveRedstoneColor()) {
            this.redstoneColor.save(enchantmentConfig);
        } else if (this.canHaveBlocktype()) {
            this.blockType.save(enchantmentConfig);
        }
    }

    @Override
    public ParticleFeature getValue() {
        return this;
    }

    @Override
    public ParticleFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 8];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 8] = "&7Type: &e" + ((Particle)((Optional)this.particlesType.getValue()).get()).name();
        finalDescription[finalDescription.length - 7] = "&7Amount: &e" + ((Optional)this.particlesAmount.getValue()).get();
        finalDescription[finalDescription.length - 6] = "&7Offset: &e" + ((Optional)this.particlesOffSet.getValue()).get();
        finalDescription[finalDescription.length - 5] = "&7Speed: &e" + ((Optional)this.particlesSpeed.getValue()).get();
        finalDescription[finalDescription.length - 4] = "&7Delay: &e" + ((Optional)this.particlesDelay.getValue()).get();
        finalDescription[finalDescription.length - 3] = "&7Density: &e" + ((Optional)this.particlesDensity.getValue()).get();
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ParticleFeature clone(FeatureParentInterface newParent) {
        ParticleFeature eF = new ParticleFeature(newParent, this.id);
        eF.setParticlesType(this.particlesType.clone(eF));
        eF.setParticlesAmount(this.particlesAmount.clone(eF));
        eF.setParticlesOffSet(this.particlesOffSet.clone(eF));
        eF.setParticlesSpeed(this.particlesSpeed.clone(eF));
        eF.setParticlesDelay(this.particlesDelay.clone(eF));
        eF.setParticlesDensity(this.particlesDensity.clone(eF));
        if (this.canHaveRedstoneColor()) {
            eF.setRedstoneColor(this.redstoneColor.clone(eF));
        } else if (this.canHaveBlocktype()) {
            eF.setBlockType(this.blockType.clone(eF));
        }
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>(Arrays.asList(this.particlesType, this.particlesAmount, this.particlesSpeed, this.particlesOffSet, this.particlesDelay, this.particlesDensity));
        if (this.canHaveRedstoneColor()) {
            features.add(this.redstoneColor);
        } else if (this.canHaveBlocktype()) {
            features.add(this.blockType);
        }
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection parentSection = this.getParent().getConfigurationSection();
        if (parentSection.isConfigurationSection(this.getId())) {
            return parentSection.getConfigurationSection(this.getId());
        }
        return parentSection.createSection(this.getId());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            ParticleFeature eF;
            if (!(feature instanceof ParticleFeature) || !(eF = (ParticleFeature)feature).getId().equals(this.id)) continue;
            eF.setParticlesType(this.particlesType.clone(eF));
            eF.setParticlesAmount(this.particlesAmount.clone(eF));
            eF.setParticlesOffSet(this.particlesOffSet.clone(eF));
            eF.setParticlesSpeed(this.particlesSpeed.clone(eF));
            eF.setParticlesDelay(this.particlesDelay.clone(eF));
            eF.setParticlesDensity(this.particlesDensity.clone(eF));
            if (this.canHaveRedstoneColor()) {
                eF.setRedstoneColor(this.redstoneColor.clone(eF));
                break;
            }
            if (!this.canHaveBlocktype()) break;
            eF.setBlockType(this.blockType.clone(eF));
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    public static List<Particle> getHaveBlocktypeParticles() {
        ArrayList<Particle> particles = new ArrayList<Particle>();
        if (SCore.is1v20v5Plus()) {
            particles.add(Particle.BLOCK);
            particles.add(Particle.DUST);
        } else {
            particles.add(Particle.valueOf((String)"BLOCK_CRACK"));
            particles.add(Particle.valueOf((String)"BLOCK_DUST"));
        }
        if (SCore.is1v18Plus()) {
            particles.add(Particle.BLOCK_MARKER);
        }
        return particles;
    }

    public static List<Particle> getHaveRedstoneColorParticles() {
        ArrayList<Particle> particles = new ArrayList<Particle>();
        if (SCore.is1v20v5Plus()) {
            particles.add(Particle.DUST);
        } else {
            particles.add(Particle.valueOf((String)"REDSTONE"));
        }
        return particles;
    }

    public boolean canHaveRedstoneColor() {
        return ParticleFeature.getHaveRedstoneColorParticles().contains(((Optional)this.particlesType.getValue()).get());
    }

    public boolean canHaveBlocktype() {
        return ParticleFeature.getHaveBlocktypeParticles().contains(((Optional)this.particlesType.getValue()).get());
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public ParticleTypeFeature getParticlesType() {
        return this.particlesType;
    }

    @Generated
    public IntegerFeature getParticlesAmount() {
        return this.particlesAmount;
    }

    @Generated
    public DoubleFeature getParticlesOffSet() {
        return this.particlesOffSet;
    }

    @Generated
    public DoubleFeature getParticlesSpeed() {
        return this.particlesSpeed;
    }

    @Generated
    public IntegerFeature getParticlesDelay() {
        return this.particlesDelay;
    }

    @Generated
    public IntegerFeature getParticlesDensity() {
        return this.particlesDensity;
    }

    @Generated
    public BukkitColorFeature getRedstoneColor() {
        return this.redstoneColor;
    }

    @Generated
    public MaterialFeature getBlockType() {
        return this.blockType;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setParticlesType(ParticleTypeFeature particlesType) {
        this.particlesType = particlesType;
    }

    @Generated
    public void setParticlesAmount(IntegerFeature particlesAmount) {
        this.particlesAmount = particlesAmount;
    }

    @Generated
    public void setParticlesOffSet(DoubleFeature particlesOffSet) {
        this.particlesOffSet = particlesOffSet;
    }

    @Generated
    public void setParticlesSpeed(DoubleFeature particlesSpeed) {
        this.particlesSpeed = particlesSpeed;
    }

    @Generated
    public void setParticlesDelay(IntegerFeature particlesDelay) {
        this.particlesDelay = particlesDelay;
    }

    @Generated
    public void setParticlesDensity(IntegerFeature particlesDensity) {
        this.particlesDensity = particlesDensity;
    }

    @Generated
    public void setRedstoneColor(BukkitColorFeature redstoneColor) {
        this.redstoneColor = redstoneColor;
    }

    @Generated
    public void setBlockType(MaterialFeature blockType) {
        this.blockType = blockType;
    }
}

