/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.repairableFeatures;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.ResetSetting;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.Repairable;
import org.jetbrains.annotations.NotNull;

public class RepairableFeatures
extends FeatureWithHisOwnEditor<RepairableFeatures, RepairableFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements FeatureForItem {
    private BooleanFeature enable;
    private IntegerFeature repairCost;

    public RepairableFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.repairableFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.enable = new BooleanFeature(this, false, FeatureSettingsSCore.enable);
        this.repairCost = new IntegerFeature(this, Optional.of(2), FeatureSettingsSCore.repairCost);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            for (FeatureInterface feature : this.getFeatures()) {
                errors.addAll(feature.load(plugin, section, isPremiumLoading));
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public RepairableFeatures getValue() {
        return this;
    }

    @Override
    public RepairableFeatures initItemParentEditor(GUI gui, int slot) {
        int len = 3;
        String[] finalDescription = new String[this.getEditorDescription().length + len];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - len] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - --len] = "&7Enable: &e" + (this.enable.getValue() != false ? "&a&l\u2714" : "&c&l\u2718");
        finalDescription[finalDescription.length - --len] = "&7Repair Cost: &e" + ((Optional)this.repairCost.getValue()).get();
        --len;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public RepairableFeatures clone(FeatureParentInterface newParent) {
        RepairableFeatures dropFeatures = new RepairableFeatures(newParent);
        dropFeatures.setEnable(this.enable.clone(dropFeatures));
        dropFeatures.setRepairCost(this.repairCost.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.enable);
        features.add(this.repairCost);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof RepairableFeatures)) continue;
            RepairableFeatures hiders = (RepairableFeatures)feature;
            hiders.setEnable(this.enable);
            hiders.setRepairCost(this.repairCost);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v21v2Plus();
    }

    @Override
    public boolean isApplicable(@NotNull FeatureForItemArgs args) {
        return args.getMeta() instanceof Repairable;
    }

    @Override
    public void applyOnItemMeta(@NotNull FeatureForItemArgs args) {
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        if (this.enable.getValue().booleanValue()) {
            Repairable repairable = (Repairable)args.getMeta();
            repairable.setRepairCost(((Integer)((Optional)this.repairCost.getValue()).get()).intValue());
        }
    }

    @Override
    public void loadFromItemMeta(@NotNull FeatureForItemArgs args) {
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        Repairable repairable = (Repairable)args.getMeta();
        if (((Repairable)args.getMeta()).hasRepairCost()) {
            this.enable.setValue(true);
            this.repairCost.setValue(Optional.of(repairable.getRepairCost()));
        }
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.REPAIRABLE;
    }

    @Generated
    public BooleanFeature getEnable() {
        return this.enable;
    }

    @Generated
    public IntegerFeature getRepairCost() {
        return this.repairCost;
    }

    @Generated
    public void setEnable(BooleanFeature enable) {
        this.enable = enable;
    }

    @Generated
    public void setRepairCost(IntegerFeature repairCost) {
        this.repairCost = repairCost;
    }
}

