/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireSubTextEditorInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.usedapi.MythicMobsAPI;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.strings.StringConverter;
import de.tr7zw.nbtapi.NBTEntity;
import de.tr7zw.nbtapi.NBTType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ListDetailedEntityFeature
extends FeatureAbstract<List<String>, ListDetailedEntityFeature>
implements FeatureRequireSubTextEditorInEditor {
    private static final String symbolStart = "{";
    private static final String symbolEnd = "}";
    private static final String symbolEquals = ":";
    private static final String symbolSeparator = "\\+";
    private static final String mythicMobsSymbol = "MM-";
    private static final String symbolNegation = "!";
    private static final Boolean DEBUG = true;
    private List<String> value;
    private List<String> defaultValue;
    private boolean notSaveIfEqualsToDefaultValue;

    public ListDetailedEntityFeature(FeatureParentInterface parent, List<String> defaultValue, FeatureSettingsInterface featureSettings, boolean notSaveIfEqualsToDefaultValue) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.notSaveIfEqualsToDefaultValue = notSaveIfEqualsToDefaultValue;
        this.reset();
    }

    public List<String> load(SPlugin plugin, List<String> entries, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        this.value = new ArrayList<String>();
        for (String s : entries) {
            String baseValue;
            block10: {
                baseValue = StringConverter.decoloredString(s);
                String checkValue = baseValue;
                if (checkValue.startsWith(symbolNegation)) {
                    checkValue = checkValue.substring(1);
                }
                String entityTypeStr = checkValue;
                if (s.contains(mythicMobsSymbol)) {
                    if (!SCore.hasMythicMobs) continue;
                    this.value.add(baseValue);
                    continue;
                }
                if (checkValue.contains(symbolStart)) {
                    entityTypeStr = checkValue.split("\\{")[0];
                    if (SCore.hasNBTAPI) {
                        String datas = checkValue.split("\\{")[1].replace(symbolEnd, "");
                        for (String data : datas.split(symbolSeparator)) {
                            String[] dataSplit = data.split(symbolEquals);
                            if (dataSplit.length == 2) continue;
                            errors.add("&cERROR, Couldn't load the The tags value of " + this.getName() + " from config, value: " + s + " &7&o" + this.getParent().getParentInfo() + " &6>> Example : ZOMBIE{CustomName:\"My name\"}   PIG{Invulnerable:1} ");
                        }
                    } else {
                        errors.add("&cERROR, Couldn't load the The tags value of " + this.getName() + " from config, value: " + s + " &7&o" + this.getParent().getParentInfo() + " &6>> Because it requires the plugin NBTAPI ");
                    }
                }
                try {
                    if (entityTypeStr.equals("*")) break block10;
                    EntityType.valueOf((String)entityTypeStr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    errors.add("&cERROR, Couldn't load the EntityType value of " + this.getName() + " from config, value: " + s + " &7&o" + this.getParent().getParentInfo() + " &6>> EntityTypes available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/entity/EntityType.html , you can also use MythicMobs entities with the prefix MM- , or accept all entities with *");
                    continue;
                }
            }
            this.value.add(baseValue);
        }
        FeatureReturnCheckPremium<List<String>> checkPremium = this.checkPremium("List of Detailed entities", this.value, Optional.of(this.defaultValue), isPremiumLoading);
        if (checkPremium.isHasError()) {
            this.value = checkPremium.getNewValue();
        }
        return errors;
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        return this.load(plugin, config.getStringList(this.getName()), isPremiumLoading);
    }

    public List<String> getWhiteListValue() {
        ArrayList<String> whiteList = new ArrayList<String>();
        for (String s : this.value) {
            if (s.startsWith(symbolNegation)) continue;
            whiteList.add(s);
        }
        return whiteList;
    }

    public List<String> getBlackListValue() {
        ArrayList<String> blackList = new ArrayList<String>();
        for (String s : this.value) {
            if (!s.startsWith(symbolNegation)) continue;
            blackList.add(s.substring(1));
        }
        return blackList;
    }

    public Map<EntityType, List<Map<String, String>>> extractCondition(List<String> values) {
        HashMap<EntityType, List<Map<String, String>>> conditions = new HashMap<EntityType, List<Map<String, String>>>();
        for (String s : values) {
            if (s.contains(mythicMobsSymbol)) continue;
            String entityTypeStr = s;
            HashMap<String, String> tags = new HashMap<String, String>();
            if (s.contains(symbolStart)) {
                entityTypeStr = s.split("\\{")[0];
                String datas = s.split("\\{")[1].replace(symbolEnd, "");
                String[] stringArray = datas.split(symbolSeparator);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String data = stringArray[i];
                    String[] dataSplit = data.split(symbolEquals);
                    tags.put(dataSplit[0], dataSplit[1]);
                }
            }
            if (entityTypeStr.equals("*")) {
                for (EntityType entityType : EntityType.values()) {
                    if (conditions.containsKey(entityType)) {
                        ((List)conditions.get(entityType)).add(tags);
                        continue;
                    }
                    conditions.put(entityType, new ArrayList(Collections.singletonList(tags)));
                }
                continue;
            }
            EntityType type = EntityType.valueOf((String)entityTypeStr.toUpperCase());
            if (conditions.containsKey(type)) {
                ((List)conditions.get(type)).add(tags);
                continue;
            }
            conditions.put(type, new ArrayList(Collections.singletonList(tags)));
        }
        return conditions;
    }

    public Map<EntityType, List<Map<String, String>>> extractWhiteListCondition() {
        return this.extractCondition(this.getWhiteListValue());
    }

    public Map<EntityType, List<Map<String, String>>> extractBlackListCondition() {
        return this.extractCondition(this.getBlackListValue());
    }

    public List<String> extractMMCondition(List<String> values) {
        ArrayList<String> mythicMobs = new ArrayList<String>();
        for (String s : values) {
            if (!s.contains(mythicMobsSymbol)) continue;
            mythicMobs.add(s.replace(mythicMobsSymbol, ""));
        }
        return mythicMobs;
    }

    public List<String> extractWhiteListMMCondition() {
        return this.extractMMCondition(this.getWhiteListValue());
    }

    public List<String> extractBlackListMMCondition() {
        return this.extractMMCondition(this.getBlackListValue());
    }

    public boolean isValidEntity(@NotNull Entity entity) {
        List<Map<String, String>> tagsList;
        boolean hasBLMMCondition;
        boolean hasWLMMCondition = !this.extractWhiteListMMCondition().isEmpty();
        boolean bl = hasBLMMCondition = !this.extractBlackListMMCondition().isEmpty();
        if (SCore.hasMythicMobs) {
            if (hasWLMMCondition && MythicMobsAPI.isMythicMob(entity, this.extractWhiteListMMCondition())) {
                return true;
            }
            if (hasBLMMCondition && MythicMobsAPI.isMythicMob(entity, this.extractBlackListMMCondition())) {
                return false;
            }
        }
        Map<EntityType, List<Map<String, String>>> conditionsWL = this.extractWhiteListCondition();
        Map<EntityType, List<Map<String, String>>> conditionsBL = this.extractBlackListCondition();
        EntityType type = entity.getType();
        for (EntityType t : conditionsBL.keySet()) {
            if (!t.equals((Object)type)) continue;
            tagsList = conditionsBL.get(t);
            if (tagsList.isEmpty()) {
                return false;
            }
            if (!this.verifTags(entity, tagsList)) continue;
            return false;
        }
        if (conditionsWL.isEmpty()) {
            return !hasWLMMCondition;
        }
        for (EntityType t : conditionsWL.keySet()) {
            if (!t.equals((Object)type)) continue;
            tagsList = conditionsWL.get(t);
            if (tagsList.isEmpty()) {
                return true;
            }
            if (!this.verifTags(entity, tagsList)) continue;
            return true;
        }
        return false;
    }

    public boolean verifTags(Entity entity, List<Map<String, String>> tagsList) {
        for (Map<String, String> tags : tagsList) {
            boolean invalid = false;
            if (tags.isEmpty()) {
                return true;
            }
            if (!Dependency.NBTAPI.isEnabled()) continue;
            NBTEntity nbtent = new NBTEntity(entity);
            for (String key : tags.keySet()) {
                String value = tags.get(key);
                NBTType nbtType = nbtent.getType(key);
                SsomarDev.testMsg("VERIF key: " + key + " value: " + value + " type: " + entity.getType(), DEBUG);
                switch (nbtType) {
                    case NBTTagEnd: {
                        return false;
                    }
                    case NBTTagByte: {
                        value = value.replace("b", "");
                        if (!NTools.isNumber(value)) break;
                        SsomarDev.testMsg("Byte: " + nbtent.getByte(key), DEBUG);
                        if (nbtent.getByte(key) == Byte.parseByte(value)) break;
                        invalid = true;
                        break;
                    }
                    case NBTTagShort: 
                    case NBTTagByteArray: 
                    case NBTTagIntArray: 
                    case NBTTagList: 
                    case NBTTagCompound: {
                        break;
                    }
                    case NBTTagInt: {
                        Optional<Integer> optInt = NTools.getInteger(value);
                        if (!optInt.isPresent()) break;
                        SsomarDev.testMsg("Int: " + nbtent.getInteger(key), DEBUG);
                        if (nbtent.getInteger(key) == optInt.get()) break;
                        invalid = true;
                        break;
                    }
                    case NBTTagLong: {
                        Optional<Long> optLong = NTools.getLong(value);
                        if (!optLong.isPresent()) break;
                        SsomarDev.testMsg("Long: " + nbtent.getLong(key), DEBUG);
                        if (nbtent.getLong(key) == optLong.get()) break;
                        invalid = true;
                        break;
                    }
                    case NBTTagFloat: {
                        Optional<Float> optFloat = NTools.getFloat(value);
                        if (!optFloat.isPresent()) break;
                        SsomarDev.testMsg("Float: " + nbtent.getFloat(key), DEBUG);
                        if (nbtent.getFloat(key) == optFloat.get()) break;
                        invalid = true;
                        break;
                    }
                    case NBTTagDouble: {
                        Optional<Double> optDouble = NTools.getDouble(value);
                        if (!optDouble.isPresent()) break;
                        SsomarDev.testMsg("Double: " + nbtent.getDouble(key), DEBUG);
                        if (nbtent.getDouble(key) == optDouble.get()) break;
                        invalid = true;
                        break;
                    }
                    case NBTTagString: {
                        if (value.toLowerCase().equals("true") || value.toLowerCase().equals("false")) {
                            SsomarDev.testMsg("Boolean: " + nbtent.getBoolean(key), DEBUG);
                            if (nbtent.getBoolean(key) == Boolean.parseBoolean(value)) break;
                            invalid = true;
                            break;
                        }
                        if (key.equalsIgnoreCase("CustomName")) {
                            String customName = entity.getCustomName();
                            SsomarDev.testMsg("String: " + customName, DEBUG);
                            if (value.equals("*") || StringConverter.decoloredString(customName).equals(value)) break;
                            invalid = true;
                            break;
                        }
                        SsomarDev.testMsg("String: " + nbtent.getString(key), DEBUG);
                        if (nbtent.getString(key).contains("\"" + value + "\"")) break;
                        invalid = true;
                    }
                }
                if (!invalid) continue;
                break;
            }
            if (invalid) continue;
            return true;
        }
        return false;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (this.notSaveIfEqualsToDefaultValue && new HashSet<String>(this.defaultValue).containsAll(this.value)) {
            config.set(this.getName(), null);
            return;
        }
        config.set(this.getName(), this.value);
    }

    public List<String> getValues() {
        return this.value;
    }

    @Override
    public ListDetailedEntityFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        gui.updateConditionList(this.getEditorName(), this.getValues(), "&cEMPTY");
    }

    @Override
    public ListDetailedEntityFeature clone(FeatureParentInterface newParent) {
        ListDetailedEntityFeature clone = new ListDetailedEntityFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.isNotSaveIfEqualsToDefaultValue());
        clone.setValue(this.getValues());
        return clone;
    }

    @Override
    public void reset() {
        this.value = new ArrayList<String>(this.defaultValue);
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        String s = StringConverter.decoloredString(message);
        if (s.startsWith(symbolNegation)) {
            s = s.substring(1);
        }
        String entityTypeStr = s;
        if (s.contains(mythicMobsSymbol)) {
            return Optional.empty();
        }
        if (s.contains(symbolStart)) {
            entityTypeStr = s.split("\\{")[0];
            if (SCore.hasNBTAPI) {
                String datas = s.split("\\{")[1].replace(symbolEnd, "");
                for (String data : datas.split(symbolSeparator)) {
                    String[] dataSplit = data.split(symbolEquals);
                    if (dataSplit.length == 2) continue;
                    return Optional.of("&4&l[ERROR] &cThe message you entered contains an invalid format  &6>> Example : ZOMBIE{CustomName:\"My name\"}   PIG{Invulnerable:1} &7(Check the wiki if you want more examples)");
                }
            } else {
                return Optional.of("&4&l[ERROR] &cThe message you entered contains Tags, but it requires the plugin NBTAPI ! so please install it or don't enter tags !");
            }
        }
        try {
            EntityType.valueOf((String)entityTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return Optional.of("&4&l[ERROR] &cThe message you entered contains an invalid EntityType ! (Check the wiki if you want the list)");
        }
        return Optional.empty();
    }

    @Override
    public List<String> getCurrentValues() {
        return this.value;
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        return new ArrayList<Suggestion>();
    }

    @Override
    public String getTips() {
        return "&8Example &7&oBLAZE &8- &7&oZOMBIE{CustomName:\"My name\"} &8- &e(for MythicMob) &7&oMM-&eID";
    }

    @Override
    public void finishEditInSubEditor(Player editor, NewGUIManager manager) {
        this.value = manager.currentWriting.get(editor);
        for (int i = 0; i < this.value.size(); ++i) {
            this.value.set(i, StringConverter.decoloredString(this.value.get(i)));
        }
        manager.requestWriting.remove(editor);
        manager.activeTextEditor.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ListDetailedEntityFeature.space(playerEditor);
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + symbolEquals);
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + symbolEquals, true, true, true, true, true, true, false, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }

    @Override
    @Generated
    public List<String> getValue() {
        return this.value;
    }

    @Generated
    public List<String> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public boolean isNotSaveIfEqualsToDefaultValue() {
        return this.notSaveIfEqualsToDefaultValue;
    }

    @Generated
    public void setValue(List<String> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(List<String> defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setNotSaveIfEqualsToDefaultValue(boolean notSaveIfEqualsToDefaultValue) {
        this.notSaveIfEqualsToDefaultValue = notSaveIfEqualsToDefaultValue;
    }
}

