/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.pack.spigot.interceptor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Bukkit;

public class ClientConnectionInterceptor {
    public void install(final Consumer<Channel> channelConsumer) {
        ChannelInitializer<Channel> beginInitProtocol = new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                try {
                    channelConsumer.accept(channel);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot inject incoming channel " + channel, e);
                }
            }
        };
        ChannelInboundHandlerAdapter serverHandler = new ChannelInboundHandlerAdapter((ChannelInitializer)beginInitProtocol){
            final /* synthetic */ ChannelInitializer val$beginInitProtocol;
            {
                this.val$beginInitProtocol = channelInitializer;
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                Channel channel = (Channel)msg;
                channel.pipeline().addFirst(new ChannelHandler[]{this.val$beginInitProtocol});
                ctx.fireChannelRead(msg);
            }
        };
        List<ChannelFuture> channels = this.getChannels();
        for (ChannelFuture channelFuture : channels) {
            channelFuture.channel().pipeline().addFirst(new ChannelHandler[]{serverHandler});
        }
    }

    private Method getMethodByReturnType(Class<?> clazz, Class<?> returnType) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.getReturnType().equals(returnType)).findFirst().get();
    }

    private Field getFieldByTypeAndPredicate(Class<?> clazz, Class<?> type, Function<Field, Boolean> predicate) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getType().equals(type) && (Boolean)predicate.apply((Field)field) != false).findFirst().get();
    }

    private List<ChannelFuture> getChannels() {
        String serverVersion = this.getServerVersion();
        try {
            Class<?> minecraftServerClass = Class.forName("net.minecraft.server.MinecraftServer");
            String className = "org.bukkit.craftbukkit.CraftServer";
            Class<?> getCraftServerClass = null;
            try {
                getCraftServerClass = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            className = "org.bukkit.craftbukkit." + serverVersion + ".CraftServer";
            if (getCraftServerClass == null) {
                getCraftServerClass = Class.forName(className);
            }
            Class<?> craftServerClass = getCraftServerClass;
            Object craftServerObject = craftServerClass.cast(Bukkit.getServer());
            Method craftServerGetServerMethod = craftServerClass.getDeclaredMethod("getServer", new Class[0]);
            Object minecraftServer = craftServerGetServerMethod.invoke(craftServerObject, new Object[0]);
            Method getConnectionMethod = this.getMethodByReturnType(minecraftServerClass, Class.forName("net.minecraft.server.network.ServerConnection"));
            Object serverConnection = getConnectionMethod.invoke(minecraftServer, new Object[0]);
            Field channelsField = this.getFieldByTypeAndPredicate(serverConnection.getClass(), List.class, field -> Modifier.isPrivate(field.getModifiers()));
            channelsField.setAccessible(true);
            return (List)channelsField.get(serverConnection);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private String getServerVersion() {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        return packageName.substring(packageName.lastIndexOf(46) + 1);
    }
}

