/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.emums;

import java.util.List;

public enum Comparator {
    DIFFERENT("!="),
    INFERIOR_OR_EQUALS("<="),
    SUPERIOR_OR_EQUALS(">="),
    INFERIOR("<"),
    SUPERIOR(">"),
    EQUALS("="),
    IS_CONTAINED_IN("(("),
    IS_NOT_CONTAINED_IN("(/");

    private String symbol;

    private Comparator(String symbol) {
        this.symbol = symbol;
    }

    public <T, U> boolean verify(T a, U b) {
        switch (this.ordinal()) {
            case 5: {
                return a.equals(b);
            }
            case 0: {
                return !a.equals(b);
            }
            case 3: {
                if (!(a instanceof Double) || !(b instanceof Double)) break;
                Double pA = (Double)a;
                Double pB = (Double)b;
                return pA < pB;
            }
            case 4: {
                if (!(a instanceof Double) || !(b instanceof Double)) break;
                Double pA = (Double)a;
                Double pB = (Double)b;
                return pA > pB;
            }
            case 1: {
                if (!(a instanceof Double) || !(b instanceof Double)) break;
                Double pA = (Double)a;
                Double pB = (Double)b;
                return pA <= pB;
            }
            case 2: {
                if (!(a instanceof Double) || !(b instanceof Double)) break;
                Double pA = (Double)a;
                Double pB = (Double)b;
                return pA >= pB;
            }
            case 6: {
                if (a instanceof String && b instanceof String) {
                    String pA = (String)a;
                    String pB = (String)b;
                    return pB.contains(pA);
                }
                if (!(a instanceof String) || !(b instanceof List)) break;
                String pA = (String)a;
                List pB = (List)b;
                return pB.contains(pA);
            }
            case 7: {
                if (a instanceof String && b instanceof String) {
                    String pB = (String)b;
                    String pA = (String)a;
                    return !pB.contains(pA);
                }
                if (!(a instanceof String) || !(b instanceof List)) break;
                List pB = (List)b;
                String pA = (String)a;
                return !pB.contains(pA);
            }
        }
        return false;
    }

    public Comparator getNext() {
        switch (this.ordinal()) {
            case 5: {
                return DIFFERENT;
            }
            case 0: {
                return INFERIOR;
            }
            case 3: {
                return SUPERIOR;
            }
            case 4: {
                return INFERIOR_OR_EQUALS;
            }
            case 1: {
                return SUPERIOR_OR_EQUALS;
            }
            case 2: {
                return IS_CONTAINED_IN;
            }
            case 6: {
                return IS_NOT_CONTAINED_IN;
            }
        }
        return EQUALS;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }
}

