/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.placeholders;

import com.ssomar.score.SCore;
import com.ssomar.score.events.PlaceholderLastDamageDealtEvent;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.placeholders.PlaceholdersInterface;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;

public class PlayerPlaceholdersAbstract
extends PlaceholdersInterface
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String particle;
    private final boolean acceptWithoutParticle;
    private UUID playerUUID;
    private double x;
    private double y;
    private double z;
    private float pitch;
    private float pitchPositive;
    private float yaw;
    private float yawPositive;
    private String direction;
    private float attackCharge;
    private int fixSlot;
    private double lastDamageTaken;
    private double lastDamageDealt;
    private boolean init = false;
    private double xInitial;
    private double yInitial;
    private double zInitial;
    private float pitchInitial;
    private float pitchPositiveInitial;
    private float yawInitial;
    private float yawPositiveInitial;
    private String directionInitial;
    private double xVelocity;
    private double yVelocity;
    private double zVelocity;
    private Map<String, String> placeholders;

    public PlayerPlaceholdersAbstract(String particle, boolean acceptWithoutParticle) {
        this.particle = particle;
        this.acceptWithoutParticle = acceptWithoutParticle;
        this.placeholders = new HashMap<String, String>();
    }

    public void setPlayerPlcHldr(UUID uuid) {
        this.playerUUID = uuid;
        this.reloadPlayerPlcHldr();
    }

    public void setPlayerPlcHldr(UUID uuid, int fixSlot) {
        this.playerUUID = uuid;
        this.fixSlot = fixSlot;
        this.reloadPlayerPlcHldr();
    }

    public void reloadPlayerPlcHldr() {
        if (this.playerUUID != null) {
            this.lastDamageDealt = PlaceholderLastDamageDealtEvent.getInstance().lastDamageDealt.containsKey(this.playerUUID) ? PlaceholderLastDamageDealtEvent.getInstance().lastDamageDealt.get(this.playerUUID) : 0.0;
            this.placeholders.put("%" + this.particle + "_uuid%", this.playerUUID.toString());
            Player player = Bukkit.getPlayer((UUID)this.playerUUID);
            if (player != null) {
                Location pLoc = player.getLocation();
                this.x = NTools.reduceDouble(pLoc.getX(), 2);
                this.y = NTools.reduceDouble(pLoc.getY(), 2);
                this.z = NTools.reduceDouble(pLoc.getZ(), 2);
                this.lastDamageTaken = player.getLastDamage();
                this.pitch = pLoc.getPitch();
                this.xVelocity = player.getVelocity().getX();
                this.yVelocity = player.getVelocity().getY();
                this.zVelocity = player.getVelocity().getZ();
                this.pitchPositive = this.pitch < 0.0f ? this.pitch * -1.0f : this.pitch;
                this.yaw = pLoc.getYaw();
                this.yawPositive = this.yaw < 0.0f ? this.yaw * -1.0f : this.yaw;
                float yaw = pLoc.getYaw();
                if (yaw >= -30.0f && yaw <= 30.0f) {
                    this.direction = "S";
                } else if (yaw > 30.0f && yaw < 60.0f) {
                    this.direction = "SW";
                } else if (yaw >= 60.0f && yaw <= 120.0f) {
                    this.direction = "W";
                } else if (yaw > 120.0f && yaw < 150.0f) {
                    this.direction = "NW";
                } else if (yaw >= 150.0f || yaw <= -150.0f) {
                    this.direction = "N";
                } else if (yaw > -150.0f && yaw < -120.0f) {
                    this.direction = "NE";
                } else if (yaw >= -120.0f && yaw <= -60.0f) {
                    this.direction = "E";
                } else if (yaw > -60.0f && yaw < -30.0f) {
                    this.direction = "SE";
                }
                if (!this.init) {
                    this.xInitial = this.x;
                    this.yInitial = this.y;
                    this.zInitial = this.z;
                    this.pitchInitial = this.pitch;
                    this.pitchPositiveInitial = this.pitch < 0.0f ? this.pitch * -1.0f : this.pitch;
                    this.yawInitial = yaw;
                    this.yawPositiveInitial = yaw < 0.0f ? yaw * -1.0f : yaw;
                    this.directionInitial = this.direction;
                }
                String slot = player.getInventory().getHeldItemSlot() + "";
                if (this.fixSlot != -1) {
                    slot = this.fixSlot + "";
                }
                this.attackCharge = SCore.is1v16Plus() ? player.getAttackCooldown() : 0.0f;
                if (this.acceptWithoutParticle) {
                    this.placeholders.put("%world%", pLoc.getWorld().getName());
                    this.placeholders.put("%world_lower%", pLoc.getWorld().getName().toLowerCase());
                    this.placeholders.put("%slot%", slot);
                    this.placeholders.put("%slot_live%", player.getInventory().getHeldItemSlot() + "");
                    this.placeholders.put("%direction%", this.direction);
                }
                String world = pLoc.getWorld().getName();
                this.placeholders.put("%" + this.particle + "_world%", world);
                this.placeholders.put("%" + this.particle + "_world_lower%", world.toLowerCase());
                this.placeholders.put("%" + this.particle + "_slot%", slot);
                this.placeholders.put("%" + this.particle + "_slot_live%", player.getInventory().getHeldItemSlot() + "");
                this.placeholders.put("%" + this.particle + "_direction%", this.direction);
                if (!this.init) {
                    this.placeholders.put("%" + this.particle + "_world_initial%", world);
                    this.placeholders.put("%" + this.particle + "_world_lower_initial%", world.toLowerCase());
                    this.placeholders.put("%" + this.particle + "_direction_initial%", this.direction);
                }
            }
            this.init = true;
        }
    }

    public String replacePlaceholder(String s) {
        String toReplace = s;
        if (this.playerUUID != null) {
            OfflinePlayer offlinePlayer;
            String playerName;
            if (s.contains("%" + this.particle + "_uuid_array%")) {
                toReplace = toReplace.replace("%" + this.particle + "_uuid_array%", PlayerPlaceholdersAbstract.convertedUUID(this.playerUUID));
            }
            boolean teamPlaceholder = false;
            if ((s.contains("%" + this.particle + "%") || s.contains("%" + this.particle + "_name%") || (teamPlaceholder = s.contains("%" + this.particle + "_team%"))) && (playerName = (offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.playerUUID)).getName()) != null) {
                if (teamPlaceholder) {
                    String team = "NO_TEAM";
                    for (Team t : Bukkit.getServer().getScoreboardManager().getMainScoreboard().getTeams()) {
                        if (!t.hasEntry(playerName)) continue;
                        team = t.getName();
                        break;
                    }
                    toReplace = toReplace.replace("%" + this.particle + "_team%", team);
                }
                toReplace = toReplace.replace("%" + this.particle + "%", playerName);
                toReplace = toReplace.replace("%" + this.particle + "_name%", playerName);
            }
            if (this.acceptWithoutParticle) {
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%x%", this.x + "", false);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%y%", this.y + "", false);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%z%", this.z + "", false);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%x_int%", (int)this.x + "", true);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%y_int%", (int)this.y + "", true);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%z_int%", (int)this.z + "", true);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%last_damage_taken%", this.lastDamageTaken + "", false);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%last_damage_taken_int%", (int)this.lastDamageTaken + "", true);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%last_damage_dealt%", this.lastDamageDealt + "", false);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%last_damage_dealt_int%", (int)this.lastDamageDealt + "", true);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%x_velocity%", String.valueOf(this.xVelocity), false);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%y_velocity%", String.valueOf(this.yVelocity), false);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%z_velocity%", String.valueOf(this.zVelocity), false);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%x_velocity_int%", String.valueOf((int)this.xVelocity), true);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%y_velocity_int%", String.valueOf((int)this.yVelocity), true);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%z_velocity_int%", String.valueOf((int)this.zVelocity), true);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%pitch%", this.pitch + "", false);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%pitch_int%", (int)this.pitch + "", true);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%pitch_positive%", this.pitchPositive + "", false);
                toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%pitch_positive_int%", (int)this.pitchPositive + "", false);
            }
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_x%", this.x + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_y%", this.y + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_z%", this.z + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_x_int%", (int)this.x + "", true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_y_int%", (int)this.y + "", true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_z_int%", (int)this.z + "", true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_x_initial%", this.xInitial + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_y_initial%", this.yInitial + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_z_initial%", this.zInitial + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_x_initial_int%", (int)this.xInitial + "", true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_y_initial_int%", (int)this.yInitial + "", true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_z_initial_int%", (int)this.zInitial + "", true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_x_velocity%", String.valueOf(this.xVelocity), false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_y_velocity%", String.valueOf(this.yVelocity), false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_z_velocity%", String.valueOf(this.zVelocity), false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_x_velocity_int%", String.valueOf((int)this.xVelocity), true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_y_velocity_int%", String.valueOf((int)this.yVelocity), true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_z_velocity_int%", String.valueOf((int)this.zVelocity), true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_last_damage_taken%", this.lastDamageTaken + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_last_damage_taken_int%", (int)this.lastDamageTaken + "", true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_last_damage_dealt%", this.lastDamageTaken + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_last_damage_dealt_int%", (int)this.lastDamageTaken + "", true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_pitch%", this.pitch + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_pitch_int%", (int)this.pitch + "", true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_pitch_positive%", this.pitchPositive + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_pitch_positive_int%", (int)this.pitchPositive + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_pitch_initial%", this.pitchInitial + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_pitch_initial_int%", (int)this.pitchInitial + "", true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_pitch_positive_initial%", this.pitchPositiveInitial + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_pitch_positive_initial_int%", (int)this.pitchPositiveInitial + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_yaw%", this.yaw + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_yaw_int%", (int)this.yaw + "", true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_yaw_positive%", this.yawPositive + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_yaw_positive_int%", (int)this.yawPositive + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_yaw_initial%", this.yawInitial + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_yaw_initial_int%", (int)this.yawInitial + "", true);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_yaw_positive_initial%", this.yawPositiveInitial + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_yaw_positive_initial_int%", (int)this.yawPositiveInitial + "", false);
            toReplace = PlayerPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_attack_charge%", this.attackCharge + "", false);
        }
        return toReplace;
    }

    public static String convertedUUID(UUID uuid) {
        StringBuilder sb = new StringBuilder();
        sb.append("[I;");
        String uuidStr = uuid.toString().replaceAll("-", "").toUpperCase();
        sb.append(PlayerPlaceholdersAbstract.getDecimal(uuidStr.substring(0, 8)));
        sb.append(",");
        sb.append(PlayerPlaceholdersAbstract.getDecimal(uuidStr.substring(8, 16)));
        sb.append(",");
        sb.append(PlayerPlaceholdersAbstract.getDecimal(uuidStr.substring(16, 24)));
        sb.append(",");
        sb.append(PlayerPlaceholdersAbstract.getDecimal(uuidStr.substring(24, 32)));
        sb.append("]");
        return sb.toString();
    }

    public static int getDecimal(String hex) {
        String digits = "0123456789ABCDEF";
        hex = hex.toUpperCase();
        int val2 = 0;
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            int d = digits.indexOf(c);
            val2 = 16 * val2 + d;
        }
        return val2;
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Generated
    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }
}

