/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.safeplace;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.usedapi.BentoBoxAPI;
import com.ssomar.score.usedapi.ExcellentClaimsAPI;
import com.ssomar.score.usedapi.FactionsUUIDAPI;
import com.ssomar.score.usedapi.GriefPreventionAPI;
import com.ssomar.score.usedapi.IridiumSkyblockTool;
import com.ssomar.score.usedapi.LandsIntegrationAPI;
import com.ssomar.score.usedapi.ProtectionStonesAPI;
import com.ssomar.score.usedapi.ResidenceAPI;
import com.ssomar.score.usedapi.SuperiorSkyblockTool;
import com.ssomar.score.usedapi.WorldGuardAPI;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafePlace {
    private static final boolean DEBUG = false;

    public static void placeBlockWithEvent(@NotNull Block block, @NotNull Material material, Optional<Map<String, String>> statesOpt, @Nullable UUID playerUUID, boolean generatePlaceEvent, boolean verifSafePlace) {
        SafePlace.placeBlockWithEvent(block, material, statesOpt, playerUUID, generatePlaceEvent, verifSafePlace, true);
    }

    public static void placeBlockWithEvent(final @NotNull Block block, final @NotNull Material material, Optional<Map<String, String>> statesOpt, @Nullable UUID playerUUID, boolean generatePlaceEvent, boolean verifSafePlace, boolean enablePhysics) {
        SsomarDev.testMsg("DEBUG SAFE PLACE 1", false);
        if (playerUUID == null) {
            block.setType(material, enablePhysics);
            return;
        }
        SsomarDev.testMsg("DEBUG SAFE PLACE 1.5", false);
        if (verifSafePlace && !SafePlace.verifSafePlace(playerUUID, block)) {
            return;
        }
        final Player player = Bukkit.getServer().getPlayer(playerUUID);
        Location location = block.getLocation();
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                SsomarDev.testMsg("DEBUG SAFE BREAK 2", false);
                if (player != null) {
                    SsomarDev.testMsg("DEBUG SAFE BREAK 3 >> " + material, false);
                    SafePlace.setBlockType(block, material);
                } else {
                    SafePlace.setBlockType(block, material);
                }
            }
        };
        SCore.schedulerHook.runLocationTask((Runnable)runnable, location, 0L);
    }

    public static void setBlockType(Block block, Material material) {
        block.setType(material);
    }

    public static boolean verifSafePlace(@NotNull UUID playerUUID, @NotNull Block block) {
        return SafePlace.verifSafePlace(playerUUID, block.getLocation());
    }

    public static boolean verifSafePlace(@NotNull UUID playerUUID, @NotNull Location location) {
        if (Bukkit.getOfflinePlayer((UUID)playerUUID).isOp()) {
            return true;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK CDT 1", false);
        if (SCore.hasGriefPrevention && !GriefPreventionAPI.playerCanPlaceClaimBlock(playerUUID, location)) {
            return false;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK CDT 2", false);
        if (SCore.hasIridiumSkyblock && !IridiumSkyblockTool.playerCanPlaceIslandBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasSuperiorSkyblock2 && !SuperiorSkyblockTool.playerCanPlaceIslandBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasBentoBox && !BentoBoxAPI.playerCanPlaceIslandBlock(playerUUID, location)) {
            return false;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK CDT 3", false);
        if (SCore.hasLands && !new LandsIntegrationAPI((Plugin)SCore.plugin).playerCanPlaceClaimBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasFactionsUUID && !new FactionsUUIDAPI().playerCanPlaceClaimBlock(playerUUID, location)) {
            return false;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK CDT 4", false);
        if (SCore.hasWorldGuard && !WorldGuardAPI.playerCanPlaceInRegion(playerUUID, location)) {
            return false;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK CDT 5", false);
        if (SCore.hasResidence && !ResidenceAPI.playerCanPlaceClaimBlock(playerUUID, location)) {
            return false;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK CDT 6", false);
        if (SCore.hasProtectionStones && !ProtectionStonesAPI.playerCanPlaceClaimBlock(playerUUID, location)) {
            return false;
        }
        return !SCore.hasExcellentClaims || ExcellentClaimsAPI.playerCanPlaceClaimBlock(playerUUID, location);
    }
}

