/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.actionbar;

import com.ssomar.score.SCore;
import com.ssomar.score.actionbar.Actionbar;
import com.ssomar.score.configs.messages.Message;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ActionbarHandler {
    private static ActionbarHandler instance;
    private final HashMap<Player, List<Actionbar>> actionbarHandler = new HashMap();
    private List<Player> hideActionbar = new ArrayList<Player>();

    public static ActionbarHandler getInstance() {
        if (instance == null) {
            instance = new ActionbarHandler();
        }
        return instance;
    }

    public void load() {
        this.startActionbarDisplay();
    }

    public void startActionbarDisplay() {
        Runnable runnable = new Runnable(){
            int cpt = 1;

            @Override
            public void run() {
                ArrayList<Player> playerEmpty = new ArrayList<Player>();
                for (Player player : ActionbarHandler.this.actionbarHandler.keySet()) {
                    List actionbars = (List)ActionbarHandler.this.actionbarHandler.get(player);
                    if (player.isOnline()) {
                        boolean oneIsRemove;
                        if (!ActionbarHandler.this.hideActionbar.contains(player)) {
                            ActionbarHandler.this.displayDesactivationActionbars(actionbars, player);
                        }
                        boolean bl = oneIsRemove = ActionbarHandler.this.removeDesactionActionabars(actionbars) != 0;
                        if (actionbars.size() == 0) {
                            playerEmpty.add(player);
                            continue;
                        }
                        ActionbarHandler.this.activeActionbarIfNotExist(actionbars);
                        if (this.cpt == 10) {
                            ActionbarHandler.this.activeNextActionbar(actionbars);
                            this.cpt = 1;
                        } else {
                            ++this.cpt;
                        }
                        if (!oneIsRemove && !ActionbarHandler.this.hideActionbar.contains(player)) {
                            ActionbarHandler.this.displayActiveActionbar(actionbars, player);
                        }
                    }
                    ActionbarHandler.this.decrementTimeActionbars(actionbars);
                }
            }
        };
        SCore.schedulerHook.runRepeatingTask(runnable, 0L, 20L);
    }

    public void removeActionbars(Player p) {
        this.actionbarHandler.remove(p);
    }

    public void addActionbar(Player player, Actionbar actionbar) {
        if (!this.actionbarHandler.containsKey(player)) {
            ArrayList<Actionbar> list = new ArrayList<Actionbar>();
            list.add(actionbar);
            this.actionbarHandler.put(player, list);
        } else {
            this.actionbarHandler.get(player).add(actionbar);
        }
    }

    public void activeActionbarIfNotExist(List<Actionbar> actionbars) {
        boolean existActiveActionbar = false;
        for (Actionbar actionbar : actionbars) {
            if (!actionbar.isActive()) continue;
            existActiveActionbar = true;
            break;
        }
        if (!existActiveActionbar && actionbars.size() >= 1) {
            actionbars.get(0).setActive(true);
        }
    }

    public int removeDesactionActionabars(List<Actionbar> actionbars) {
        ArrayList<Actionbar> toRemove = new ArrayList<Actionbar>();
        for (Actionbar actionbar : actionbars) {
            if (!actionbar.isDesactivation()) continue;
            toRemove.add(actionbar);
        }
        for (Actionbar actionbar : toRemove) {
            actionbars.remove(actionbar);
        }
        return toRemove.size();
    }

    public void displayDesactivationActionbars(List<Actionbar> actionbars, Player p) {
        StringPlaceholder sp = new StringPlaceholder();
        sp.setPlayerPlcHldr(p.getUniqueId());
        ArrayList<Actionbar> desactivation = new ArrayList<Actionbar>();
        for (Actionbar actionbar : actionbars) {
            if (!actionbar.isDesactivation()) continue;
            desactivation.add(actionbar);
        }
        if (desactivation.size() >= 1) {
            StringBuilder items = new StringBuilder();
            for (Actionbar a : desactivation) {
                items.append(" ").append(a.getName());
            }
            sp.setItem(items.toString());
            String string = sp.replacePlaceholder(MessageMain.getInstance().getMessage((Plugin)SCore.plugin, Message.ACTIONBAR_END));
            Bukkit.getServer().getPlayer(p.getName()).spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string));
        }
    }

    public void decrementTimeActionbars(List<Actionbar> actionbars) {
        for (Actionbar actionbar : actionbars) {
            if (actionbar.getTime() - 1 == 0) {
                actionbar.setDesactivation(true);
                actionbar.setTime(-1);
                continue;
            }
            actionbar.setTime(actionbar.getTime() - 1);
        }
    }

    public void activeNextActionbar(List<Actionbar> actionbars) {
        int activeAB = this.getActiveActionbar(actionbars);
        if (activeAB + 1 > actionbars.size() - 1) {
            actionbars.get(activeAB).setActive(false);
            actionbars.get(0).setActive(true);
        } else {
            actionbars.get(activeAB).setActive(false);
            actionbars.get(activeAB + 1).setActive(true);
        }
    }

    public int getActiveActionbar(List<Actionbar> actionbars) {
        int cpt = 0;
        for (Actionbar actionbar : actionbars) {
            if (actionbar.isActive()) {
                return cpt;
            }
            ++cpt;
        }
        return Integer.MIN_VALUE;
    }

    public void displayActiveActionbar(List<Actionbar> actionbars, Player p) {
        Actionbar actionbar = actionbars.get(this.getActiveActionbar(actionbars));
        StringPlaceholder sp = new StringPlaceholder();
        sp.setItem(actionbar.getName());
        sp.getTimePlch().setTimePlcHldr(actionbar.getTime().intValue());
        sp.setPlayerPlcHldr(p.getUniqueId());
        String message = sp.replacePlaceholder(MessageMain.getInstance().getMessage((Plugin)SCore.plugin, Message.ACTIONBAR_MESSAGE));
        Bukkit.getServer().getPlayer(p.getName()).spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
    }

    @Generated
    public List<Player> getHideActionbar() {
        return this.hideActionbar;
    }

    @Generated
    public void setHideActionbar(List<Player> hideActionbar) {
        this.hideActionbar = hideActionbar;
    }
}

