/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.aroundblock.group;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.aroundblock.aroundblock.AroundBlockFeature;
import com.ssomar.score.features.custom.aroundblock.group.AroundBlockGroupFeatureEditor;
import com.ssomar.score.features.custom.aroundblock.group.AroundBlockGroupFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class AroundBlockGroupFeature
extends FeatureWithHisOwnEditor<AroundBlockGroupFeature, AroundBlockGroupFeature, AroundBlockGroupFeatureEditor, AroundBlockGroupFeatureEditorManager>
implements FeaturesGroup<AroundBlockFeature> {
    private Map<String, AroundBlockFeature> aroundBlockGroup;
    private boolean notSaveIfNoValue;

    public AroundBlockGroupFeature(FeatureParentInterface parent, boolean notSaveIfNoValue) {
        super(parent, FeatureSettingsSCore.aroundBlockCdts);
        this.notSaveIfNoValue = notSaveIfNoValue;
        this.reset();
    }

    @Override
    public void reset() {
        this.aroundBlockGroup = new LinkedHashMap<String, AroundBlockFeature>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                AroundBlockFeature attribute = new AroundBlockFeature((FeatureParentInterface)this, attributeID);
                List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.aroundBlockGroup.put(attributeID, attribute);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfNoValue && this.aroundBlockGroup.size() == 0) {
            return;
        }
        ConfigurationSection attributesSection = config.createSection(this.getName());
        for (String enchantmentID : this.aroundBlockGroup.keySet()) {
            this.aroundBlockGroup.get(enchantmentID).save(attributesSection);
        }
    }

    @Override
    public AroundBlockGroupFeature getValue() {
        return this;
    }

    @Override
    public AroundBlockGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oBlock around cdt(s) added: &e" + this.aroundBlockGroup.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public AroundBlockFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (AroundBlockFeature x : this.aroundBlockGroup.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public AroundBlockGroupFeature clone(FeatureParentInterface newParent) {
        AroundBlockGroupFeature eF = new AroundBlockGroupFeature(newParent, this.isNotSaveIfNoValue());
        LinkedHashMap<String, AroundBlockFeature> newAroundBlockGroup = new LinkedHashMap<String, AroundBlockFeature>();
        for (String x : this.aroundBlockGroup.keySet()) {
            newAroundBlockGroup.put(x, this.aroundBlockGroup.get(x).clone(eF));
        }
        eF.setAroundBlockGroup(newAroundBlockGroup);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.aroundBlockGroup.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof AroundBlockGroupFeature)) continue;
            AroundBlockGroupFeature eF = (AroundBlockGroupFeature)feature;
            eF.setAroundBlockGroup(this.getAroundBlockGroup());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        AroundBlockGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "blockAround";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.aroundBlockGroup.containsKey(id)) continue;
            AroundBlockFeature eF = new AroundBlockFeature((FeatureParentInterface)this, id);
            this.aroundBlockGroup.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, AroundBlockFeature feature) {
        this.aroundBlockGroup.remove(feature.getId());
    }

    @Generated
    public Map<String, AroundBlockFeature> getAroundBlockGroup() {
        return this.aroundBlockGroup;
    }

    @Generated
    public boolean isNotSaveIfNoValue() {
        return this.notSaveIfNoValue;
    }

    @Generated
    public void setAroundBlockGroup(Map<String, AroundBlockFeature> aroundBlockGroup) {
        this.aroundBlockGroup = aroundBlockGroup;
    }

    @Generated
    public void setNotSaveIfNoValue(boolean notSaveIfNoValue) {
        this.notSaveIfNoValue = notSaveIfNoValue;
    }
}

