/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.condition;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.types.list.ListRegionStringFeature;
import com.ssomar.score.usedapi.WorldGuardAPI;
import java.util.ArrayList;
import org.bukkit.entity.Player;

public class IfNotInRegion
extends PlayerConditionFeature<ListRegionStringFeature, IfNotInRegion> {
    public IfNotInRegion(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifNotInRegion);
    }

    @Override
    public boolean verifCondition(PlayerConditionRequest request) {
        if (SCore.hasWorldGuard) {
            Player player = request.getPlayer();
            if (this.hasCondition() && new WorldGuardAPI().isInRegion(player, ((ListRegionStringFeature)this.getCondition()).getValue(request.getSp()))) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfNotInRegion getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new ListRegionStringFeature(this.getParent(), new ArrayList<String>(), FeatureSettingsSCore.ifNotInRegion, true));
    }

    @Override
    public boolean hasCondition() {
        return ((ListRegionStringFeature)this.getCondition()).getValue().size() > 0;
    }

    @Override
    public IfNotInRegion getNewInstance(FeatureParentInterface parent) {
        return new IfNotInRegion(parent);
    }
}

