/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.detailedslots;

import com.ssomar.score.SCore;
import com.ssomar.score.features.custom.detailedslots.DetailedSlots;
import com.ssomar.score.features.editor.FeatureEditorInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.utils.item.MakeItemGlow;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class DetailedSlotsEditor
extends FeatureEditorInterface<DetailedSlots> {
    public final DetailedSlots detailedSlots;

    public DetailedSlotsEditor(DetailedSlots dropFeatures) {
        super("&lDetailed slots Editor", 54);
        this.detailedSlots = dropFeatures.clone(dropFeatures.getParent());
        this.load();
    }

    @Override
    public void load() {
        int j;
        List<Integer> slots = this.detailedSlots.getSlots();
        int i = 0;
        for (j = 9; j < 36; ++j) {
            this.updateSlot(i, j, slots.contains(j));
            ++i;
        }
        this.createItem(Material.LEVER, 1, i += 3, "&7&oDisable all slots", false, false, "", "&c\u270e Click here to disable");
        ++i;
        this.createItem(Material.LEVER, 1, ++i, "&7&oEnable all slots", false, false, "", "&a\u270e Click here to enable");
        ++i;
        i += 3;
        for (j = 0; j < 9; ++j) {
            this.updateSlot(i, j, slots.contains(j));
            ++i;
        }
        this.updateSlotHelmet(i, slots.contains(39));
        this.updateSlotChestplate(++i, slots.contains(38));
        this.updateSlotLeggings(++i, slots.contains(37));
        this.updateSlotBoots(++i, slots.contains(36));
        this.updateSlotOffHand(++i, slots.contains(40));
        this.updateSlotMainHand(++i, slots.contains(-1));
        ++i;
        this.createItem(RED, 1, ++i, GUI.BACK, false, false, new String[0]);
        this.createItem(GREEN, 1, ++i, GUI.SAVE, false, false, "", "&a&oClick here to save");
    }

    @Override
    public DetailedSlots getParent() {
        return this.detailedSlots;
    }

    public void disableAllSlots() {
        this.detailedSlots.setSlots(new ArrayList<Integer>());
        this.clearAndSetBackground();
        this.load();
    }

    public void enableAllSlots() {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = -1; i <= 40; ++i) {
            slots.add(i);
        }
        this.detailedSlots.setSlots(slots);
        this.clearAndSetBackground();
        this.load();
    }

    public void updateSlotMainHand(int i, boolean enable) {
        if (enable) {
            this.createItem(Material.STICK, 1, i, "&eSlot: mainHand", true, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &aEnable");
        } else {
            this.createItem(Material.STICK, 1, i, "&eSlot: mainHand", false, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &cDisable");
        }
    }

    public void changeSlotMainHand() {
        ItemStack item = this.getByIdentifier("Slot: mainHand");
        if (this.addOrRemoveEnchant(item)) {
            this.detailedSlots.getSlots().remove((Object)-1);
        } else {
            this.detailedSlots.getSlots().add(-1);
        }
    }

    public void updateSlotOffHand(int i, boolean enable) {
        Material offHandMat = SCore.is1v11Less() ? Material.BARRIER : Material.SHIELD;
        if (enable) {
            this.createItem(offHandMat, 1, i, "&eSlot: offHand", true, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &aEnable");
        } else {
            this.createItem(offHandMat, 1, i, "&eSlot: offHand", false, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &cDisable");
        }
    }

    public void changeSlotOffHand() {
        ItemStack item = this.getByIdentifier("Slot: offHand");
        if (this.addOrRemoveEnchant(item)) {
            this.detailedSlots.getSlots().remove((Object)40);
        } else {
            this.detailedSlots.getSlots().add(40);
        }
    }

    public boolean addOrRemoveEnchant(ItemStack item) {
        if (this.getCurrently(item).contains("Enable")) {
            this.updateCurrently(item, "&cDisable");
            for (Enchantment e : item.getItemMeta().getEnchants().keySet()) {
                item.removeEnchantment(e);
            }
            return true;
        }
        this.updateCurrently(item, "&aEnable");
        MakeItemGlow.makeGlow(item);
        return false;
    }

    public void updateSlotBoots(int i, boolean enable) {
        if (enable) {
            this.createItem(Material.DIAMOND_BOOTS, 1, i, "&eSlot: boots", true, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &aEnable");
        } else {
            this.createItem(Material.DIAMOND_BOOTS, 1, i, "&eSlot: boots", false, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &cDisable");
        }
    }

    public void changeSlotBoots() {
        ItemStack item = this.getByIdentifier("Slot: boots");
        if (this.addOrRemoveEnchant(item)) {
            this.detailedSlots.getSlots().remove((Object)36);
        } else {
            this.detailedSlots.getSlots().add(36);
        }
    }

    public void updateSlotLeggings(int i, boolean enable) {
        if (enable) {
            this.createItem(Material.DIAMOND_LEGGINGS, 1, i, "&eSlot: leggings", true, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &aEnable");
        } else {
            this.createItem(Material.DIAMOND_LEGGINGS, 1, i, "&eSlot: leggings", false, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &cDisable");
        }
    }

    public void changeSlotLeggings() {
        ItemStack item = this.getByIdentifier("Slot: leggings");
        if (this.addOrRemoveEnchant(item)) {
            this.detailedSlots.getSlots().remove((Object)37);
        } else {
            this.detailedSlots.getSlots().add(37);
        }
    }

    public void updateSlotChestplate(int i, boolean enable) {
        if (enable) {
            this.createItem(Material.DIAMOND_CHESTPLATE, 1, i, "&eSlot: chestplate", true, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &aEnable");
        } else {
            this.createItem(Material.DIAMOND_CHESTPLATE, 1, i, "&eSlot: chestplate", false, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &cDisable");
        }
    }

    public void changeSlotChestplate() {
        ItemStack item = this.getByIdentifier("Slot: chestplate");
        if (this.addOrRemoveEnchant(item)) {
            this.detailedSlots.getSlots().remove((Object)38);
        } else {
            this.detailedSlots.getSlots().add(38);
        }
    }

    public void updateSlotHelmet(int i, boolean enable) {
        if (enable) {
            this.createItem(Material.DIAMOND_HELMET, 1, i, "&eSlot: helmet", true, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &aEnable");
        } else {
            this.createItem(Material.DIAMOND_HELMET, 1, i, "&eSlot: helmet", false, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &cDisable");
        }
    }

    public void changeSlotHelmet() {
        ItemStack item = this.getByIdentifier("Slot: helmet");
        if (this.addOrRemoveEnchant(item)) {
            this.detailedSlots.getSlots().remove((Object)39);
        } else {
            this.detailedSlots.getSlots().add(39);
        }
    }

    public void updateSlot(int i, int slot, boolean enable) {
        if (enable) {
            if (!SCore.is1v12Less()) {
                this.createItem(Material.GREEN_WOOL, 1, i, "&eSlot: " + slot, false, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &aEnable");
            } else {
                this.createItem(Material.EMERALD, 1, i, "&eSlot: " + slot, false, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &aEnable");
            }
        } else if (!SCore.is1v12Less()) {
            this.createItem(Material.RED_WOOL, 1, i, "&eSlot: " + slot, false, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &cDisable");
        } else {
            this.createItem(Material.REDSTONE, 1, i, "&eSlot: " + slot, false, false, "", "&a\u270e Click here to change", TM.g(Text.EDITOR_CURRENTLY_NAME) + " &cDisable");
        }
    }

    public void changeSlot(int i) {
        ItemStack item = this.getByIdentifier("Slot: " + i);
        String currently = this.getCurrently(item);
        if (currently.contains("Enable")) {
            this.updateCurrently(item, "&cDisable");
            if (!SCore.is1v12Less()) {
                item.setType(Material.RED_WOOL);
            } else {
                item.setType(Material.REDSTONE);
            }
            this.detailedSlots.getSlots().remove((Object)i);
        } else {
            this.updateCurrently(item, "&aEnable");
            if (!SCore.is1v12Less()) {
                item.setType(Material.GREEN_WOOL);
            } else {
                item.setType(Material.EMERALD);
            }
            this.detailedSlots.getSlots().add(i);
        }
    }
}

