/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.nbttags;

import com.ssomar.score.features.custom.nbttags.NBTTag;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class StringNBTTag
extends NBTTag {
    private String valueString;
    private boolean isValueString;

    public StringNBTTag(ConfigurationSection configurationSection) {
        super(configurationSection);
    }

    public StringNBTTag(String key, String valueString) {
        super(key);
        this.valueString = valueString;
        this.isValueString = true;
    }

    @Override
    public boolean applyTo(ReadWriteNBT nbtItem, boolean onlyIfDifferent) {
        if (!onlyIfDifferent || !nbtItem.getString(this.getKey()).equals(this.getValueString())) {
            nbtItem.setString(this.getKey(), this.getValueString());
            return true;
        }
        return false;
    }

    @Override
    public boolean applyTo(NBTCompound nbtCompound, boolean onlyIfDifferent) {
        if (!onlyIfDifferent || !nbtCompound.getString(this.getKey()).equals(this.getValueString())) {
            nbtCompound.setString(this.getKey(), this.getValueString());
            return true;
        }
        return false;
    }

    @Override
    public void saveValueInConfig(ConfigurationSection configurationSection, Integer index) {
        configurationSection.set("nbt." + index + ".type", (Object)"STRING");
        configurationSection.set("nbt." + index + ".value", (Object)this.getValueString());
    }

    @Override
    public void loadValueFromConfig(ConfigurationSection configurationSection) {
        this.valueString = configurationSection.getString("value", "");
    }

    public String toString() {
        return "STRING::" + this.getKey() + "::" + this.getValueString();
    }

    @Generated
    public String getValueString() {
        return this.valueString;
    }
}

