/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.scheduler;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateGenerator {
    public static List<Long> generateNextValidTimestamps(Date startDate, List<String> dateFormats, long calculationTime, Date minDate, Date maxDate) {
        ArrayList<Long> timestamps = new ArrayList<Long>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        int maxField = DateGenerator.getMaxField(dateFormats);
        long maxSearch = System.currentTimeMillis() + calculationTime;
        while (timestamps.size() < 100 && calendar.getTimeInMillis() < maxSearch && calendar.getTimeInMillis() < maxDate.getTime() && calendar.getTimeInMillis() > minDate.getTime()) {
            for (String format : dateFormats) {
                if (timestamps.size() >= 100) break;
                if (!DateGenerator.isValid(calendar, format)) continue;
                timestamps.add(calendar.getTimeInMillis());
            }
            calendar.add(maxField, 1);
        }
        return timestamps;
    }

    private static int getMaxField(List<String> dateFormats) {
        int maxField = 13;
        for (String format : dateFormats) {
            int field = DateGenerator.getMinimumFieldToAdvance(format);
            if (field <= maxField) continue;
            maxField = field;
        }
        return maxField;
    }

    private static int getMinimumFieldToAdvance(String format) {
        String[] parts = null;
        if (format.contains(":::")) {
            parts = format.split(":::");
        } else if (format.contains(":!:")) {
            parts = format.split(":!:");
        }
        if (!parts[5].equals("XX")) {
            return 13;
        }
        if (!parts[4].equals("XX")) {
            return 12;
        }
        if (!parts[3].equals("XX")) {
            return 11;
        }
        if (!parts[2].equals("XX")) {
            return 7;
        }
        if (!parts[1].equals("XX")) {
            return 3;
        }
        return 1;
    }

    private static boolean isValid(Calendar calendar, String format) {
        if (format.contains(":::")) {
            return DateGenerator.isValidTripleColonFormat(calendar, format);
        }
        if (format.contains(":!:")) {
            return DateGenerator.isValidExclamationFormat(calendar, format);
        }
        return false;
    }

    private static boolean isValidTripleColonFormat(Calendar calendar, String format) {
        String[] parts = format.split(":::");
        int year = DateGenerator.getFieldValue(parts[0], calendar.get(1));
        int month = DateGenerator.getFieldValue(parts[1], calendar.get(2) + 1) - 1;
        int day = DateGenerator.getFieldValue(parts[2], calendar.get(5));
        int hour = DateGenerator.getFieldValue(parts[3], calendar.get(11));
        int minute = DateGenerator.getFieldValue(parts[4], calendar.get(12));
        int second = DateGenerator.getFieldValue(parts[5], calendar.get(13));
        return calendar.get(1) == year && calendar.get(2) == month && calendar.get(5) == day && calendar.get(11) == hour && calendar.get(12) == minute && calendar.get(13) == second;
    }

    private static boolean isValidExclamationFormat(Calendar calendar, String format) {
        String[] parts = format.split(":!:");
        int year = DateGenerator.getFieldValue(parts[0], calendar.get(1));
        int week = DateGenerator.getFieldValue(parts[1], calendar.get(3));
        int dayOfWeek = DateGenerator.getDayOfWeek(parts[2], calendar.get(7));
        int hour = DateGenerator.getFieldValue(parts[3], calendar.get(11));
        int minute = DateGenerator.getFieldValue(parts[4], calendar.get(12));
        int second = DateGenerator.getFieldValue(parts[5], calendar.get(13));
        return calendar.get(1) == year && calendar.get(3) == week && calendar.get(7) == dayOfWeek && calendar.get(11) == hour && calendar.get(12) == minute && calendar.get(13) == second;
    }

    private static int getDayOfWeek(String formatPart, int currentDayOfWeek) {
        if (formatPart.equals("%%%") || formatPart.equals("%%") || formatPart.equals("%") || formatPart.equals("%%%%")) {
            return currentDayOfWeek;
        }
        if (formatPart.equals("XX")) {
            return 1;
        }
        switch (formatPart.toUpperCase()) {
            case "MONDAY": {
                return 2;
            }
            case "TUESDAY": {
                return 3;
            }
            case "WEDNESDAY": {
                return 4;
            }
            case "THURSDAY": {
                return 5;
            }
            case "FRIDAY": {
                return 6;
            }
            case "SATURDAY": {
                return 7;
            }
            case "SUNDAY": {
                return 1;
            }
        }
        return currentDayOfWeek;
    }

    private static int getFieldValue(String formatPart, int currentValue) {
        if (formatPart.equals("%%%") || formatPart.equals("%%%%") || formatPart.equals("%%") || formatPart.equals("%")) {
            return currentValue;
        }
        if (formatPart.equals("XX")) {
            return 0;
        }
        if (formatPart.startsWith("[")) {
            String[] values;
            for (String value : values = formatPart.replace("[", "").replace("]", "").split(",")) {
                if (Integer.parseInt(value) != currentValue) continue;
                return currentValue;
            }
        } else {
            return Integer.parseInt(formatPart);
        }
        return -1;
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date currentDate = new Date();
        ArrayList<String> dateFormats = new ArrayList<String>();
        dateFormats.add("2024:::12:::[24,25,26]:::16:::XX:::XX");
        dateFormats.add("%%%%:::%%:::%%:::04:::XX:::XX");
        dateFormats.add("%%%%:!:%%:!:MONDAY:!:XX:!:XX:!:XX");
        dateFormats.add("%%%%:!:42:!:XX:!:%%:!:XX:!:XX");
    }
}

