/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.sparticles;

import com.google.common.base.Charsets;
import com.ssomar.score.sparticles.SParticle;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.CustomColor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class SParticles {
    private final SPlugin sPlugin;
    private final String filePath;
    private final String configurationSectionPath;
    private final List<SParticle> particles;

    public SParticles(SPlugin sPlugin, String filePath, String configurationSectionPath, ConfigurationSection section, boolean showError) {
        this.sPlugin = sPlugin;
        this.filePath = filePath;
        this.configurationSectionPath = configurationSectionPath;
        this.particles = new ArrayList<SParticle>();
        ConfigurationSection mainSection = section;
        if (!configurationSectionPath.isEmpty() && section.isConfigurationSection(configurationSectionPath)) {
            mainSection = section.getConfigurationSection(configurationSectionPath);
        }
        if (mainSection.isConfigurationSection("particles")) {
            ConfigurationSection particlesSection = mainSection.getConfigurationSection("particles");
            for (String id : particlesSection.getKeys(false)) {
                Optional<SParticle> sParticleOpt = SParticle.loadSParticle(sPlugin, filePath + configurationSectionPath, particlesSection.getConfigurationSection(id), id, showError);
                sParticleOpt.ifPresent(sParticle -> this.particles.add((SParticle)sParticle));
            }
        }
    }

    public void addParticle(SParticle sParticle) {
        this.particles.add(sParticle);
    }

    public void removeParticle(String id) {
        SParticle toRemove = null;
        for (SParticle sParticle : this.particles) {
            if (!sParticle.getId().equals(id)) continue;
            toRemove = sParticle;
            break;
        }
        if (toRemove != null) {
            this.particles.remove(toRemove);
        }
    }

    public Optional<SParticle> getParticle(String id) {
        Object toRemove = null;
        for (SParticle sParticle : this.particles) {
            if (!sParticle.getId().equals(id)) continue;
            return Optional.ofNullable(sParticle);
        }
        return Optional.ofNullable(null);
    }

    public void updateParticle(SParticle sParticle) {
        this.removeParticle(sParticle.getId());
        this.addParticle(sParticle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        YamlConfiguration config;
        if (!new File(this.filePath).exists()) {
            this.sPlugin.getPlugin().getLogger().severe(this.sPlugin.getNameDesign() + " Error can't find the file  (" + this.filePath + ")");
            return;
        }
        File file = new File(this.filePath);
        YamlConfiguration mainSection = config = YamlConfiguration.loadConfiguration((File)file);
        if (!this.configurationSectionPath.isEmpty()) {
            if (!config.isConfigurationSection(this.configurationSectionPath)) {
                config.createSection(this.configurationSectionPath);
            }
            mainSection = config.getConfigurationSection(this.configurationSectionPath);
        }
        mainSection.set("particles", null);
        for (SParticle sParticle : this.particles) {
            mainSection.set("particles." + sParticle.getId() + ".particlesType", (Object)sParticle.getParticlesType().name());
            mainSection.set("particles." + sParticle.getId() + ".particlesAmount", (Object)sParticle.getParticlesAmount());
            mainSection.set("particles." + sParticle.getId() + ".particlesOffSet", (Object)sParticle.getParticlesOffSet());
            mainSection.set("particles." + sParticle.getId() + ".particlesSpeed", (Object)sParticle.getParticlesSpeed());
            mainSection.set("particles." + sParticle.getId() + ".particlesDelay", (Object)sParticle.getParticlesDelay());
            if (sParticle.canHaveRedstoneColor()) {
                mainSection.set("particles." + sParticle.getId() + ".redstoneColor", (Object)CustomColor.getName(sParticle.getRedstoneColor()));
            }
            if (!sParticle.canHaveBlocktype()) continue;
            mainSection.set("particles." + sParticle.getId() + ".blockType", (Object)sParticle.getBlockType().toString());
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
            writer.write(config.saveToString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Generated
    public SPlugin getSPlugin() {
        return this.sPlugin;
    }

    @Generated
    public String getFilePath() {
        return this.filePath;
    }

    @Generated
    public String getConfigurationSectionPath() {
        return this.configurationSectionPath;
    }

    @Generated
    public List<SParticle> getParticles() {
        return this.particles;
    }
}

