/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.usedapi;

import com.ssomar.score.SCore;
import com.ssomar.score.usedapi.BentoBoxAPI;
import com.ssomar.score.usedapi.MultiverseAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class AllWorldManager {
    public static Optional<World> getWorld(String worldStr) {
        World world;
        if (SCore.hasMultiverse && (world = MultiverseAPI.getWorld(worldStr)) != null) {
            return Optional.of(world);
        }
        if (SCore.hasBentoBox && (world = BentoBoxAPI.getWorld(worldStr)) != null) {
            return Optional.of(world);
        }
        return Optional.ofNullable(Bukkit.getServer().getWorld(worldStr));
    }

    public static Optional<World> getWorld(UUID worldUUID) {
        World world;
        if (SCore.hasMultiverse) {
            for (String s : MultiverseAPI.getWorlds()) {
                world = MultiverseAPI.getWorld(s);
                if (!world.getUID().equals(worldUUID)) continue;
                return Optional.of(world);
            }
        }
        if (SCore.hasBentoBox) {
            for (String s : BentoBoxAPI.getWorlds()) {
                world = BentoBoxAPI.getWorld(s);
                if (!world.getUID().equals(worldUUID)) continue;
                return Optional.of(world);
            }
        }
        return Optional.ofNullable(Bukkit.getServer().getWorld(worldUUID));
    }

    public static List<String> getWorlds() {
        ArrayList<String> worlds = new ArrayList<String>();
        if (SCore.hasMultiverse) {
            worlds.addAll(MultiverseAPI.getWorlds());
        }
        if (SCore.hasBentoBox) {
            for (String s : BentoBoxAPI.getWorlds()) {
                if (worlds.contains(s)) continue;
                worlds.add(s);
            }
        }
        for (World w : Bukkit.getWorlds()) {
            if (worlds.contains(w.getName())) continue;
            worlds.add(w.getName());
        }
        return worlds;
    }

    public static List<World> getWorldsCB() {
        ArrayList<World> worlds = new ArrayList<World>();
        if (SCore.hasMultiverse) {
            worlds.addAll(MultiverseAPI.getWorldsCB());
        }
        if (SCore.hasBentoBox) {
            for (World s : BentoBoxAPI.getWorldsCB()) {
                if (worlds.contains(s)) continue;
                worlds.add(s);
            }
        }
        for (World w : Bukkit.getWorlds()) {
            if (worlds.contains(w)) continue;
            worlds.add(w);
        }
        return worlds;
    }
}

