/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.backward_compatibility;

import com.ssomar.score.SCore;
import com.ssomar.score.utils.MapUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Biome;

public class BiomeUtils {
    private static Map<Object, String> biomes;

    public static Map<Object, String> getBiomes() {
        if (biomes != null) {
            return biomes;
        }
        HashMap<Object, String> list = new HashMap<Object, String>();
        if (SCore.is1v21v2Plus()) {
            try {
                for (Keyed l : Registry.BIOME) {
                    NamespacedKey key = l.getKey();
                    if (key.getNamespace().equals("minecraft")) {
                        list.put(l, l.getKey().getKey().toUpperCase());
                        continue;
                    }
                    list.put(l, l.getKey().toString());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            for (Biome o : (Biome[])Biome.class.getEnumConstants()) {
                try {
                    String name = (String)o.getClass().getMethod("name", new Class[0]).invoke((Object)o, new Object[0]);
                    list.put(o, name);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        biomes = MapUtil.sortByValue(list);
        return biomes;
    }

    public static Biome getBiome(String string) {
        string = string.replace("minecraft:", "");
        for (Map.Entry<Object, String> entry : BiomeUtils.getBiomes().entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(string)) continue;
            return (Biome)entry.getKey();
        }
        return null;
    }
}

