/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.variables.manager;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.data.Database;
import com.ssomar.score.data.VariablesQuery;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.variables.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class VariablesManager
extends SObjectWithFileManager<Variable> {
    private static VariablesManager instance;
    private NamespacedKey key;

    public VariablesManager() {
        super(SCore.plugin, "variables");
        if (!SCore.is1v13Less()) {
            this.key = new NamespacedKey((Plugin)SCore.plugin, "SCORE-ID");
        }
    }

    @Override
    public void actionOnObjectWhenLoading(Variable sProjectile) {
    }

    @Override
    public void actionOnObjectWhenReloading(Variable sProjectile) {
    }

    @Override
    public Optional<Variable> methodObjectLoading(String s) {
        return Optional.empty();
    }

    public static VariablesManager getInstance() {
        if (instance == null) {
            instance = new VariablesManager();
        }
        return instance;
    }

    public boolean isValidID(String id) {
        for (Variable item : this.getLoadedObjects()) {
            if (!item.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public Optional<Variable> getVariable(String s) {
        return this.getVariable(s, false);
    }

    public Optional<Variable> getVariable(String s, boolean dontTryToImport) {
        if (!dontTryToImport) {
            this.updateLoadedMySQL(s, MODE.IMPORT);
        }
        for (Variable item : this.getLoadedObjects()) {
            if (!item.getId().equals(s)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public List<String> getVariableIdsList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Variable item : this.getLoadedObjects()) {
            list.add(item.getId());
        }
        return list;
    }

    public String getVariableIdsListStr() {
        StringBuilder sb = new StringBuilder();
        boolean pass = false;
        for (Variable item : this.getLoadedObjects()) {
            sb.append(item.getId()).append(" | ");
            pass = true;
        }
        if (pass) {
            sb.delete(sb.length() - 3, sb.length());
        }
        return sb.toString();
    }

    public Optional<String> onRequestPlaceholder(OfflinePlayer player, String params) {
        boolean variables = false;
        boolean variablesContains = false;
        boolean variablesSize = false;
        String check = params;
        if (params.startsWith("variables-contains_")) {
            variablesContains = true;
            check = params.substring(19);
        } else if (params.startsWith("variables-size_")) {
            variablesSize = true;
            check = params.substring(15);
        } else if (params.startsWith("variables_")) {
            variables = true;
            check = params.substring(10);
        }
        if (!(variables || variablesContains || variablesSize)) {
            return Optional.empty();
        }
        String variableID = null;
        ArrayList<String> valids = new ArrayList<String>();
        for (String portentialID : this.getVariableIdsList()) {
            if (!check.startsWith(portentialID)) continue;
            valids.add(portentialID);
        }
        for (String valid : valids) {
            if (variableID != null && variableID.length() >= valid.length()) continue;
            variableID = valid;
        }
        if (variableID == null) {
            return Optional.of("Variable not found");
        }
        check = check.substring(variableID.length());
        Optional<Variable> var2 = VariablesManager.getInstance().getVariable(variableID);
        if (!var2.isPresent()) {
            return Optional.of("Variable not found");
        }
        if (variablesContains) {
            String value;
            if (check.startsWith("_")) {
                check = check.substring(1);
            }
            if ((value = check).isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(var2.get().containsValue(Optional.ofNullable(player.getPlayer()), value) + "");
        }
        if (variablesSize) {
            Optional<Integer> indexOpt = Optional.empty();
            if (check.startsWith("_") && !(check = check.substring(1)).isEmpty()) {
                try {
                    indexOpt = Optional.of(Integer.parseInt(check));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return Optional.of(var2.get().sizeValue(Optional.ofNullable(player.getPlayer()), indexOpt) + "");
        }
        if (variables) {
            boolean castInt = false;
            if (check.endsWith("_int")) {
                castInt = true;
                check = check.substring(0, check.length() - 4);
            }
            Optional<Integer> indexOpt = Optional.empty();
            if (check.startsWith("_") && !(check = check.substring(1)).isEmpty()) {
                try {
                    indexOpt = Optional.of(Integer.parseInt(check));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String value = var2.get().getValue(Optional.ofNullable(player), indexOpt);
            if (castInt) {
                try {
                    return Optional.of(Double.valueOf(value).intValue() + "");
                }
                catch (NumberFormatException e) {
                    return Optional.of("Variable can't be converted to int");
                }
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public void updateAllLoadedMySQL(MODE mode) {
        if (GeneralConfig.getInstance().isUseMySQL() && mode.equals((Object)MODE.IMPORT)) {
            VariablesQuery.insertVariableNotExists(Database.getInstance().connect(), VariablesManager.getInstance().getAllObjects());
            VariablesManager.getInstance().deleteAllLoadedObjects();
            VariablesManager.getInstance().addLoadedObjects(VariablesQuery.selectAllVariables(Database.getInstance().connect()), false);
            VariablesManager.getInstance().saveAllLoadedObjects();
        }
    }

    public void updateLoadedMySQL(String id, MODE mode) {
        if (GeneralConfig.getInstance().isUseMySQL()) {
            Optional varOpt;
            if (mode.equals((Object)MODE.IMPORT)) {
                Optional<Variable> old = VariablesManager.getInstance().getVariable(id, true);
                Optional<Variable> var2 = VariablesQuery.selectVariable(Database.getInstance().connect(), id);
                if (old.isPresent() && var2.isPresent() && old.get().equals(var2.get())) {
                    return;
                }
                VariablesManager.getInstance().deleteObject(id);
                if (var2.isPresent()) {
                    VariablesManager.getInstance().addLoadedObject(var2.get(), false);
                    var2.get().save();
                }
            } else if (mode.equals((Object)MODE.EXPORT) && (varOpt = VariablesManager.getInstance().getLoadedObjectWithID(id)).isPresent()) {
                VariablesQuery.insertVariablesAndDeleteIfExists(Database.getInstance().connect(), Arrays.asList((Variable)varOpt.get()));
            }
        }
    }

    public void deleteLoadedMYSQL(String id) {
        if (GeneralConfig.getInstance().isUseMySQL()) {
            VariablesQuery.deleteVariable(Database.getInstance().connect(), id);
        }
    }

    public static enum MODE {
        IMPORT,
        EXPORT;

    }
}

