/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.sevents.events.player.kill.player.participate.player;

import com.ssomar.sevents.events.player.kill.player.participate.player.PlayerParticipateKillPlayerEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class PlayerParticipateKillPlayerListener
implements Listener {
    private final HashMap<UUID, List<UUID>> participations = new HashMap();

    @EventHandler
    public void onPlayerDeathEvent(PlayerDeathEvent e) {
        Player p = e.getEntity();
        if (this.participations.containsKey(p.getUniqueId())) {
            List<UUID> list = this.participations.get(p.getUniqueId());
            for (UUID uuid : list) {
                Player target = Bukkit.getPlayer((UUID)uuid);
                if (target == null) continue;
                PlayerParticipateKillPlayerEvent playerKillPlayerEvent = new PlayerParticipateKillPlayerEvent(target, p);
                Bukkit.getServer().getPluginManager().callEvent((Event)playerKillPlayerEvent);
            }
        }
        this.participations.remove(p.getUniqueId());
    }

    @EventHandler
    public void onPlayerDamagePlayerEvent(EntityDamageByEntityEvent e) {
        if (e.getDamager() instanceof Player && e.getEntity() instanceof Player) {
            Player damager = (Player)e.getDamager();
            Player damagee = (Player)e.getEntity();
            this.addParticipation(damager.getUniqueId(), damagee.getUniqueId());
        }
    }

    public void addParticipation(UUID damager, UUID damagee) {
        if (this.participations.containsKey(damagee)) {
            List<UUID> list = this.participations.get(damagee);
            if (list.contains(damager)) {
                return;
            }
            list.add(damager);
            this.participations.put(damagee, list);
        } else {
            ArrayList<UUID> list = new ArrayList<UUID>();
            list.add(damager);
            this.participations.put(damagee, list);
        }
    }
}

