/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.particles.commands;

import com.google.common.base.Enums;
import com.ssomar.particles.commands.ParticleDisplay;
import com.ssomar.score.SCore;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;

public final class XParticle {
    public static final double PII = Math.PI * 2;

    private XParticle() {
    }

    public static Particle getParticle(String particle) {
        return (Particle)Enums.getIfPresent(Particle.class, (String)particle).orNull();
    }

    public static Particle randomParticle(String ... particles) {
        int rand = XParticle.randInt(0, particles.length - 1);
        return XParticle.getParticle(particles[rand]);
    }

    public static double random(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    public static int randInt(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static org.bukkit.Color randomColor() {
        ThreadLocalRandom gen = ThreadLocalRandom.current();
        int randR = gen.nextInt(0, 256);
        int randG = gen.nextInt(0, 256);
        int randB = gen.nextInt(0, 256);
        return org.bukkit.Color.fromRGB((int)randR, (int)randG, (int)randB);
    }

    public static Particle.DustOptions randomDust() {
        float size = (float)XParticle.randInt(5, 10) / 10.0f;
        return new Particle.DustOptions(XParticle.randomColor(), size);
    }

    public static void atom(int orbits, double radius, double rate, ParticleDisplay display) {
        ParticleDisplay orbit = display;
        ParticleDisplay nucleus = display;
        double dist = Math.PI / (double)orbits;
        double angle = 0.0;
        while (orbits > 0) {
            orbit.setRotation(new Vector(0.0, 0.0, angle));
            XParticle.circle(radius, rate, 0, "", "", orbit);
            --orbits;
            angle += dist;
        }
        XParticle.sphere(radius / 3.0, rate / 2.0, nucleus);
    }

    public static ScheduledTask atomic(final int orbits, final double radius, final double rate, final double time, final ParticleDisplay display) {
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            final double rateDiv;
            final double dist;
            double theta;
            double repeat;
            {
                this.rateDiv = Math.PI / rate;
                this.dist = Math.PI / (double)orbits;
                this.theta = 0.0;
                this.repeat = 0.0;
            }

            @Override
            public void run() {
                double d;
                int orbital = orbits;
                this.theta += this.rateDiv;
                double x = radius * Math.cos(this.theta);
                double z = radius * Math.sin(this.theta);
                double angle = 0.0;
                while (orbital > 0) {
                    display.setRotation(new Vector(0.0, 0.0, angle));
                    display.spawn(x, 0.0, z);
                    --orbital;
                    angle += this.dist;
                }
                this.repeat += 1.0;
                if (d > time) {
                    ((ScheduledTask)task.get()).cancel();
                }
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L));
        return (ScheduledTask)task.get();
    }

    public static void blackSun(double radius, double radiusRate, double rate, double rateChange, ParticleDisplay display) {
        double j = 0.0;
        if (radiusRate < 0.0) {
            radiusRate = -radiusRate;
        } else if (radiusRate == 0.0) {
            radiusRate = 1.0;
        }
        for (double i = 10.0; i > 0.0; i -= radiusRate) {
            XParticle.circle(radius + i, Math.max(5.0, rate - (j += rateChange)), 0, "", "ring", display);
        }
    }

    public static ScheduledTask blackhole(final int points, final double radius, final double rate, final int mode, final int time, final ParticleDisplay display) {
        display.directional();
        display.extra = 0.1;
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            final double rateDiv;
            int timer;
            double theta;
            {
                this.rateDiv = Math.PI / rate;
                this.timer = time;
                this.theta = 0.0;
            }

            @Override
            public void run() {
                for (int i = 0; i < points; ++i) {
                    double angle = Math.PI * 2 * ((double)i / (double)points);
                    double x = radius * Math.cos(this.theta + angle);
                    double z = radius * Math.sin(this.theta + angle);
                    double phi = Math.atan2(z, x);
                    double xDirection = -Math.cos(phi);
                    double zDirection = -Math.sin(phi);
                    display.offset(xDirection, 0.0, zDirection);
                    display.spawn(x, 0.0, z);
                    if (mode <= 1) continue;
                    x = radius * Math.cos(-this.theta + angle);
                    z = radius * Math.sin(-this.theta + angle);
                    if (mode == 2) {
                        phi = Math.atan2(z, x);
                    } else if (mode == 3) {
                        phi = Math.atan2(x, z);
                    } else if (mode == 4) {
                        Math.atan2(Math.log(x), Math.log(z));
                    }
                    xDirection = -Math.cos(phi);
                    zDirection = -Math.sin(phi);
                    display.offset(xDirection, 0.0, zDirection);
                    display.spawn(x, 0.0, z);
                }
                this.theta += this.rateDiv;
                if (--this.timer <= 0) {
                    ((ScheduledTask)task.get()).cancel();
                }
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L));
        return (ScheduledTask)task.get();
    }

    public static void cone(double height, double radius, double rate, double circleRate, String fillMode, ParticleDisplay display) {
        double radiusDiv = radius / (height / rate);
        if (rate < 0.0) {
            rate = 1.0;
        }
        if (circleRate < 0.0) {
            circleRate = 1.0;
        }
        display.setDirectionPitch(90.0);
        for (double i = 0.0; i < height && !((radius -= radiusDiv) < 0.0); i += rate) {
            XParticle.circle(radius, circleRate, 0, "", fillMode, display.cloneWithLocation(0.0, i, 0.0));
        }
    }

    public static void crescent(double radius, double rate, ParticleDisplay display) {
        double rateDiv = Math.PI / rate;
        double end = Math.toRadians(325.0);
        double start = Math.toRadians(45.0);
        double yawRad = Math.toRadians(display.getDirectionYaw());
        double pitchRad = Math.toRadians(0.0);
        double dx = -Math.cos(pitchRad) * Math.sin(yawRad);
        double dy = -Math.sin(pitchRad);
        double dz = Math.cos(pitchRad) * Math.cos(yawRad);
        Vector targetDir = new Vector(dx, dy, dz).normalize();
        Vector from = new Vector(1, 0, 0);
        Vector axis = from.clone().crossProduct(targetDir);
        double angle = Math.acos(from.dot(targetDir));
        boolean rotate = axis.lengthSquared() > 1.0E-4;
        for (double theta = start; theta <= end; theta += rateDiv) {
            double x = Math.cos(theta);
            double z = Math.sin(theta);
            Vector outer = new Vector(radius * x, 0.0, radius * z);
            if (rotate) {
                outer = XParticle.rotateVector(outer, axis, angle);
            }
            display.spawn(outer.getX(), outer.getY(), outer.getZ());
            double smallerRadius = radius / 1.3;
            Vector inner = new Vector(smallerRadius * x + 0.8, 0.0, smallerRadius * z);
            if (rotate) {
                inner = XParticle.rotateVector(inner, axis, angle);
            }
            display.spawn(inner.getX(), inner.getY(), inner.getZ());
        }
    }

    private static Vector rotateVector(Vector v, Vector axis, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        return v.clone().multiply(cos).add(axis.clone().crossProduct(v).multiply(sin)).add(axis.clone().multiply(axis.dot(v) * (1.0 - cos)));
    }

    public static ScheduledTask circle(double radius, double density, int time, String drawMode, String fillMode, ParticleDisplay display) {
        return XParticle.baseCircle(radius, density, 0.0, time, drawMode, fillMode, display);
    }

    public static ScheduledTask baseCircle(double radius, double density, double height, int time, String drawMode, String fillMode, final ParticleDisplay display) {
        final ArrayList<Vector> points = new ArrayList<Vector>();
        double totalAngle = Math.PI * 2;
        double step = totalAngle / density;
        if (height <= 0.0) {
            height = 1.0;
        }
        if (density <= 0.0) {
            density = 1.0;
        }
        Vector direction = XParticle.calculDirection(display.getDirectionYaw(), display.getDirectionPitch());
        Vector axis1 = XParticle.calculDirection(display.getDirectionYaw() + 90.0, 0.0).normalize();
        Vector axis2 = axis1.clone().getCrossProduct(direction).normalize();
        double verticalStep = 1.0 / (density / 2.0);
        switch (fillMode.toLowerCase()) {
            case "cylinder": {
                for (double y = 0.0; y <= height; y += verticalStep) {
                    Vector layerOffset = direction.clone().normalize().multiply(y);
                    XParticle.addCircleLayer(radius, density, step, "ring", axis1, axis2, direction.clone().add(layerOffset), points);
                }
                break;
            }
            default: {
                XParticle.addCircleLayer(radius, density, step, fillMode, axis1, axis2, direction, points);
            }
        }
        switch (drawMode.toLowerCase()) {
            case "counterclockwise": {
                Collections.reverse(points);
                break;
            }
            case "random": {
                Collections.shuffle(points);
            }
        }
        if (time <= 0) {
            for (Vector p : points) {
                display.spawn(p);
            }
            return null;
        }
        final int totalPoints = points.size();
        final int perTick = Math.max(1, totalPoints / time);
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            int index = 0;

            @Override
            public void run() {
                int i = 0;
                while (i < perTick && this.index < totalPoints) {
                    display.spawn((Vector)points.get(this.index));
                    ++i;
                    ++this.index;
                }
                if (this.index >= totalPoints) {
                    ((ScheduledTask)task.get()).cancel();
                }
            }
        };
        ScheduledTask scheduled = SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L);
        task.set(scheduled);
        return scheduled;
    }

    private static void addCircleLayer(double radius, double density, double step, String fillMode, Vector axis1, Vector axis2, Vector offset, List<Vector> points) {
        switch (fillMode.toLowerCase()) {
            case "spiral": {
                double spiralDensity = density * 2.0;
                double spiralStep = Math.PI * 2 / spiralDensity;
                for (double t = 0.0; t <= Math.PI * 2 * (radius / 0.1); t += spiralStep) {
                    double r = t / (Math.PI * 2) * (radius / (density / 10.0));
                    Vector vec = XParticle.rotatedCirclePoint(r, t % (Math.PI * 2), axis1, axis2).add(offset);
                    points.add(vec);
                }
                break;
            }
            case "ring": {
                for (double theta = 0.0; theta <= Math.PI * 2; theta += step) {
                    Vector vec = XParticle.rotatedCirclePoint(radius, theta, axis1, axis2).add(offset);
                    points.add(vec);
                }
                break;
            }
            default: {
                for (double r = 0.0; r <= radius; r += radius / (density / 10.0)) {
                    for (double theta = 0.0; theta <= Math.PI * 2; theta += step) {
                        Vector vec = XParticle.rotatedCirclePoint(r, theta, axis1, axis2).add(offset);
                        points.add(vec);
                    }
                }
            }
        }
    }

    private static Vector rotatedCirclePoint(double r, double theta, Vector axis1, Vector axis2) {
        double x = r * Math.cos(theta);
        double y = r * Math.sin(theta);
        return axis1.clone().multiply(x).add(axis2.clone().multiply(y));
    }

    public static ScheduledTask circularBeam(final double maxRadius, final double rate, final double radiusRate, final double extend, final double time, final ParticleDisplay display) {
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            final double rateDiv;
            final double radiusDiv;
            final Vector dir;
            double dynamicRadius;
            long repeat;
            {
                this.rateDiv = Math.PI / rate;
                this.radiusDiv = Math.PI / radiusRate;
                this.dir = display.getLocation().getDirection().normalize().multiply(extend);
                this.dynamicRadius = 0.0;
                this.repeat = 0L;
            }

            @Override
            public void run() {
                long l;
                double radius = maxRadius * Math.sin(this.dynamicRadius);
                for (double theta = 0.0; theta < Math.PI * 2; theta += this.rateDiv) {
                    double x = radius * Math.sin(theta);
                    double z = radius * Math.cos(theta);
                    display.spawn(x, 0.0, z);
                }
                this.dynamicRadius += this.radiusDiv;
                if (this.dynamicRadius > Math.PI) {
                    this.dynamicRadius = 0.0;
                }
                display.getLocation().clone().add(this.dir);
                ++this.repeat;
                if ((double)l > time) {
                    ((ScheduledTask)task.get()).cancel();
                    return;
                }
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L));
        return (ScheduledTask)task.get();
    }

    public static ScheduledTask cylinder(double radius, double density, double height, int time, String drawMode, ParticleDisplay display) {
        return XParticle.baseCircle(radius, density, height, time, drawMode, "cylinder", display);
    }

    public static void diamond(double radiusRate, double rate, double height, ParticleDisplay display) {
        double count = 0.0;
        for (double y = 0.0; y < height * 2.0; y += rate) {
            count = y < height ? (count += radiusRate) : (count -= radiusRate);
            for (double x = -count; x < count; x += rate) {
                display.spawn(x, y, 0.0);
            }
        }
    }

    public static void dna(double radius, double rate, double extension, int height, int hydrogenBondDist, ParticleDisplay display) {
        ParticleDisplay hydrogenBondDisplay = display;
        int nucleotideDist = 0;
        for (double y = 0.0; y <= (double)height; y += rate) {
            ++nucleotideDist;
            double x = radius * Math.cos(extension * y);
            double z = radius * Math.sin(extension * y);
            Location nucleotide1 = display.getLocation().clone().add(x, y, z);
            display.spawn(x, y, z);
            Location nucleotide2 = display.getLocation().clone().subtract(x, -y, z);
            display.spawn(-x, y, -z);
            if (nucleotideDist < hydrogenBondDist) continue;
            nucleotideDist = 0;
            XParticle.line(nucleotide1, nucleotide2, rate * 2.0, hydrogenBondDisplay);
        }
    }

    public static ScheduledTask dnaReplication(final double radius, final double rate, double speed, final double extension, final int height, final int hydrogenBondDist, final ParticleDisplay display) {
        final ParticleDisplay adenine = ParticleDisplay.colored(null, Color.BLUE, 1.0f);
        final ParticleDisplay thymine = ParticleDisplay.colored(null, Color.YELLOW, 1.0f);
        final ParticleDisplay guanine = ParticleDisplay.colored(null, Color.GREEN, 1.0f);
        final ParticleDisplay cytosine = ParticleDisplay.colored(null, Color.RED, 1.0f);
        final int speedFinal = (int)Math.max(1.0, speed);
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            double y = 0.0;
            int nucleotideDist = 0;

            @Override
            public void run() {
                int repeat = speedFinal;
                while (repeat-- != 0) {
                    this.y += rate;
                    ++this.nucleotideDist;
                    double x = radius * Math.cos(extension * this.y);
                    double z = radius * Math.sin(extension * this.y);
                    Location nucleotide1 = display.getLocation().clone().add(x, this.y, z);
                    XParticle.circle(1.0, 10.0, 0, "", "", display.cloneWithLocation(x, this.y, z));
                    Location nucleotide2 = display.getLocation().clone().subtract(x, -this.y, z);
                    XParticle.circle(1.0, 10.0, 0, "", "", display.cloneWithLocation(-x, this.y, -z));
                    Location midPointBond = nucleotide1.toVector().midpoint(nucleotide2.toVector()).toLocation(nucleotide1.getWorld());
                    if (this.nucleotideDist >= hydrogenBondDist) {
                        this.nucleotideDist = 0;
                        if (XParticle.randInt(0, 1) == 1) {
                            XParticle.line(nucleotide1, midPointBond, rate - 0.1, adenine);
                            XParticle.line(nucleotide2, midPointBond, rate - 0.1, thymine);
                        } else {
                            XParticle.line(nucleotide1, midPointBond, rate - 0.1, cytosine);
                            XParticle.line(nucleotide2, midPointBond, rate - 0.1, guanine);
                        }
                    }
                    if (!(this.y >= (double)height)) continue;
                    ((ScheduledTask)task.get()).cancel();
                    return;
                }
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L));
        return (ScheduledTask)task.get();
    }

    public static void ellipse(double start, double end, double rate, double radius, double otherRadius, ParticleDisplay display) {
        rate = Math.max(0.1, rate);
        for (double theta = start; theta <= end; theta += rate) {
            double x = radius * Math.cos(theta);
            double y = otherRadius * Math.sin(theta);
            display.spawn(x, y, 0.0);
        }
    }

    public static ScheduledTask explosionWave(final double rate, final double start, double height, final ParticleDisplay display) {
        final ParticleDisplay secDisplay = display;
        final double heightFinal = height <= 0.0 ? -height : height;
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            final double addition = 0.3141592653589793;
            final double rateDiv = Math.PI / rate;
            double times = start;

            @Override
            public void run() {
                this.times += 0.3141592653589793;
                for (double theta = 0.0; theta <= Math.PI * 2; theta += this.rateDiv) {
                    double x = this.times * Math.cos(theta);
                    double y = heightFinal * Math.exp(-0.1 * this.times) * Math.sin(this.times) + 1.5;
                    double z = this.times * Math.sin(theta);
                    display.spawn(x, y, z);
                    x = this.times * Math.cos(theta += 0.04908738521234052);
                    z = this.times * Math.sin(theta);
                    secDisplay.spawn(x, y, z);
                }
                if (this.times > 20.0) {
                    ((ScheduledTask)task.get()).cancel();
                    return;
                }
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L));
        return (ScheduledTask)task.get();
    }

    public static void eye(double radius, double radius2, double rate, double extension, ParticleDisplay display) {
        if (rate == 0.0) {
            rate = 1.0;
        }
        if (extension == 0.0) {
            extension = 1.0;
        }
        double rateDiv = Math.PI / rate;
        double limit = Math.PI / extension;
        double yawRad = Math.toRadians(display.getDirectionYaw());
        double pitchRad = Math.toRadians(display.getDirectionPitch());
        double dx = -Math.cos(pitchRad) * Math.sin(yawRad);
        double dy = -Math.sin(pitchRad);
        double dz = Math.cos(pitchRad) * Math.cos(yawRad);
        Vector targetDir = new Vector(dx, dy, dz).normalize();
        Vector from = new Vector(1, 0, 0);
        Vector axis = from.clone().crossProduct(targetDir);
        double angle = Math.acos(from.dot(targetDir));
        boolean rotate = axis.lengthSquared() > 1.0E-4;
        double x = 0.0;
        for (double i = 0.0; i < limit; i += rateDiv) {
            double y = radius * Math.sin(extension * i);
            double y2 = radius2 * Math.sin(extension * -i);
            Vector point1 = new Vector(x, y, 0.0);
            Vector point2 = new Vector(x, y2, 0.0);
            if (rotate) {
                point1 = XParticle.rotateVector(point1, axis, angle);
                point2 = XParticle.rotateVector(point2, axis, angle);
            }
            display.spawn(point1.getX(), point1.getY(), point1.getZ());
            display.spawn(point2.getX(), point2.getY(), point2.getZ());
            x += 0.1;
        }
    }

    public static void heart(double cut, double cutAngle, double depth, double compressHeight, double rate, ParticleDisplay display) {
        double yawRad = Math.toRadians(display.getDirectionYaw() + 90.0);
        double pitchRad = Math.toRadians(display.getDirectionPitch());
        double dx = -Math.cos(pitchRad) * Math.sin(yawRad);
        double dy = -Math.sin(pitchRad);
        double dz = Math.cos(pitchRad) * Math.cos(yawRad);
        Vector targetDir = new Vector(dx, dy, dz).normalize();
        Vector from = new Vector(0, 0, 1);
        Vector axis = from.clone().crossProduct(targetDir);
        double angle = Math.acos(from.dot(targetDir));
        boolean rotate = axis.lengthSquared() > 1.0E-4;
        for (double theta = 0.0; theta <= Math.PI * 2; theta += Math.PI / rate) {
            double phi = theta / cut;
            double cos = Math.cos(phi);
            double sin = Math.sin(phi);
            double omega = Math.pow(Math.abs(Math.sin(2.0 * cutAngle * phi)) + depth * Math.abs(Math.sin(cutAngle * phi)), 1.0 / compressHeight);
            double y = omega * (sin + cos);
            double z = omega * (cos - sin);
            Vector point = new Vector(0.0, y, z);
            if (rotate) {
                point = XParticle.rotateVector(point, axis, angle);
            }
            display.spawn(point.getX(), point.getY(), point.getZ());
        }
    }

    public static ScheduledTask helix(final int strings, final double radius, final double rate, final double extension, final int height, final int speed, final boolean fadeUp, final boolean fadeDown, final ParticleDisplay display) {
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            final double dist;
            final double radiusDiv;
            final double radiusDiv2;
            double dynamicRadius;
            boolean center;
            double y;
            {
                this.dist = Math.PI * 2 / (double)strings;
                this.radiusDiv = radius / ((double)height / rate);
                this.radiusDiv2 = fadeUp && fadeDown ? this.radiusDiv * 2.0 : this.radiusDiv;
                this.dynamicRadius = fadeDown ? 0.0 : radius;
                this.center = !fadeDown;
                this.y = 0.0;
            }

            @Override
            public void run() {
                int repeat = speed;
                while (repeat-- > 0) {
                    this.y += rate;
                    double x = this.dynamicRadius * Math.cos(extension * this.y);
                    double z = this.dynamicRadius * Math.sin(extension * this.y);
                    if (!this.center) {
                        this.dynamicRadius += this.radiusDiv2;
                        if (this.dynamicRadius >= radius) {
                            this.center = true;
                        }
                    } else if (fadeUp) {
                        this.dynamicRadius -= this.radiusDiv2;
                    }
                    int tempString = strings;
                    double angle = 0.0;
                    while (tempString > 0) {
                        display.rotate(0.0, angle, 0.0);
                        display.spawn(x, this.y, z);
                        display.rotate(0.0, -angle, 0.0);
                        --tempString;
                        angle += this.dist;
                    }
                    if (!(this.y > (double)height)) continue;
                    ((ScheduledTask)task.get()).cancel();
                    return;
                }
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L));
        return (ScheduledTask)task.get();
    }

    public static void illuminati(double size, double extension, ParticleDisplay display) {
        XParticle.polygon(3, 1, size, 1.0 / (size * 30.0), 0.0, display);
        XParticle.eye(size / 4.0, size / 4.0, 30.0, extension, display.cloneWithLocation(0.3, 0.0, size / 1.8).rotate(1.5707963267948966, 1.5707963267948966, 0.0));
        display.setDirectionPitch(90.0);
        XParticle.circle(size / 5.0, size * 5.0, 0, "", "", display.cloneWithLocation(0.3, 0.0, 0.0));
    }

    public static void meguminExplosion(double size, ParticleDisplay display) {
        XParticle.polygon(10, 4, size, 0.02, 0.3, display);
        XParticle.polygon(10, 3, size / (size - 1.0), 0.5, 0.0, display);
        XParticle.circle(size, 40.0, 0, "", "", display);
        XParticle.spread(30, 2, display.getLocation(), display.getLocation().clone().add(0.0, 10.0, 0.0), 5.0, 5.0, 5.0, display);
    }

    public static ScheduledTask magicCircles(final double radius, final double rate, final double radiusRate, final double distance, final int time, final ParticleDisplay display) {
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            final double radiusDiv;
            final Vector dir;
            double dynamicRadius;
            int timer;
            {
                this.radiusDiv = Math.PI / radiusRate;
                this.dir = display.getLocation().getDirection().normalize().multiply(distance);
                this.dynamicRadius = radius;
                this.timer = time;
            }

            @Override
            public void run() {
                double rateDiv = Math.PI / (rate * this.dynamicRadius);
                for (double theta = 0.0; theta < Math.PI * 2; theta += rateDiv) {
                    double x = this.dynamicRadius * Math.sin(theta);
                    double z = this.dynamicRadius * Math.cos(theta);
                    display.spawn(x, 0.0, z);
                }
                this.dynamicRadius += this.radiusDiv;
                display.getLocation().add(this.dir);
                if (this.timer-- <= 0) {
                    ((ScheduledTask)task.get()).cancel();
                }
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L));
        return (ScheduledTask)task.get();
    }

    public static void polygon(int points, int connection, double size, double rate, double extend, ParticleDisplay display) {
        for (int point = 0; point < points; ++point) {
            double angle = Math.toRadians(360.0 / (double)points * (double)point);
            double nextAngle = Math.toRadians(360.0 / (double)points * (double)(point + connection));
            double x = Math.cos(angle) * size;
            double z = Math.sin(angle) * size;
            double x2 = Math.cos(nextAngle) * size;
            double z2 = Math.sin(nextAngle) * size;
            double deltaX = x2 - x;
            double deltaZ = z2 - z;
            for (double pos = 0.0; pos < 1.0 + extend; pos += rate) {
                display.spawn(x + deltaX * pos, 0.0, z + deltaZ * pos);
            }
        }
    }

    public static ScheduledTask ring(double radius, double density, int time, String drawMode, ParticleDisplay display) {
        return XParticle.circle(radius, density, time, drawMode, "ring", display);
    }

    public static void sphere(double radius, double rate, ParticleDisplay display) {
        double rateDiv = Math.PI / rate;
        for (double phi = 0.0; phi <= Math.PI; phi += rateDiv) {
            double y1 = radius * Math.cos(phi);
            double y2 = radius * Math.sin(phi);
            for (double theta = 0.0; theta <= Math.PI * 2; theta += rateDiv) {
                double x = Math.cos(theta) * y2;
                double z = Math.sin(theta) * y2;
                if (display.isDirectional()) {
                    double omega = Math.atan2(z, x);
                    double directionX = Math.cos(omega);
                    double directionY = Math.sin(Math.atan2(y2, y1));
                    double directionZ = Math.sin(omega);
                    display.offset(directionX, directionY, directionZ);
                }
                display.spawn(x, y1, z);
            }
        }
    }

    public static void spikeSphere(double radius, double rate, int chance, double minRandomDistance, double maxRandomDistance, ParticleDisplay display) {
        double rateDiv = Math.PI / rate;
        for (double phi = 0.0; phi <= Math.PI; phi += rateDiv) {
            double y = radius * Math.cos(phi);
            double sinPhi = radius * Math.sin(phi);
            for (double theta = 0.0; theta <= Math.PI * 2; theta += rateDiv) {
                double x = Math.cos(theta) * sinPhi;
                double z = Math.sin(theta) * sinPhi;
                if (chance != 0 && XParticle.randInt(0, chance) != 1) continue;
                Location start = display.cloneLocation(x, y, z);
                Vector endVect = start.clone().subtract(display.getLocation()).toVector().multiply(XParticle.random(minRandomDistance, maxRandomDistance));
                Location end = start.clone().add(endVect);
                XParticle.line(start, end, 0.1, display);
            }
        }
    }

    public static ScheduledTask square(double height, double length, double width, double density, int time, String drawMode, String verticalOrder, String horizontalOrder, final ParticleDisplay display) {
        Vector point;
        Iterator iterator;
        double w;
        Iterator iterator2;
        Iterator w22;
        double l;
        double h;
        final ArrayList<Vector> grid = new ArrayList<Vector>();
        double spacing = 1.0 / density;
        Vector direction = XParticle.calculDirection(display.getDirectionYaw(), display.getDirectionPitch());
        Vector axis1 = XParticle.calculDirection(display.getDirectionYaw() + 90.0, 0.0).normalize();
        Vector axis2 = axis1.clone().getCrossProduct(direction).normalize();
        Vector axis3 = direction.clone().normalize();
        boolean verticalUp = verticalOrder.equalsIgnoreCase("up");
        boolean horizontalNear = horizontalOrder.equalsIgnoreCase("near");
        ArrayList<Double> hList = new ArrayList<Double>();
        double d = h = verticalUp ? 0.0 : height;
        while (verticalUp ? h <= height : h >= 0.0) {
            hList.add(h);
            h += verticalUp ? spacing : -spacing;
        }
        ArrayList<Double> lList = new ArrayList<Double>();
        double d2 = l = horizontalNear ? 0.0 : length;
        while (horizontalNear ? l <= length : l >= 0.0) {
            lList.add(l);
            l += horizontalNear ? spacing : -spacing;
        }
        ArrayList<Double> wList = new ArrayList<Double>();
        for (double w22 = -width / 2.0; w22 <= width / 2.0; w22 += spacing) {
            wList.add(w22);
        }
        if (drawMode.equalsIgnoreCase("vertical")) {
            w22 = lList.iterator();
            while (w22.hasNext()) {
                double l2 = (Double)w22.next();
                iterator2 = wList.iterator();
                while (iterator2.hasNext()) {
                    w = (Double)iterator2.next();
                    iterator = hList.iterator();
                    while (iterator.hasNext()) {
                        double h2 = (Double)iterator.next();
                        point = axis1.clone().multiply(w).add(axis2.clone().multiply(h2)).add(axis3.clone().multiply(l2));
                        grid.add(point);
                    }
                }
            }
        } else {
            w22 = hList.iterator();
            while (w22.hasNext()) {
                double h3 = (Double)w22.next();
                iterator2 = wList.iterator();
                while (iterator2.hasNext()) {
                    w = (Double)iterator2.next();
                    iterator = lList.iterator();
                    while (iterator.hasNext()) {
                        double l3 = (Double)iterator.next();
                        point = axis1.clone().multiply(w).add(axis2.clone().multiply(h3)).add(axis3.clone().multiply(l3));
                        grid.add(point);
                    }
                }
            }
        }
        if (time <= 0) {
            for (Vector point2 : grid) {
                display.spawn(point2);
            }
            return null;
        }
        final int total = grid.size();
        final int perTick = Math.max(1, total / time);
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            int index = 0;

            @Override
            public void run() {
                int i = 0;
                while (i < perTick && this.index < total) {
                    display.spawn((Vector)grid.get(this.index));
                    ++i;
                    ++this.index;
                }
                if (this.index >= total) {
                    ((ScheduledTask)task.get()).cancel();
                }
            }
        };
        ScheduledTask scheduled = SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L);
        task.set(scheduled);
        return scheduled;
    }

    public static ScheduledTask spiral(double radius, double density, int time, String drawMode, ParticleDisplay display) {
        return XParticle.circle(radius, density, time, drawMode, "spiral", display);
    }

    public static ScheduledTask filledCircle(double radius, double density, int time, String drawMode, ParticleDisplay display) {
        return XParticle.circle(radius, density, time, drawMode, "disk", display);
    }

    public static ScheduledTask chaoticDoublePendulum(Plugin plugin, final double radius, final double gravity, final double length, final double length2, final double mass1, final double mass2, final boolean dimension3, int speed, final int time, final ParticleDisplay display) {
        if (speed <= 0) {
            speed = 1;
        }
        final int speedFinal = speed;
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            final Vector rotation = new Vector(0.09519977738150888, 0.07139983303613166, 0.057119866428905326);
            double theta = 1.5707963267948966;
            double theta2 = 1.5707963267948966;
            double thetaPrime = 0.0;
            double thetaPrime2 = 0.0;
            int timer = time;

            @Override
            public void run() {
                int repeat = speedFinal;
                while (repeat-- != 0) {
                    if (dimension3) {
                        display.rotate(this.rotation);
                    }
                    double totalMass = mass1 + mass2;
                    double totalMassDouble = 2.0 * totalMass;
                    double deltaTheta = this.theta - this.theta2;
                    double lenLunar = totalMassDouble - mass2 * Math.cos(2.0 * this.theta - 2.0 * this.theta2);
                    double deltaCosTheta = Math.cos(deltaTheta);
                    double deltaSinTheta = Math.sin(deltaTheta);
                    double phi = this.thetaPrime * this.thetaPrime * length;
                    double phi2 = this.thetaPrime2 * this.thetaPrime2 * length2;
                    double num1 = -gravity * totalMassDouble * Math.sin(this.theta);
                    double num2 = -mass2 * gravity * Math.sin(this.theta - 2.0 * this.theta2);
                    double num3 = -2.0 * deltaSinTheta * mass2;
                    double num4 = phi2 + phi * deltaCosTheta;
                    double len = length * lenLunar;
                    double thetaDoublePrime = (num1 + num2 + num3 * num4) / len;
                    num1 = 2.0 * deltaSinTheta;
                    num2 = phi * totalMass;
                    num3 = gravity * totalMass * Math.cos(this.theta);
                    num4 = phi2 * mass2 * deltaCosTheta;
                    len = length2 * lenLunar;
                    double thetaDoublePrime2 = num1 * (num2 + num3 + num4) / len;
                    this.thetaPrime += thetaDoublePrime;
                    this.thetaPrime2 += thetaDoublePrime2;
                    this.theta += this.thetaPrime;
                    this.theta2 += this.thetaPrime2;
                    double x = radius * Math.sin(this.theta);
                    double y = radius * Math.cos(this.theta);
                    double x2 = x + radius * Math.sin(this.theta2);
                    double y2 = y + radius * Math.cos(this.theta2);
                    display.spawn(x2, y2, 0.0);
                }
                if (--this.timer == 0) {
                    ((ScheduledTask)task.get()).cancel();
                }
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L));
        return (ScheduledTask)task.get();
    }

    public static void infinity(double radius, double rate, ParticleDisplay display) {
        double rateDiv = Math.PI / rate;
        for (double i = 0.0; i < Math.PI * 2; i += rateDiv) {
            double x = Math.sin(i);
            double smooth = Math.pow(x, 2.0) + 1.0;
            double curve = radius * Math.cos(i);
            double z = curve / smooth;
            double y = curve * x / smooth;
            XParticle.circle(1.0, rate, 0, "", "", display.cloneWithLocation(x, y, z));
        }
    }

    public static void rainbow(double radius, double rate, double curve, double layers, double compact, ParticleDisplay display) {
        int[][] rainbow = new int[][]{{128, 0, 128}, {75, 0, 130}, {0, 0, 255}, {0, 255, 0}, {255, 255, 0}, {255, 140, 0}, {255, 0, 0}};
        double secondRadius = radius * curve;
        for (int i = 0; i < 7; ++i) {
            int[] rgb = rainbow[i];
            display = ParticleDisplay.colored(display.getLocation(), rgb[0], rgb[1], rgb[2], 1.0f);
            int layer = 0;
            while ((double)layer < layers) {
                double rateDiv = Math.PI / (rate * (double)(i + 2));
                for (double theta = 0.0; theta <= Math.PI; theta += rateDiv) {
                    double x = radius * Math.cos(theta);
                    double y = secondRadius * Math.sin(theta);
                    display.spawn(x, y, 0.0);
                }
                radius += compact;
                ++layer;
            }
        }
    }

    public static ScheduledTask vortex(final int points, double rate, final double time, final ParticleDisplay display) {
        final double rateDiv = Math.PI / rate;
        display.directional();
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            double theta = 0.0;
            long repeat = 0L;

            @Override
            public void run() {
                long l;
                this.theta += rateDiv;
                for (int i = 0; i < points; ++i) {
                    double multiplier = Math.PI * 2 * ((double)i / (double)points);
                    double x = Math.cos(this.theta + multiplier);
                    double z = Math.sin(this.theta + multiplier);
                    double angle = Math.atan2(z, x);
                    double xDirection = Math.cos(angle);
                    double zDirection = Math.sin(angle);
                    display.offset(xDirection, 0.0, zDirection);
                    display.spawn(x, 0.0, z);
                }
                ++this.repeat;
                if ((double)l > time) {
                    ((ScheduledTask)task.get()).cancel();
                    return;
                }
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L));
        return (ScheduledTask)task.get();
    }

    public static ScheduledTask moveRotatingAround(long update, final double rate, final double offsetx, final double offsety, final double offsetz, final Runnable runnable, final ParticleDisplay ... displays) {
        Runnable runnable1 = new Runnable(){
            double rotation = 180.0;

            @Override
            public void run() {
                this.rotation += rate;
                double x = Math.toRadians(90.0 + this.rotation);
                double y = Math.toRadians(60.0 + this.rotation);
                double z = Math.toRadians(30.0 + this.rotation);
                Vector vector = new Vector(offsetx * Math.PI, offsety * Math.PI, offsetz * Math.PI);
                if (offsetx != 0.0) {
                    ParticleDisplay.rotateAround(vector, ParticleDisplay.Axis.X, x);
                }
                if (offsety != 0.0) {
                    ParticleDisplay.rotateAround(vector, ParticleDisplay.Axis.Y, y);
                }
                if (offsetz != 0.0) {
                    ParticleDisplay.rotateAround(vector, ParticleDisplay.Axis.Z, z);
                }
                for (ParticleDisplay display : displays) {
                    display.getLocation().add(vector);
                }
                runnable.run();
                for (ParticleDisplay display : displays) {
                    display.getLocation().subtract(vector);
                }
            }
        };
        return SCore.schedulerHook.runAsyncRepeatingTask(runnable1, 0L, update);
    }

    public static ScheduledTask moveAround(long update, final double rate, final double endRate, final double offsetx, final double offsety, final double offsetz, final Runnable runnable, final ParticleDisplay ... displays) {
        Runnable runnable1 = new Runnable(){
            double multiplier = 0.0;
            boolean opposite = false;

            @Override
            public void run() {
                this.multiplier = this.opposite ? (this.multiplier -= rate) : (this.multiplier += rate);
                double x = this.multiplier * offsetx;
                double y = this.multiplier * offsety;
                double z = this.multiplier * offsetz;
                for (ParticleDisplay display : displays) {
                    display.getLocation().add(x, y, z);
                }
                runnable.run();
                for (ParticleDisplay display : displays) {
                    display.getLocation().subtract(x, y, z);
                }
                if (this.opposite) {
                    if (this.multiplier <= 0.0) {
                        this.opposite = false;
                    }
                } else if (this.multiplier >= endRate) {
                    this.opposite = true;
                }
            }
        };
        return SCore.schedulerHook.runAsyncRepeatingTask(runnable1, 0L, update);
    }

    public static ScheduledTask testDisplay(Runnable runnable) {
        return SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L);
    }

    public static ScheduledTask rotateAround(long update, final double rate, final double offsetx, final double offsety, final double offsetz, final Runnable runnable, final ParticleDisplay ... displays) {
        Runnable runnable1 = new Runnable(){
            double rotation = 180.0;

            @Override
            public void run() {
                this.rotation += rate;
                double x = Math.toRadians((90.0 + this.rotation) * offsetx);
                double y = Math.toRadians((60.0 + this.rotation) * offsety);
                double z = Math.toRadians((30.0 + this.rotation) * offsetz);
                Vector vector = new Vector(x, y, z);
                for (ParticleDisplay display : displays) {
                    display.rotate(vector);
                }
                runnable.run();
            }
        };
        return SCore.schedulerHook.runAsyncRepeatingTask(runnable1, 0L, update);
    }

    public static ScheduledTask spread(final int amount, final int rate, final Location start, final Location originEnd, final double offsetx, final double offsety, final double offsetz, final ParticleDisplay display) {
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            int count;
            {
                this.count = amount;
            }

            @Override
            public void run() {
                int frame = rate;
                while (frame-- != 0) {
                    double x = XParticle.random(-offsetx, offsetx);
                    double y = XParticle.random(-offsety, offsety);
                    double z = XParticle.random(-offsetz, offsetz);
                    Location end = originEnd.clone().add(x, y, z);
                    XParticle.line(start, end, 0.1, display);
                }
                if (this.count-- == 0) {
                    ((ScheduledTask)task.get()).cancel();
                }
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L));
        return (ScheduledTask)task.get();
    }

    public static void lightning(Location start, Vector direction, int entries, int branches, double radius, double offset, double offsetRate, double length, double lengthRate, double branch, double branchRate, ParticleDisplay display) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (entries <= 0) {
            return;
        }
        boolean inRange = true;
        while (random.nextDouble() < branch || inRange) {
            Vector randomizer = new Vector(random.nextDouble(-radius, radius), random.nextDouble(-radius, radius), random.nextDouble(-radius, radius)).normalize().multiply(random.nextDouble(-radius, radius) * offset);
            Vector endVector = start.clone().toVector().add(direction.clone().multiply(length)).add(randomizer);
            Location end = endVector.toLocation(start.getWorld());
            if (end.distance(start) <= length) {
                inRange = true;
                continue;
            }
            inRange = false;
            int rate = (int)(start.distance(end) / 0.1);
            Vector rateDir = endVector.clone().subtract(start.toVector()).normalize().multiply(0.1);
            for (int i = 0; i < rate; ++i) {
                Location loc = start.clone().add(rateDir.clone().multiply(i));
                display.spawn(loc);
            }
            XParticle.lightning(end.clone(), direction, entries - 1, branches - 1, radius, offset * offsetRate, offsetRate, length * lengthRate, lengthRate, branch * branchRate, branchRate, display);
            if (branches > 0) continue;
            break;
        }
    }

    public static void drawLine(Player player, double length, double rate, ParticleDisplay display) {
        Location eye = player.getEyeLocation();
        XParticle.line(eye, eye.clone().add(eye.getDirection().multiply(length)), rate, display);
    }

    public static ScheduledTask cloud(Plugin plugin, final ParticleDisplay cloud, final ParticleDisplay rain) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                cloud.spawn();
                rain.spawn();
            }
        };
        return SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L);
    }

    public static void line(Location start, Location end, double rate, ParticleDisplay display) {
        rate = Math.abs(rate);
        double x = end.getX() - start.getX();
        double y = end.getY() - start.getY();
        double z = end.getZ() - start.getZ();
        double length = Math.sqrt(NumberConversions.square((double)x) + NumberConversions.square((double)y) + NumberConversions.square((double)z));
        x /= length;
        y /= length;
        z /= length;
        ParticleDisplay clone = display.clone();
        clone.withLocation(start);
        for (double i = 0.0; i < length; i += rate) {
            clone.spawn(x * i, y * i, z * i);
        }
    }

    public static ScheduledTask tesseract(final double size, final double rate, final double speed, final double time, final ParticleDisplay display) {
        final double[][] positions = new double[][]{{-1.0, -1.0, -1.0, 1.0}, {1.0, -1.0, -1.0, 1.0}, {1.0, 1.0, -1.0, 1.0}, {-1.0, 1.0, -1.0, 1.0}, {-1.0, -1.0, 1.0, 1.0}, {1.0, -1.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 1.0}, {-1.0, 1.0, 1.0, 1.0}, {-1.0, -1.0, -1.0, -1.0}, {1.0, -1.0, -1.0, -1.0}, {1.0, 1.0, -1.0, -1.0}, {-1.0, 1.0, -1.0, -1.0}, {-1.0, -1.0, 1.0, -1.0}, {1.0, -1.0, 1.0, -1.0}, {1.0, 1.0, 1.0, -1.0}, {-1.0, 1.0, 1.0, -1.0}};
        final ArrayList<int[]> connections = new ArrayList<int[]>();
        int level = 1;
        for (int h = 0; h <= level; ++h) {
            int start;
            for (int i = start = 8 * h; i < start + 4; ++i) {
                connections.add(new int[]{i, (i + 1) % 4 + start});
                connections.add(new int[]{i + 4, (i + 1) % 4 + 4 + start});
                connections.add(new int[]{i, i + 4});
            }
        }
        for (int i = 0; i < (level + 1) * 4; ++i) {
            connections.add(new int[]{i, i + 8});
        }
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            double angle = 0.0;
            long repeat = 0L;

            @Override
            public void run() {
                long l;
                double cos = Math.cos(this.angle);
                double sin = Math.sin(this.angle);
                double[][] rotationXY = new double[][]{{cos, -sin, 0.0, 0.0}, {sin, cos, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
                double[][] rotationZW = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, cos, -sin}, {0.0, 0.0, sin, cos}};
                double[][] projected3D = new double[positions.length][4];
                for (int i = 0; i < positions.length; ++i) {
                    double[] point = positions[i];
                    double[] rotated = XParticle.matrix(rotationXY, point);
                    rotated = XParticle.matrix(rotationZW, rotated);
                    int distance = 2;
                    double w = 1.0 / ((double)distance - rotated[3]);
                    double[][] projection = new double[][]{{w, 0.0, 0.0, 0.0}, {0.0, w, 0.0, 0.0}, {0.0, 0.0, w, 0.0}};
                    double[] projected = XParticle.matrix(projection, rotated);
                    int proj = 0;
                    while (proj < projected.length) {
                        int n = proj++;
                        projected[n] = projected[n] * size;
                    }
                    projected3D[i] = projected;
                    display.spawn(projected[0], projected[1], projected[2]);
                }
                for (int[] connection : connections) {
                    double[] pointA = projected3D[connection[0]];
                    double[] pointB = projected3D[connection[1]];
                    Location start = display.cloneLocation(pointA[0], pointA[1], pointA[2]);
                    Location end = display.cloneLocation(pointB[0], pointB[1], pointB[2]);
                    XParticle.line(start, end, rate, display);
                }
                ++this.repeat;
                if ((double)l > time) {
                    ((ScheduledTask)task.get()).cancel();
                    return;
                }
                this.angle += speed;
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L));
        return (ScheduledTask)task.get();
    }

    private static double[] matrix(double[][] a, double[] m) {
        double[][] b = new double[4][1];
        b[0][0] = m[0];
        b[1][0] = m[1];
        b[2][0] = m[2];
        b[3][0] = m[3];
        int colsA = a[0].length;
        int rowsA = a.length;
        int colsB = b[0].length;
        int rowsB = b.length;
        double[][] result = new double[rowsA][rowsB];
        for (int i = 0; i < rowsA; ++i) {
            for (int j = 0; j < colsB; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < colsA; ++k) {
                    sum = (float)((double)sum + a[i][k] * b[k][j]);
                }
                result[i][j] = sum;
            }
        }
        double[] v = new double[4];
        v[0] = result[0][0];
        v[1] = result[1][0];
        v[2] = result[2][0];
        if (result.length > 3) {
            v[3] = result[3][0];
        }
        return v;
    }

    public static void star(final int points, int spikes, double rate, final double spikeLength, final double coreRadius, final double neuron, final boolean prototype, final int speed, final ParticleDisplay display) {
        final double pointsRate = Math.PI * 2 / (double)points;
        final double rateDiv = Math.PI / rate;
        final ThreadLocalRandom random = prototype ? null : ThreadLocalRandom.current();
        for (int i = 0; i < spikes * 2; ++i) {
            final double spikeAngle = (double)i * Math.PI / (double)spikes;
            final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
            Runnable runnable = new Runnable(){
                double vein = 0.0;
                double theta = 0.0;

                @Override
                public void run() {
                    int repeat = speed;
                    while (repeat-- != 0) {
                        this.theta += rateDiv;
                        double height = (prototype ? this.vein : random.nextDouble(0.0, Math.min(0.1, neuron))) * spikeLength;
                        if (prototype) {
                            this.vein += neuron;
                        }
                        Vector vector = new Vector(Math.cos(this.theta), 0.0, Math.sin(this.theta));
                        vector.multiply((spikeLength - height) * coreRadius / spikeLength);
                        vector.setY(coreRadius + height);
                        ParticleDisplay.rotateAround(vector, ParticleDisplay.Axis.X, spikeAngle);
                        for (int j = 0; j < points; ++j) {
                            ParticleDisplay.rotateAround(vector, ParticleDisplay.Axis.Y, pointsRate);
                            display.spawn(vector);
                        }
                        if (!(this.theta >= Math.PI * 2)) continue;
                        ((ScheduledTask)task.get()).cancel();
                        return;
                    }
                }
            };
            task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, 1L));
        }
    }

    public static void neopaganPentagram(double size, double rate, double extend, ParticleDisplay star, ParticleDisplay circle) {
        XParticle.polygon(5, 2, size, rate, extend, star);
        XParticle.circle(size + 0.5, rate * 1000.0, 0, "", "", circle);
    }

    public static Vector calculDirection(double yaw, double pitch) {
        double yawRad = Math.toRadians(yaw);
        double pitchRad = Math.toRadians(pitch);
        double x = -Math.cos(pitchRad) * Math.sin(yawRad);
        double y = -Math.sin(pitchRad);
        double z = Math.cos(pitchRad) * Math.cos(yawRad);
        return new Vector(x, y, z).normalize();
    }

    private static BufferedImage getImage(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            return ImageIO.read(Files.newInputStream(path, StandardOpenOption.READ));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static CompletableFuture<BufferedImage> getScaledImage(Path path, int width, int height) {
        return CompletableFuture.supplyAsync(() -> {
            BufferedImage image = XParticle.getImage(path);
            if (image == null) {
                return null;
            }
            int finalHeight = height;
            int finalWidth = width;
            if (image.getWidth() > image.getHeight()) {
                finalHeight = width * image.getHeight() / image.getWidth();
            } else {
                finalWidth = height * image.getWidth() / image.getHeight();
            }
            BufferedImage resizedImg = new BufferedImage(width, height, 2);
            Graphics2D graphics = resizedImg.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawImage(image, 0, 0, finalWidth, finalHeight, null);
            graphics.dispose();
            return resizedImg;
        });
    }

    public static CompletableFuture<Map<double[], org.bukkit.Color>> renderImage(Path path, int resizedWidth, int resizedHeight, double compact) {
        return XParticle.getScaledImage(path, resizedWidth, resizedHeight).thenCompose(image -> XParticle.renderImage(image, resizedWidth, resizedHeight, compact));
    }

    public static CompletableFuture<Map<double[], org.bukkit.Color>> renderImage(BufferedImage image, int resizedWidth, int resizedHeight, double compact) {
        return CompletableFuture.supplyAsync(() -> {
            if (image == null) {
                return null;
            }
            int width = image.getWidth();
            int height = image.getHeight();
            double centerX = (double)width / 2.0;
            double centerY = (double)height / 2.0;
            HashMap<double[], org.bukkit.Color> rendered = new HashMap<double[], org.bukkit.Color>();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = image.getRGB(x, y);
                    if (pixel >> 24 == 0) continue;
                    Color color = new Color(pixel);
                    int r = color.getRed();
                    int g = color.getGreen();
                    int b = color.getBlue();
                    double[] coords = new double[]{((double)x - centerX) * compact, ((double)y - centerY) * compact};
                    org.bukkit.Color bukkitColor = org.bukkit.Color.fromRGB((int)r, (int)g, (int)b);
                    rendered.put(coords, bukkitColor);
                }
            }
            return rendered;
        });
    }

    public static ScheduledTask displayRenderedImage(Plugin plugin, final Map<double[], org.bukkit.Color> render, final Callable<Location> location, final int repeat, long period, final int quality, final int speed, final float size) {
        final AtomicReference<ScheduledTask> task = new AtomicReference<ScheduledTask>();
        Runnable runnable = new Runnable(){
            int times;
            {
                this.times = repeat;
            }

            @Override
            public void run() {
                try {
                    XParticle.displayRenderedImage(render, (Location)location.call(), quality, speed, size);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.times-- < 1) {
                    ((ScheduledTask)task.get()).cancel();
                }
            }
        };
        task.set(SCore.schedulerHook.runAsyncRepeatingTask(runnable, 0L, period));
        return (ScheduledTask)task.get();
    }

    public static void displayRenderedImage(Map<double[], org.bukkit.Color> render, Location location, int quality, int speed, float size) {
        World world = location.getWorld();
        for (Map.Entry<double[], org.bukkit.Color> pixel : render.entrySet()) {
            Particle.DustOptions data = new Particle.DustOptions(pixel.getValue(), size);
            double[] pixelLoc = pixel.getKey();
            Location loc = new Location(world, location.getX() - pixelLoc[0], location.getY() - pixelLoc[1], location.getZ());
            Particle particle = SCore.is1v20v5Plus() ? Particle.DUST_COLOR_TRANSITION : Particle.valueOf((String)"REDSTONE");
            world.spawnParticle(particle, loc, quality, 0.0, 0.0, 0.0, (double)speed, (Object)data);
        }
    }

    public static void saveImage(BufferedImage image, Path path) {
        try {
            ImageIO.write((RenderedImage)image, "png", Files.newOutputStream(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CompletableFuture<BufferedImage> stringToImage(Font font, Color color, String str) {
        return CompletableFuture.supplyAsync(() -> {
            BufferedImage image = new BufferedImage(1, 1, 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setFont(font);
            FontRenderContext context = graphics.getFontMetrics().getFontRenderContext();
            Rectangle2D frame = font.getStringBounds(str, context);
            graphics.dispose();
            image = new BufferedImage((int)Math.ceil(frame.getWidth()), (int)Math.ceil(frame.getHeight()), 2);
            graphics = image.createGraphics();
            graphics.setColor(color);
            graphics.setFont(font);
            graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            FontMetrics metrics = graphics.getFontMetrics();
            graphics.drawString(str, 0, metrics.getAscent());
            graphics.dispose();
            return image;
        });
    }
}

