/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.api.executableitems.ExecutableItemsAPI;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.entity.EntityCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DropExecutableItem
extends EntityCommand {
    public static final Boolean DEBUG = false;

    @Override
    public void run(Player p, Entity entity, SCommandToExec sCommandToExec) {
        Optional<ExecutableItemInterface> eiOpt;
        int amount;
        List<String> args = sCommandToExec.getOtherArgs();
        if (SCore.hasExecutableItems && ExecutableItemsAPI.getExecutableItemsManager().isValidID(args.get(0)) && (amount = Double.valueOf(args.get(1)).intValue()) > 0 && (eiOpt = ExecutableItemsAPI.getExecutableItemsManager().getExecutableItem(args.get(0))).isPresent()) {
            entity.getWorld().dropItem(entity.getLocation(), eiOpt.get().buildItem(amount, Optional.empty(), Optional.ofNullable(p)));
        }
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return DropExecutableItem.staticVerif(args, isFinalVerification, this.getTemplate());
    }

    public static Optional<String> staticVerif(List<String> args, boolean isFinalVerification, String template) {
        if (args.size() < 2) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + template);
        }
        ArgumentChecker ac = DropExecutableItem.checkExecutableItemID(args.get(0), isFinalVerification, template);
        if (!ac.isValid()) {
            return Optional.of(ac.getError());
        }
        ArgumentChecker ac2 = DropExecutableItem.checkDouble(args.get(1), isFinalVerification, template);
        if (!ac2.isValid()) {
            return Optional.of(ac2.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("DROPEXECUTABLEITEM");
        return names;
    }

    @Override
    public String getTemplate() {
        return "DROPEXECUTABLEITEM {id} {quantity}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

