/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;

public class CopyEffects
extends MixedCommand {
    @Override
    public void run(Player p, Entity receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        if (!(receiver instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingReceiver = (LivingEntity)receiver;
        if (p == null || p.isDead() || receiver.isDead()) {
            return;
        }
        int limitDuration = Integer.MAX_VALUE;
        if (!args.isEmpty()) {
            limitDuration = Integer.parseInt(args.get(0));
        }
        HashSet potionEffects = new HashSet(livingReceiver.getActivePotionEffects());
        for (PotionEffect pe : potionEffects) {
            if (pe.getDuration() <= limitDuration) continue;
            pe = new PotionEffect(pe.getType(), limitDuration, pe.getAmplifier(), pe.isAmbient(), pe.hasParticles(), pe.hasIcon());
        }
        p.addPotionEffects(potionEffects);
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("COPYEFFECTS");
        return names;
    }

    @Override
    public String getTemplate() {
        return "COPYEFFECTS [limitDuration]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

