/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.events.NoFallDamageListener;
import com.ssomar.score.utils.Couple;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class FrontDash
extends MixedCommand {
    @Override
    public void run(Player p, final Entity receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        if (!(receiver instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingReceiver = (LivingEntity)receiver;
        double amount = Double.parseDouble(args.get(0));
        double customY = 0.0;
        if (args.size() > 1) {
            customY = Double.parseDouble(args.get(1));
        }
        boolean fallDamage = false;
        if (args.size() >= 3) {
            fallDamage = Boolean.parseBoolean(args.get(2));
        }
        Location pLoc = receiver.getLocation();
        if (SCore.is1v11Less() || !livingReceiver.isGliding()) {
            pLoc.setPitch(0.0f);
        }
        Vector v = pLoc.getDirection();
        v.multiply(amount);
        if (customY != 0.0) {
            Vector vec = new Vector();
            vec.setY(customY);
            v.add(vec);
        }
        receiver.setVelocity(v);
        final UUID uuid = UUID.randomUUID();
        if (!fallDamage) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    NoFallDamageListener.getInstance().removeNoFallDamage(receiver, uuid);
                }
            };
            ScheduledTask scheduledTask = SCore.schedulerHook.runTask(runnable, 300L);
            NoFallDamageListener.getInstance().addNoFallDamage(receiver, new Couple<UUID, ScheduledTask>(uuid, scheduledTask));
        }
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        String value;
        ArgumentChecker ac3;
        ArgumentChecker ac2;
        if (args.size() < 1) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + this.getTemplate());
        }
        ArgumentChecker ac = FrontDash.checkDouble(args.get(0), isFinalVerification, this.getTemplate());
        if (!ac.isValid()) {
            return Optional.of(ac.getError());
        }
        if (args.size() > 1 && !(ac2 = FrontDash.checkDouble(args.get(1), isFinalVerification, this.getTemplate())).isValid()) {
            return Optional.of(ac2.getError());
        }
        if (args.size() >= 3 && !(ac3 = FrontDash.checkBoolean(value = args.get(2), isFinalVerification, this.getTemplate())).isValid()) {
            return Optional.of(ac.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("FRONTDASH");
        return names;
    }

    @Override
    public String getTemplate() {
        return "FRONTDASH {number} [custom y] [fallDamage]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

