/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.activators.group;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.events.loop.LoopManager;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.custom.activators.group.ActivatorsFeatureEditor;
import com.ssomar.score.features.custom.activators.group.ActivatorsFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.scheduler.CustomTriggerScheduler;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ActivatorsFeature
extends FeatureWithHisOwnEditor<ActivatorsFeature, ActivatorsFeature, ActivatorsFeatureEditor, ActivatorsFeatureEditorManager>
implements FeaturesGroup<SActivator> {
    private LinkedHashMap<String, SActivator> activators;
    private SActivator builderInstance;
    private int premiumLimit = 1;

    public ActivatorsFeature(FeatureParentInterface parent, SActivator<?, ?, ?> builderInstance) {
        super(parent, FeatureSettingsSCore.activators);
        this.builderInstance = builderInstance;
        this.reset();
    }

    @Override
    public void reset() {
        this.activators = new LinkedHashMap();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection activatorsSection = config.getConfigurationSection(this.getName());
            for (String activatorID : activatorsSection.getKeys(false)) {
                if (this.activators.size() >= this.premiumLimit && !isPremiumLoading) {
                    error.add("&cERROR, Couldn't load the Activator of " + activatorID + " from config, &7&o" + this.getParent().getParentInfo() + " &6>> Because it requires the premium version to have more than 1 activator !");
                    return error;
                }
                SActivator activator = this.builderInstance.getBuilderInstance(this, activatorID);
                List<String> subErrors = activator.load(plugin, activatorsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                }
                if (activator.getOption().isLoopOption()) {
                    LoopManager.getInstance().addLoopActivator(activator);
                }
                if (activator.getOption().isCustomTriggerOption()) {
                    SsomarDev.testMsg("Activator " + activatorID + " is a custom trigger activator", true);
                    CustomTriggerScheduler.getInstance().addCustomTriggerScheduler(plugin.getShortName() + "_" + activatorID, activator.getRunnableForAll(), activator.getScheduleFeatures());
                }
                this.activators.put(activatorID, activator);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection attributesSection = config.createSection(this.getName());
        for (String actId : this.activators.keySet()) {
            this.activators.get(actId).save(attributesSection);
        }
        if (this.isSavingOnlyIfDiffDefault() && attributesSection.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public ActivatorsFeature getValue() {
        return this;
    }

    public List<SActivator> getActivators(SOption option, List<String> whitelistActivatorsId, List<SActivator> whitelistActivators) {
        ArrayList<SActivator> result = new ArrayList<SActivator>();
        for (SActivator activator : this.activators.values()) {
            if (!activator.getOption().equals(option) || !whitelistActivatorsId.isEmpty() && !whitelistActivatorsId.contains(activator.getId())) continue;
            if ((activator.getOption().isLoopOption() || activator.getOption().isCustomTriggerOption()) && !whitelistActivators.isEmpty()) {
                boolean valid = false;
                for (SActivator activatorCheck : whitelistActivators) {
                    if (!activatorCheck.isEqualsOrAClone(activator)) continue;
                    valid = true;
                }
                if (!valid) continue;
            }
            result.add(activator);
        }
        return result;
    }

    @Override
    public ActivatorsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oActivator(s) added: &e" + this.activators.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public SActivator getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (SActivator x : this.activators.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    public ActivatorsFeature clone() {
        return null;
    }

    @Override
    public ActivatorsFeature clone(FeatureParentInterface newParent) {
        ActivatorsFeature eF = new ActivatorsFeature(newParent, this.builderInstance);
        LinkedHashMap<String, SActivator> newActivators = new LinkedHashMap<String, SActivator>();
        for (String key : this.activators.keySet()) {
            SActivator clone = (SActivator)this.activators.get(key).clone(eF);
            newActivators.put(key, clone);
        }
        eF.setActivators(newActivators);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.activators.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof ActivatorsFeature)) continue;
            ActivatorsFeature eF = (ActivatorsFeature)feature;
            eF.setActivators(this.activators);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        ActivatorsFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        if (!this.isPremium() && this.activators.size() >= this.premiumLimit) {
            return;
        }
        String baseId = "activator";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.activators.containsKey(id)) continue;
            SActivator activator = this.builderInstance.getBuilderInstance(this, id);
            this.activators.put(id, activator);
            activator.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, SActivator feature) {
        LoopManager.getInstance().removeLoopActivator(this.activators.get(feature.getId()));
        this.activators.remove(feature.getId());
    }

    @Generated
    public LinkedHashMap<String, SActivator> getActivators() {
        return this.activators;
    }

    @Generated
    public SActivator getBuilderInstance() {
        return this.builderInstance;
    }

    @Generated
    public int getPremiumLimit() {
        return this.premiumLimit;
    }

    @Generated
    public void setActivators(LinkedHashMap<String, SActivator> activators) {
        this.activators = activators;
    }

    @Generated
    public void setBuilderInstance(SActivator builderInstance) {
        this.builderInstance = builderInstance;
    }

    @Generated
    public void setPremiumLimit(int premiumLimit) {
        this.premiumLimit = premiumLimit;
    }
}

