/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.aroundblock.aroundblock;

import com.ssomar.executableblocks.executableblocks.placedblocks.ExecutableBlockPlaced;
import com.ssomar.executableblocks.executableblocks.placedblocks.ExecutableBlocksPlacedManager;
import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.conditions.placeholders.group.PlaceholderConditionGroupFeature;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.list.ListDetailedMaterialFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class AroundBlockFeature
extends FeatureWithHisOwnEditor<AroundBlockFeature, AroundBlockFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private IntegerFeature southValue;
    private IntegerFeature northValue;
    private IntegerFeature westValue;
    private IntegerFeature eastValue;
    private IntegerFeature aboveValue;
    private IntegerFeature underValue;
    private ColoredStringFeature errorMessage;
    private ListDetailedMaterialFeature blockTypeMustBe;
    private PlaceholderConditionGroupFeature placeholderConditions;
    private String id;

    public AroundBlockFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.aroundBlock);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.southValue = new IntegerFeature(this, Optional.of(0), FeatureSettingsSCore.southValue);
        this.northValue = new IntegerFeature(this, Optional.of(0), FeatureSettingsSCore.northValue);
        this.westValue = new IntegerFeature(this, Optional.of(0), FeatureSettingsSCore.westValue);
        this.eastValue = new IntegerFeature(this, Optional.of(0), FeatureSettingsSCore.eastValue);
        this.aboveValue = new IntegerFeature(this, Optional.of(0), FeatureSettingsSCore.aboveValue);
        this.underValue = new IntegerFeature(this, Optional.of(0), FeatureSettingsSCore.underValue);
        this.errorMessage = new ColoredStringFeature(this, Optional.of("&c&oA block is not placed correctly !"), FeatureSettingsSCore.errorMsg);
        this.blockTypeMustBe = new ListDetailedMaterialFeature((FeatureParentInterface)this, new ArrayList<String>(), FeatureSettingsSCore.blockTypeMustBe, true);
        this.placeholderConditions = new PlaceholderConditionGroupFeature(this);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.southValue.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.northValue.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.westValue.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.eastValue.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.aboveValue.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.underValue.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.errorMessage.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.blockTypeMustBe.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.placeholderConditions.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the AroundBlockFeature with its options because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.southValue.save(attributeConfig);
        this.northValue.save(attributeConfig);
        this.westValue.save(attributeConfig);
        this.eastValue.save(attributeConfig);
        this.aboveValue.save(attributeConfig);
        this.underValue.save(attributeConfig);
        this.errorMessage.save(attributeConfig);
        this.blockTypeMustBe.save(attributeConfig);
        this.placeholderConditions.save(attributeConfig);
    }

    public boolean verif(Block block, Optional<Player> playerOpt, List<String> errors) {
        Location targetLoc = block.getLocation();
        targetLoc.add((double)(-((Integer)((Optional)this.westValue.getValue()).get()).intValue() + (Integer)((Optional)this.eastValue.getValue()).get()), (double)(-((Integer)((Optional)this.underValue.getValue()).get()).intValue() + (Integer)((Optional)this.aboveValue.getValue()).get()), (double)(-((Integer)((Optional)this.northValue.getValue()).get()).intValue() + (Integer)((Optional)this.southValue.getValue()).get()));
        Block targetBlock = targetLoc.getBlock();
        boolean valid = this.blockTypeMustBe.verifBlock(targetBlock);
        if (valid && !this.placeholderConditions.getPlaceholdersConditions().isEmpty()) {
            if (SCore.hasExecutableBlocks) {
                Optional eBP = ExecutableBlocksPlacedManager.getInstance().getExecutableBlockPlaced(targetBlock);
                if (eBP.isPresent()) {
                    ExecutableBlockPlaced eBP2 = (ExecutableBlockPlaced)eBP.get();
                    StringPlaceholder sp = eBP2.getPlaceholders();
                    if (!this.placeholderConditions.verify(playerOpt.orElse(null), null, sp, null)) {
                        valid = false;
                    }
                } else {
                    valid = false;
                }
            } else {
                valid = false;
            }
        }
        if (playerOpt.isPresent() && !valid && ((Optional)this.errorMessage.getValue()).isPresent()) {
            errors.add((String)((Optional)this.errorMessage.getValue()).get());
        }
        return valid;
    }

    @Override
    public AroundBlockFeature getValue() {
        return this;
    }

    @Override
    public AroundBlockFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 1];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public AroundBlockFeature clone(FeatureParentInterface newParent) {
        AroundBlockFeature eF = new AroundBlockFeature(newParent, this.id);
        eF.setSouthValue(this.southValue.clone(eF));
        eF.setNorthValue(this.northValue.clone(eF));
        eF.setWestValue(this.westValue.clone(eF));
        eF.setEastValue(this.eastValue.clone(eF));
        eF.setAboveValue(this.aboveValue.clone(eF));
        eF.setUnderValue(this.underValue.clone(eF));
        eF.setErrorMessage(this.errorMessage.clone(eF));
        eF.setBlockTypeMustBe(this.blockTypeMustBe.clone(eF));
        eF.setPlaceholderConditions(this.placeholderConditions.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.southValue, this.northValue, this.westValue, this.eastValue, this.aboveValue, this.underValue, this.errorMessage, this.blockTypeMustBe, this.placeholderConditions));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection parentSection = this.getParent().getConfigurationSection();
        if (parentSection.isConfigurationSection(this.getId())) {
            return parentSection.getConfigurationSection(this.getId());
        }
        return parentSection.createSection(this.getId());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            AroundBlockFeature aFOF;
            if (!(feature instanceof AroundBlockFeature) || !(aFOF = (AroundBlockFeature)feature).getId().equals(this.id)) continue;
            aFOF.setSouthValue(this.southValue);
            aFOF.setNorthValue(this.northValue);
            aFOF.setWestValue(this.westValue);
            aFOF.setEastValue(this.eastValue);
            aFOF.setAboveValue(this.aboveValue);
            aFOF.setUnderValue(this.underValue);
            aFOF.setErrorMessage(this.errorMessage);
            aFOF.setBlockTypeMustBe(this.blockTypeMustBe);
            aFOF.setPlaceholderConditions(this.placeholderConditions);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public IntegerFeature getSouthValue() {
        return this.southValue;
    }

    @Generated
    public IntegerFeature getNorthValue() {
        return this.northValue;
    }

    @Generated
    public IntegerFeature getWestValue() {
        return this.westValue;
    }

    @Generated
    public IntegerFeature getEastValue() {
        return this.eastValue;
    }

    @Generated
    public IntegerFeature getAboveValue() {
        return this.aboveValue;
    }

    @Generated
    public IntegerFeature getUnderValue() {
        return this.underValue;
    }

    @Generated
    public ColoredStringFeature getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public ListDetailedMaterialFeature getBlockTypeMustBe() {
        return this.blockTypeMustBe;
    }

    @Generated
    public PlaceholderConditionGroupFeature getPlaceholderConditions() {
        return this.placeholderConditions;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setSouthValue(IntegerFeature southValue) {
        this.southValue = southValue;
    }

    @Generated
    public void setNorthValue(IntegerFeature northValue) {
        this.northValue = northValue;
    }

    @Generated
    public void setWestValue(IntegerFeature westValue) {
        this.westValue = westValue;
    }

    @Generated
    public void setEastValue(IntegerFeature eastValue) {
        this.eastValue = eastValue;
    }

    @Generated
    public void setAboveValue(IntegerFeature aboveValue) {
        this.aboveValue = aboveValue;
    }

    @Generated
    public void setUnderValue(IntegerFeature underValue) {
        this.underValue = underValue;
    }

    @Generated
    public void setErrorMessage(ColoredStringFeature errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setBlockTypeMustBe(ListDetailedMaterialFeature blockTypeMustBe) {
        this.blockTypeMustBe = blockTypeMustBe;
    }

    @Generated
    public void setPlaceholderConditions(PlaceholderConditionGroupFeature placeholderConditions) {
        this.placeholderConditions = placeholderConditions;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

