/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.canbeusedbyowner;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.list.ListUncoloredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CanBeUsedOnlyByOwnerFeatures
extends FeatureWithHisOwnEditor<CanBeUsedOnlyByOwnerFeatures, CanBeUsedOnlyByOwnerFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private BooleanFeature canBeUsedOnlyByTheOwner;
    private BooleanFeature cancelEventIfNotOwner;
    private ListUncoloredStringFeature blackListedActivators;

    public CanBeUsedOnlyByOwnerFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.canBeUsedOnlyByTheOwner);
        this.reset();
    }

    @Override
    public void reset() {
        this.canBeUsedOnlyByTheOwner = new BooleanFeature(this, false, FeatureSettingsSCore.canBeUsedOnlyByTheOwner);
        this.cancelEventIfNotOwner = new BooleanFeature(this, false, FeatureSettingsSCore.cancelEventIfNotOwner);
        this.blackListedActivators = new ListUncoloredStringFeature((FeatureParentInterface)this, new ArrayList<String>(), FeatureSettingsSCore.onlyOwnerBlackListedActivators, Optional.empty());
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(this.canBeUsedOnlyByTheOwner.load(plugin, config, isPremiumLoading));
        errors.addAll(this.cancelEventIfNotOwner.load(plugin, config, isPremiumLoading));
        errors.addAll(this.blackListedActivators.load(plugin, config, isPremiumLoading));
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        this.canBeUsedOnlyByTheOwner.save(config);
        this.cancelEventIfNotOwner.save(config);
        this.blackListedActivators.save(config);
    }

    @Override
    public CanBeUsedOnlyByOwnerFeatures getValue() {
        return this;
    }

    @Override
    public CanBeUsedOnlyByOwnerFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 3] = this.canBeUsedOnlyByTheOwner.getValue() != false ? "&7Can be used only by the owner: &a&l\u2714" : "&7Can be used only by the owner: &c&l\u2718";
        finalDescription[finalDescription.length - 2] = this.cancelEventIfNotOwner.getValue() != false ? "&7CancelEvent Not owner: &a&l\u2714" : "&7CancelEvent Not owner: &c&l\u2718";
        finalDescription[finalDescription.length - 1] = "&7BlackListed Activators: &e" + this.blackListedActivators.getValue().toString();
        gui.createItem(GUI.GRINDSTONE, 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public CanBeUsedOnlyByOwnerFeatures clone(FeatureParentInterface newParent) {
        CanBeUsedOnlyByOwnerFeatures dropFeatures = new CanBeUsedOnlyByOwnerFeatures(newParent);
        dropFeatures.setCanBeUsedOnlyByTheOwner(this.canBeUsedOnlyByTheOwner.clone(dropFeatures));
        dropFeatures.setCancelEventIfNotOwner(this.cancelEventIfNotOwner.clone(dropFeatures));
        dropFeatures.setBlackListedActivators(this.blackListedActivators.clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.canBeUsedOnlyByTheOwner);
        features.add(this.cancelEventIfNotOwner);
        features.add(this.blackListedActivators);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof CanBeUsedOnlyByOwnerFeatures)) continue;
            CanBeUsedOnlyByOwnerFeatures hiders = (CanBeUsedOnlyByOwnerFeatures)feature;
            hiders.setCanBeUsedOnlyByTheOwner(this.canBeUsedOnlyByTheOwner);
            hiders.setCancelEventIfNotOwner(this.cancelEventIfNotOwner);
            hiders.setBlackListedActivators(this.blackListedActivators);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public BooleanFeature getCanBeUsedOnlyByTheOwner() {
        return this.canBeUsedOnlyByTheOwner;
    }

    @Generated
    public BooleanFeature getCancelEventIfNotOwner() {
        return this.cancelEventIfNotOwner;
    }

    @Generated
    public ListUncoloredStringFeature getBlackListedActivators() {
        return this.blackListedActivators;
    }

    @Generated
    public void setCanBeUsedOnlyByTheOwner(BooleanFeature canBeUsedOnlyByTheOwner) {
        this.canBeUsedOnlyByTheOwner = canBeUsedOnlyByTheOwner;
    }

    @Generated
    public void setCancelEventIfNotOwner(BooleanFeature cancelEventIfNotOwner) {
        this.cancelEventIfNotOwner = cancelEventIfNotOwner;
    }

    @Generated
    public void setBlackListedActivators(ListUncoloredStringFeature blackListedActivators) {
        this.blackListedActivators = blackListedActivators;
    }
}

