/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.block.condition;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.block.BlockConditionFeature;
import com.ssomar.score.features.custom.conditions.block.BlockConditionRequest;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.usedapi.ShopGUIPlusTool;
import java.util.Optional;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class IfContainerContainsSellableItem
extends BlockConditionFeature<BooleanFeature, IfContainerContainsSellableItem> {
    public IfContainerContainsSellableItem(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifContainerContainsSellableItems);
    }

    @Override
    public boolean verifCondition(BlockConditionRequest request) {
        if (this.hasCondition()) {
            Optional<Player> playerOpt = request.getPlayerOpt();
            Block b = request.getBlock();
            if (playerOpt.isPresent() && b.getState() instanceof Container) {
                Container container = (Container)b.getState();
                Inventory inv = container.getInventory();
                for (int i = 0; i < inv.getSize(); ++i) {
                    double check;
                    ItemStack item = inv.getItem(i);
                    if (item == null || !SCore.hasShopGUIPlus || !((check = ShopGUIPlusTool.sellItem(playerOpt.get(), item)) > 0.0)) continue;
                    return true;
                }
            }
            this.runInvalidCondition(request);
            return false;
        }
        return true;
    }

    @Override
    public boolean hasCondition() {
        return ((BooleanFeature)this.getCondition()).getValue();
    }

    @Override
    public IfContainerContainsSellableItem getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.ifContainerContainsSellableItems));
    }

    @Override
    public IfContainerContainsSellableItem getNewInstance(FeatureParentInterface parent) {
        return new IfContainerContainsSellableItem(parent);
    }
}

