/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.block.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.block.BlockConditionFeature;
import com.ssomar.score.features.custom.conditions.block.BlockConditionRequest;
import com.ssomar.score.features.types.BooleanFeature;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockGrowEvent;

public class IfPlantNotFullyGrown
extends BlockConditionFeature<BooleanFeature, IfPlantNotFullyGrown> {
    public IfPlantNotFullyGrown(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifPlantNotFullyGrown);
    }

    @Override
    public boolean hasCondition() {
        return ((BooleanFeature)this.getCondition()).isConfigured();
    }

    @Override
    public boolean verifCondition(BlockConditionRequest request) {
        Ageable ageable;
        int age;
        Block b = request.getBlock();
        Event event = request.getEvent();
        BlockData blockData = b.getState().getBlockData();
        if (event instanceof BlockGrowEvent) {
            BlockGrowEvent blockGrowEvent = (BlockGrowEvent)event;
            blockData = blockGrowEvent.getNewState().getBlockData();
        }
        if (((BooleanFeature)this.getCondition()).getValue(request.getSp()).booleanValue() && blockData instanceof Ageable && (age = (ageable = (Ageable)blockData).getAge()) == ageable.getMaximumAge()) {
            this.runInvalidCondition(request);
            return false;
        }
        return true;
    }

    @Override
    public IfPlantNotFullyGrown getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.ifPlantNotFullyGrown));
    }

    @Override
    public IfPlantNotFullyGrown getNewInstance(FeatureParentInterface parent) {
        return new IfPlantNotFullyGrown(parent);
    }
}

