/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.entity.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.entity.EntityConditionFeature;
import com.ssomar.score.features.custom.conditions.entity.EntityConditionRequest;
import com.ssomar.score.features.types.NumberConditionFeature;
import com.ssomar.score.utils.strings.StringCalculation;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class IfEntityVelocity
extends EntityConditionFeature<NumberConditionFeature, IfEntityVelocity> {
    public IfEntityVelocity(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifEntityVelocity);
    }

    @Override
    public boolean verifCondition(EntityConditionRequest request) {
        if (this.hasCondition()) {
            Entity entity = request.getEntity();
            Vector velocity = entity.getVelocity();
            double velocityMagnitude = velocity.length();
            if (!StringCalculation.calculation(((NumberConditionFeature)this.getCondition()).getValue(request.getPlayerOpt(), request.getSp()).get(), velocityMagnitude)) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfEntityVelocity getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new NumberConditionFeature(this.getParent(), FeatureSettingsSCore.ifEntityVelocity));
    }

    @Override
    public boolean hasCondition() {
        return ((Optional)((NumberConditionFeature)this.getCondition()).getValue()).isPresent();
    }

    @Override
    public IfEntityVelocity getNewInstance(FeatureParentInterface parent) {
        return new IfEntityVelocity(parent);
    }
}

