/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.entity.parent;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.conditions.entity.EntityConditionFeature;
import com.ssomar.score.features.custom.conditions.entity.EntityConditionRequest;
import com.ssomar.score.features.custom.conditions.entity.condition.IfAdult;
import com.ssomar.score.features.custom.conditions.entity.condition.IfBaby;
import com.ssomar.score.features.custom.conditions.entity.condition.IfEntityAge;
import com.ssomar.score.features.custom.conditions.entity.condition.IfEntityHealth;
import com.ssomar.score.features.custom.conditions.entity.condition.IfEntityInRegion;
import com.ssomar.score.features.custom.conditions.entity.condition.IfEntityIsInLava;
import com.ssomar.score.features.custom.conditions.entity.condition.IfEntityIsInWater;
import com.ssomar.score.features.custom.conditions.entity.condition.IfEntityLastDamageCause;
import com.ssomar.score.features.custom.conditions.entity.condition.IfEntityVelocity;
import com.ssomar.score.features.custom.conditions.entity.condition.IfFromSpawner;
import com.ssomar.score.features.custom.conditions.entity.condition.IfFrozen;
import com.ssomar.score.features.custom.conditions.entity.condition.IfGlowing;
import com.ssomar.score.features.custom.conditions.entity.condition.IfHasAI;
import com.ssomar.score.features.custom.conditions.entity.condition.IfHasSaddle;
import com.ssomar.score.features.custom.conditions.entity.condition.IfHasTag;
import com.ssomar.score.features.custom.conditions.entity.condition.IfInvulnerable;
import com.ssomar.score.features.custom.conditions.entity.condition.IfIsNotOnTheBlock;
import com.ssomar.score.features.custom.conditions.entity.condition.IfIsOnTheBlock;
import com.ssomar.score.features.custom.conditions.entity.condition.IfName;
import com.ssomar.score.features.custom.conditions.entity.condition.IfNamed;
import com.ssomar.score.features.custom.conditions.entity.condition.IfNotEntityInRegion;
import com.ssomar.score.features.custom.conditions.entity.condition.IfNotEntityType;
import com.ssomar.score.features.custom.conditions.entity.condition.IfNotFromSpawner;
import com.ssomar.score.features.custom.conditions.entity.condition.IfNotHasAI;
import com.ssomar.score.features.custom.conditions.entity.condition.IfNotHasSaddle;
import com.ssomar.score.features.custom.conditions.entity.condition.IfNotHasTag;
import com.ssomar.score.features.custom.conditions.entity.condition.IfNotNamed;
import com.ssomar.score.features.custom.conditions.entity.condition.IfNotTamed;
import com.ssomar.score.features.custom.conditions.entity.condition.IfOnFire;
import com.ssomar.score.features.custom.conditions.entity.condition.IfPowered;
import com.ssomar.score.features.custom.conditions.entity.condition.IfSheepColor;
import com.ssomar.score.features.custom.conditions.entity.condition.IfTamed;
import com.ssomar.score.features.custom.conditions.entity.parent.EntityConditionsFeatureEditor;
import com.ssomar.score.features.custom.conditions.entity.parent.EntityConditionsFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityConditionsFeature
extends FeatureWithHisOwnEditor<EntityConditionsFeature, EntityConditionsFeature, EntityConditionsFeatureEditor, EntityConditionsFeatureEditorManager> {
    private List<EntityConditionFeature> conditions;

    public EntityConditionsFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.reset();
    }

    @Override
    public void reset() {
        this.conditions = new ArrayList<EntityConditionFeature>();
        this.conditions.add(new IfAdult(this));
        this.conditions.add(new IfBaby(this));
        this.conditions.add(new IfFrozen(this));
        this.conditions.add(new IfGlowing(this));
        this.conditions.add(new IfInvulnerable(this));
        if (!SCore.is1v11Less()) {
            this.conditions.add(new IfNamed(this));
            this.conditions.add(new IfNotNamed(this));
        }
        this.conditions.add(new IfOnFire(this));
        this.conditions.add(new IfPowered(this));
        this.conditions.add(new IfTamed(this));
        this.conditions.add(new IfNotTamed(this));
        this.conditions.add(new IfHasAI(this));
        this.conditions.add(new IfNotHasAI(this));
        if (!SCore.is1v13Less()) {
            this.conditions.add(new IfFromSpawner(this));
            this.conditions.add(new IfNotFromSpawner(this));
        }
        this.conditions.add(new IfHasSaddle(this));
        this.conditions.add(new IfNotHasSaddle(this));
        this.conditions.add(new IfEntityIsInWater(this));
        this.conditions.add(new IfEntityIsInLava(this));
        this.conditions.add(new IfEntityHealth(this));
        this.conditions.add(new IfEntityAge(this));
        this.conditions.add(new IfEntityVelocity(this));
        this.conditions.add(new IfHasTag(this));
        this.conditions.add(new IfNotHasTag(this));
        this.conditions.add(new IfSheepColor(this));
        this.conditions.add(new IfEntityInRegion(this));
        this.conditions.add(new IfNotEntityInRegion(this));
        this.conditions.add(new IfEntityLastDamageCause(this));
        this.conditions.add(new IfIsOnTheBlock(this));
        this.conditions.add(new IfIsNotOnTheBlock(this));
        this.conditions.add(new IfName(this));
        this.conditions.add(new IfNotEntityType(this));
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            for (EntityConditionFeature condition : this.conditions) {
                error.addAll(condition.load(plugin, section, isPremiumLoading));
            }
        }
        return error;
    }

    public boolean verifConditions(Entity entity, Optional<Player> playerOpt, SendMessage messageSender, @Nullable Event event) {
        EntityConditionRequest args = new EntityConditionRequest(entity, playerOpt, messageSender.getSp(), event);
        for (EntityConditionFeature condition : this.conditions) {
            if (condition.verifCondition(args)) continue;
            if (messageSender != null && playerOpt.isPresent()) {
                for (String error : args.getErrorsFinal()) {
                    messageSender.sendMessage(playerOpt.get(), error);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        for (EntityConditionFeature condition : this.conditions) {
            condition.save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public EntityConditionsFeature getValue() {
        return this;
    }

    @Override
    public EntityConditionsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = "&7Entity condition(s) enabled: &e" + this.getEntityConditionEnabledCount();
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    public int getEntityConditionEnabledCount() {
        int i = 0;
        for (EntityConditionFeature condition : this.conditions) {
            if (!condition.hasCondition()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public EntityConditionsFeature clone(FeatureParentInterface newParent) {
        EntityConditionsFeature clone = new EntityConditionsFeature(newParent, this.getFeatureSettings());
        ArrayList<EntityConditionFeature> clones = new ArrayList<EntityConditionFeature>();
        for (EntityConditionFeature condition : this.conditions) {
            clones.add((EntityConditionFeature)condition.clone(clone));
        }
        clone.setConditions(clones);
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.conditions);
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof EntityConditionsFeature) || !feature.getName().equals(this.getName())) continue;
            EntityConditionsFeature bCF = (EntityConditionsFeature)feature;
            ArrayList<EntityConditionFeature> clones = new ArrayList<EntityConditionFeature>();
            for (EntityConditionFeature condition : this.conditions) {
                clones.add(condition);
            }
            bCF.setConditions(clones);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        EntityConditionsFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public List<EntityConditionFeature> getConditions() {
        return this.conditions;
    }

    @Generated
    public void setConditions(List<EntityConditionFeature> conditions) {
        this.conditions = conditions;
    }
}

