/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.item.parent;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.conditions.item.ItemConditionFeature;
import com.ssomar.score.features.custom.conditions.item.ItemConditionRequest;
import com.ssomar.score.features.custom.conditions.item.condition.IfCrossbowMustBeCharged;
import com.ssomar.score.features.custom.conditions.item.condition.IfCrossbowMustNotBeCharged;
import com.ssomar.score.features.custom.conditions.item.condition.IfDurability;
import com.ssomar.score.features.custom.conditions.item.condition.IfHasEnchant;
import com.ssomar.score.features.custom.conditions.item.condition.IfHasNotEnchant;
import com.ssomar.score.features.custom.conditions.item.condition.IfUsage;
import com.ssomar.score.features.custom.conditions.item.condition.IfUseCooldown;
import com.ssomar.score.features.custom.conditions.item.parent.ItemConditionsFeatureEditor;
import com.ssomar.score.features.custom.conditions.item.parent.ItemConditionsFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConditionsFeature
extends FeatureWithHisOwnEditor<ItemConditionsFeature, ItemConditionsFeature, ItemConditionsFeatureEditor, ItemConditionsFeatureEditorManager> {
    private List<ItemConditionFeature> conditions;

    public ItemConditionsFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.reset();
    }

    @Override
    public void reset() {
        this.conditions = new ArrayList<ItemConditionFeature>();
        if (!SCore.is1v12Less()) {
            this.conditions.add(new IfCrossbowMustBeCharged(this));
            this.conditions.add(new IfCrossbowMustNotBeCharged(this));
        }
        if (SCore.is1v21v2Plus()) {
            this.conditions.add(new IfUseCooldown(this));
        }
        this.conditions.add(new IfDurability(this));
        this.conditions.add(new IfUsage(this));
        this.conditions.add(new IfHasEnchant(this));
        this.conditions.add(new IfHasNotEnchant(this));
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            for (ItemConditionFeature condition : this.conditions) {
                error.addAll(condition.load(plugin, section, isPremiumLoading));
            }
        }
        return error;
    }

    public boolean verifConditions(ItemStack itemStack, Optional<Player> playerOpt, SendMessage messageSender, @Nullable Event event) {
        ItemConditionRequest request = new ItemConditionRequest(itemStack, playerOpt, new StringPlaceholder(), event);
        for (ItemConditionFeature condition : this.conditions) {
            if (condition.verifCondition(request)) continue;
            if (messageSender != null && playerOpt.isPresent()) {
                for (String error : request.getErrorsFinal()) {
                    messageSender.sendMessage(playerOpt.get(), error);
                }
            }
            return false;
        }
        return true;
    }

    public boolean verifConditions(ItemStack itemStack, List<String> errors, @Nullable StringPlaceholder stringPlaceholder) {
        if (stringPlaceholder == null) {
            stringPlaceholder = new StringPlaceholder();
        }
        ItemConditionRequest request = new ItemConditionRequest(itemStack, Optional.empty(), stringPlaceholder, null);
        for (ItemConditionFeature condition : this.conditions) {
            if (condition.verifCondition(request)) continue;
            errors.addAll(request.getErrorsFinal());
            return false;
        }
        return true;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        for (ItemConditionFeature condition : this.conditions) {
            condition.save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public ItemConditionsFeature getValue() {
        return this;
    }

    @Override
    public ItemConditionsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = "&7Item condition(s) enabled: &e" + this.getItemConditionEnabledCount();
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    public int getItemConditionEnabledCount() {
        int i = 0;
        for (ItemConditionFeature condition : this.conditions) {
            if (!condition.hasCondition()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public ItemConditionsFeature clone(FeatureParentInterface newParent) {
        ItemConditionsFeature clone = new ItemConditionsFeature(newParent, this.getFeatureSettings());
        ArrayList<ItemConditionFeature> clones = new ArrayList<ItemConditionFeature>();
        for (ItemConditionFeature condition : this.conditions) {
            clones.add((ItemConditionFeature)condition.clone(clone));
        }
        clone.setConditions(clones);
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.conditions);
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof ItemConditionsFeature) || !feature.getName().equals(this.getName())) continue;
            ItemConditionsFeature bCF = (ItemConditionsFeature)feature;
            ArrayList<ItemConditionFeature> clones = new ArrayList<ItemConditionFeature>();
            for (ItemConditionFeature condition : this.conditions) {
                clones.add(condition);
            }
            bCF.setConditions(clones);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        ItemConditionsFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public List<ItemConditionFeature> getConditions() {
        return this.conditions;
    }

    @Generated
    public void setConditions(List<ItemConditionFeature> conditions) {
        this.conditions = conditions;
    }
}

