/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.types.NumberConditionFeature;
import com.ssomar.score.utils.strings.StringCalculation;
import java.util.Optional;
import org.bukkit.entity.Player;

public class IfPlayerLevel
extends PlayerConditionFeature<NumberConditionFeature, IfPlayerLevel> {
    public IfPlayerLevel(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifPlayerLevel);
    }

    @Override
    public boolean verifCondition(PlayerConditionRequest request) {
        Player player = request.getPlayer();
        if (this.hasCondition() && !StringCalculation.calculation(((NumberConditionFeature)this.getCondition()).getValue(Optional.of(player), request.getSp()).get(), player.getLevel())) {
            this.runInvalidCondition(request);
            return false;
        }
        return true;
    }

    @Override
    public IfPlayerLevel getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new NumberConditionFeature(this, FeatureSettingsSCore.ifPlayerLevel));
    }

    @Override
    public boolean hasCondition() {
        return ((Optional)((NumberConditionFeature)this.getCondition()).getValue()).isPresent();
    }

    @Override
    public IfPlayerLevel getNewInstance(FeatureParentInterface parent) {
        return new IfPlayerLevel(parent);
    }
}

