/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.nbttags;

import com.ssomar.score.features.custom.nbttags.NBTTag;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public class ByteNBTTag
extends NBTTag {
    private byte valueByte;
    private boolean isValueByte;

    public ByteNBTTag(ConfigurationSection configurationSection) {
        super(configurationSection);
    }

    public ByteNBTTag(String key, byte valueByte) {
        super(key);
        this.valueByte = valueByte;
        this.isValueByte = true;
    }

    @Override
    public boolean applyTo(ReadWriteNBT nbtItem, boolean onlyIfDifferent) {
        if (!onlyIfDifferent || nbtItem.getByte(this.getKey()).byteValue() != this.getValueByte()) {
            nbtItem.setByte(this.getKey(), Byte.valueOf(this.getValueByte()));
            return true;
        }
        return false;
    }

    @Override
    public boolean applyTo(NBTCompound nbtCompound, boolean onlyIfDifferent) {
        if (!onlyIfDifferent || nbtCompound.getByte(this.getKey()).byteValue() != this.getValueByte()) {
            nbtCompound.setByte(this.getKey(), Byte.valueOf(this.getValueByte()));
            return true;
        }
        return false;
    }

    @Override
    public void saveValueInConfig(ConfigurationSection configurationSection, Integer index) {
        configurationSection.set("nbt." + index + ".type", (Object)"BYTE");
        configurationSection.set("nbt." + index + ".value", (Object)this.getValueByte());
    }

    @Override
    public void loadValueFromConfig(ConfigurationSection configurationSection) {
        byte b = 0;
        int i2 = configurationSection.getInt("value", 0);
        if (i2 == 1) {
            b = 1;
        }
        this.valueByte = b;
    }

    @Generated
    public byte getValueByte() {
        return this.valueByte;
    }
}

