/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.patterns.group;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.patterns.group.PatternsGroupFeatureEditor;
import com.ssomar.score.features.custom.patterns.group.PatternsGroupFeatureEditorManager;
import com.ssomar.score.features.custom.patterns.subgroup.PatternFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.block.Banner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class PatternsGroupFeature
extends FeatureWithHisOwnEditor<PatternsGroupFeature, PatternsGroupFeature, PatternsGroupFeatureEditor, PatternsGroupFeatureEditorManager>
implements FeaturesGroup<PatternFeature> {
    private Map<String, PatternFeature> patterns;

    public PatternsGroupFeature(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.patterns);
        this.reset();
    }

    @Override
    public void reset() {
        this.patterns = new HashMap<String, PatternFeature>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                PatternFeature attribute = new PatternFeature((FeatureParentInterface)this, attributeID);
                List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.patterns.put(attributeID, attribute);
            }
        }
        return error;
    }

    public void load(SPlugin plugin, ItemStack item, boolean isPremiumLoading) {
        if (item != null && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            this.load(plugin, meta, isPremiumLoading);
        }
    }

    public void load(SPlugin plugin, ItemMeta meta, boolean isPremiumLoading) {
        Banner banner;
        List patterns;
        BannerMeta bmeta;
        List patterns2;
        if (meta instanceof BannerMeta && (patterns2 = (bmeta = (BannerMeta)meta).getPatterns()).size() > 0) {
            int i = 0;
            for (Pattern pattern : patterns2) {
                PatternFeature patternFeature = new PatternFeature((FeatureParentInterface)this, "pattern" + i);
                patternFeature.load(plugin, pattern, isPremiumLoading);
                this.patterns.put("pattern" + i, patternFeature);
                ++i;
            }
        }
        if (meta instanceof BlockStateMeta && (patterns = (banner = (Banner)(bmeta = (BlockStateMeta)meta).getBlockState()).getPatterns()).size() > 0) {
            int i = 0;
            for (Pattern pattern : patterns) {
                PatternFeature patternFeature = new PatternFeature((FeatureParentInterface)this, "pattern" + i);
                patternFeature.load(plugin, pattern, isPremiumLoading);
                this.patterns.put("pattern" + i, patternFeature);
                ++i;
            }
        }
    }

    public List<Pattern> getMCPatterns() {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        TreeMap<String, PatternFeature> sortedAttributes = new TreeMap<String, PatternFeature>(this.patterns);
        for (PatternFeature pattern : sortedAttributes.values()) {
            patterns.add(pattern.getPattern());
        }
        return patterns;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection attributesSection = config.createSection(this.getName());
        TreeMap<String, PatternFeature> sortedAttributes = new TreeMap<String, PatternFeature>(this.patterns);
        for (String enchantmentID : sortedAttributes.keySet()) {
            this.patterns.get(enchantmentID).save(attributesSection);
        }
    }

    @Override
    public PatternsGroupFeature getValue() {
        return this;
    }

    @Override
    public PatternsGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oPattern(s) added: &e" + this.patterns.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public PatternFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (PatternFeature x : this.patterns.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public PatternsGroupFeature clone(FeatureParentInterface newParent) {
        PatternsGroupFeature eF = new PatternsGroupFeature(newParent);
        HashMap<String, PatternFeature> newPatterns = new HashMap<String, PatternFeature>();
        for (String x : this.patterns.keySet()) {
            newPatterns.put(x, this.patterns.get(x).clone(eF));
        }
        eF.setPatterns(newPatterns);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.patterns.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof PatternsGroupFeature)) continue;
            PatternsGroupFeature eF = (PatternsGroupFeature)feature;
            eF.setPatterns(this.patterns);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        PatternsGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "pattern";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.patterns.containsKey(id)) continue;
            PatternFeature eF = new PatternFeature((FeatureParentInterface)this, id);
            this.patterns.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, PatternFeature feature) {
        this.patterns.remove(feature.getId());
    }

    @Generated
    public Map<String, PatternFeature> getPatterns() {
        return this.patterns;
    }

    @Generated
    public void setPatterns(Map<String, PatternFeature> patterns) {
        this.patterns = patterns;
    }
}

