/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.restrictions;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.restrictions.RestrictionEnum;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Restrictions
extends FeatureWithHisOwnEditor<Restrictions, Restrictions, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private Map<RestrictionEnum, BooleanFeature> restrictions;
    private Map<RestrictionEnum, Boolean> defaultValues;
    private List<RestrictionEnum> notFor1_11_less;
    private List<RestrictionEnum> notFor1_13_less;
    private List<RestrictionEnum> notFor1_18_less;
    private List<RestrictionEnum> notFor1_19_less;

    public Restrictions(FeatureParentInterface parent, Map<RestrictionEnum, Boolean> defaultValues) {
        super(parent, FeatureSettingsSCore.restrictions);
        this.defaultValues = defaultValues;
        this.notFor1_11_less = new ArrayList<RestrictionEnum>();
        this.notFor1_11_less.add(RestrictionEnum.CANCEL_SWAPHAND);
        this.notFor1_13_less = new ArrayList<RestrictionEnum>();
        this.notFor1_13_less.add(RestrictionEnum.CANCEL_STONE_CUTTER);
        this.notFor1_13_less.add(RestrictionEnum.CANCEL_CARTOGRAPHY);
        this.notFor1_13_less.add(RestrictionEnum.CANCEL_COMPOSTER);
        this.notFor1_13_less.add(RestrictionEnum.CANCEL_LECTERN);
        this.notFor1_13_less.add(RestrictionEnum.CANCEL_LOOM);
        this.notFor1_13_less.add(RestrictionEnum.CANCEL_GRIND_STONE);
        this.notFor1_13_less.add(RestrictionEnum.CANCEL_SMITHING_TABLE);
        this.notFor1_18_less = new ArrayList<RestrictionEnum>();
        this.notFor1_18_less.add(RestrictionEnum.CANCEL_HORN);
        this.notFor1_19_less = new ArrayList<RestrictionEnum>();
        this.notFor1_19_less.add(RestrictionEnum.CANCEL_DECORATED_POT);
        this.notFor1_19_less.add(RestrictionEnum.CANCEL_CRAFTER);
        this.reset();
    }

    @Override
    public void reset() {
        this.restrictions = new LinkedHashMap<RestrictionEnum, BooleanFeature>();
        for (RestrictionEnum restriction : RestrictionEnum.values()) {
            if (SCore.is1v11Less() && this.notFor1_11_less.contains((Object)restriction) || SCore.is1v13Less() && this.notFor1_13_less.contains((Object)restriction) || !SCore.is1v19Plus() && this.notFor1_18_less.contains((Object)restriction) || !SCore.is1v20Plus() && this.notFor1_19_less.contains((Object)restriction)) continue;
            this.restrictions.put(restriction, new BooleanFeature(this, this.defaultValues.get((Object)restriction), restriction.featureSetting));
        }
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            for (RestrictionEnum restriction : this.restrictions.keySet()) {
                this.restrictions.get((Object)restriction).load(plugin, section, isPremiumLoading);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        for (RestrictionEnum restriction : this.restrictions.keySet()) {
            this.restrictions.get((Object)restriction).save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public Restrictions getValue() {
        return this;
    }

    public boolean is(RestrictionEnum ask) {
        for (RestrictionEnum restriction : this.restrictions.keySet()) {
            if (!restriction.equals((Object)ask)) continue;
            return this.restrictions.get((Object)restriction).getValue();
        }
        return false;
    }

    public BooleanFeature get(RestrictionEnum ask) {
        for (RestrictionEnum restriction : this.restrictions.keySet()) {
            if (!restriction.equals((Object)ask)) continue;
            return this.restrictions.get((Object)restriction);
        }
        return null;
    }

    public int getRestrictionCount() {
        int count = 0;
        for (RestrictionEnum restriction : this.restrictions.keySet()) {
            if (!this.restrictions.get((Object)restriction).getValue().booleanValue()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Restrictions initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7Restrictions activated: &e" + this.getRestrictionCount();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public Restrictions clone(FeatureParentInterface newParent) {
        Restrictions restrictions = new Restrictions(this.getParent(), this.getDefaultValues());
        LinkedHashMap<RestrictionEnum, BooleanFeature> clone = new LinkedHashMap<RestrictionEnum, BooleanFeature>();
        for (RestrictionEnum restriction : this.restrictions.keySet()) {
            clone.put(restriction, this.restrictions.get((Object)restriction).clone(restrictions));
        }
        restrictions.setRestrictions(clone);
        return restrictions;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        for (RestrictionEnum restriction : this.restrictions.keySet()) {
            features.add(this.restrictions.get((Object)restriction));
        }
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof Restrictions)) continue;
            Restrictions restrictions = (Restrictions)feature;
            LinkedHashMap<RestrictionEnum, BooleanFeature> reload = new LinkedHashMap<RestrictionEnum, BooleanFeature>();
            for (RestrictionEnum restriction : this.restrictions.keySet()) {
                reload.put(restriction, this.restrictions.get((Object)restriction));
            }
            restrictions.setRestrictions(reload);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public Map<RestrictionEnum, BooleanFeature> getRestrictions() {
        return this.restrictions;
    }

    @Generated
    public Map<RestrictionEnum, Boolean> getDefaultValues() {
        return this.defaultValues;
    }

    @Generated
    public List<RestrictionEnum> getNotFor1_11_less() {
        return this.notFor1_11_less;
    }

    @Generated
    public List<RestrictionEnum> getNotFor1_13_less() {
        return this.notFor1_13_less;
    }

    @Generated
    public List<RestrictionEnum> getNotFor1_18_less() {
        return this.notFor1_18_less;
    }

    @Generated
    public List<RestrictionEnum> getNotFor1_19_less() {
        return this.notFor1_19_less;
    }

    @Generated
    public void setRestrictions(Map<RestrictionEnum, BooleanFeature> restrictions) {
        this.restrictions = restrictions;
    }

    @Generated
    public void setDefaultValues(Map<RestrictionEnum, Boolean> defaultValues) {
        this.defaultValues = defaultValues;
    }

    @Generated
    public void setNotFor1_11_less(List<RestrictionEnum> notFor1_11_less) {
        this.notFor1_11_less = notFor1_11_less;
    }

    @Generated
    public void setNotFor1_13_less(List<RestrictionEnum> notFor1_13_less) {
        this.notFor1_13_less = notFor1_13_less;
    }

    @Generated
    public void setNotFor1_18_less(List<RestrictionEnum> notFor1_18_less) {
        this.notFor1_18_less = notFor1_18_less;
    }

    @Generated
    public void setNotFor1_19_less(List<RestrictionEnum> notFor1_19_less) {
        this.notFor1_19_less = notFor1_19_less;
    }
}

