/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SCore;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.CreationType;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CreationTypeFeature
extends FeatureAbstract<Optional<CreationType>, CreationTypeFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<CreationType> value;
    private Optional<CreationType> defaultValue;

    public CreationTypeFeature(FeatureParentInterface parent, Optional<CreationType> defaultValue, FeatureSettingsInterface settings) {
        super(parent, settings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        if (colorStr.equals("NULL")) {
            if (this.defaultValue.isPresent()) {
                this.value = this.defaultValue;
            } else {
                errors.add("&cERROR, Couldn't load the CreationType value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> BASIC_CREATION, IMPORT_FROM_EXECUTABLE_ITEMS, IMPORT_FROM_ORAXEN, IMPORT_FROM_ITEMS_ADDER");
                this.value = Optional.empty();
            }
            return errors;
        }
        try {
            CreationType attributeSlot = CreationType.valueOf(colorStr.toUpperCase());
            this.value = Optional.ofNullable(attributeSlot);
            FeatureReturnCheckPremium<CreationType> checkPremium = this.checkPremium("CreationType", attributeSlot, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            errors.add("&cERROR, Couldn't load the CreationType value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> BASIC_CREATION, IMPORT_FROM_EXECUTABLE_ITEMS, IMPORT_FROM_ORAXEN, IMPORT_FROM_ITEMS_ADDER");
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        if (((Optional)value).isPresent()) {
            config.set(this.getName(), (Object)((CreationType)((Object)((Optional)value).get())).name());
        }
    }

    @Override
    public Optional<CreationType> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public CreationTypeFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        CreationType finalValue = ((Optional)value).orElse(CreationType.BASIC_CREATION);
        this.updateCreationType(finalValue, gui);
    }

    @Override
    public CreationTypeFeature clone(FeatureParentInterface newParent) {
        CreationTypeFeature clone = new CreationTypeFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        CreationType slot = this.getCreationType((GUI)manager.getCache().get(editor));
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        slot = this.nextCreationType(slot);
        this.updateCreationType(slot, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        CreationType slot = this.getCreationType((GUI)manager.getCache().get(editor));
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        slot = this.prevCreationType(slot);
        this.updateCreationType(slot, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateCreationType(this.nextCreationType(this.getCreationType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateCreationType(this.prevCreationType(this.getCreationType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public CreationType nextCreationType(CreationType slot) {
        boolean next = false;
        for (CreationType check : this.getSortCreationTypes()) {
            if (check.equals((Object)slot)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortCreationTypes().get(0);
    }

    public CreationType prevCreationType(CreationType slot) {
        int i = -1;
        int cpt = 0;
        for (CreationType check : this.getSortCreationTypes()) {
            if (check.equals((Object)slot)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortCreationTypes().get(this.getSortCreationTypes().size() - 1);
        }
        return this.getSortCreationTypes().get(cpt - 1);
    }

    public void updateCreationType(CreationType slot, GUI gui) {
        if (slot.equals((Object)CreationType.IMPORT_FROM_EXECUTABLE_ITEMS) && !SCore.hasExecutableItems || slot.equals((Object)CreationType.IMPORT_FROM_ITEMS_ADDER) && !SCore.hasItemsAdder || slot.equals((Object)CreationType.IMPORT_FROM_ORAXEN) && !SCore.hasOraxen) {
            this.updateCreationType(this.nextCreationType(slot), gui);
            return;
        }
        this.value = Optional.of(slot);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortCreationTypes().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (CreationType check : this.getSortCreationTypes()) {
            if (slot.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + slot.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (CreationType check : this.getSortCreationTypes()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        for (HumanEntity e : gui.getInv().getViewers()) {
            if (!(e instanceof Player)) continue;
            Player p = (Player)e;
            p.updateInventory();
        }
    }

    public CreationType getCreationType(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return CreationType.valueOf(str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<CreationType> getSortCreationTypes() {
        TreeMap<String, CreationType> map = new TreeMap<String, CreationType>();
        for (CreationType l : CreationType.values()) {
            if (!SCore.is1v19v4Plus() && l == CreationType.DISPLAY_CREATION) continue;
            map.put(l.name(), l);
        }
        return new ArrayList<CreationType>(map.values());
    }

    @Generated
    public Optional<CreationType> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<CreationType> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<CreationType> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

