/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.api.OraxenItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class OraxenFeature
extends FeatureAbstract<Optional<String>, OraxenFeature>
implements FeatureRequireOnlyClicksInEditor {
    private static final boolean DEBUG = false;
    private Optional<String> value = Optional.empty();

    public OraxenFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "");
        this.value = colorStr.isEmpty() ? Optional.empty() : Optional.of(colorStr);
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        this.value.ifPresent(s -> config.set(this.getName(), s));
    }

    @Override
    public Optional<String> getValue() {
        if (this.value.isPresent() && SCore.hasOraxen && OraxenItems.getItemById((String)this.value.get()) != null) {
            return this.value;
        }
        return Optional.empty();
    }

    public Optional<ItemStack> getItemStack() {
        if (((Optional)this.getValue()).isPresent()) {
            return Optional.of(OraxenItems.getItemById((String)this.value.get()).build());
        }
        return Optional.empty();
    }

    public boolean placeOraxen(Location location, ItemStack itemStack) {
        if (((Optional)this.getValue()).isPresent()) {
            String id = (String)((Optional)this.getValue()).get();
            if (OraxenFurniture.isFurniture((String)id)) {
                OraxenFurniture.place((String)id, (Location)location, (Rotation)Rotation.NONE, (BlockFace)BlockFace.UP);
                return true;
            }
            if (OraxenBlocks.isOraxenBlock((String)id)) {
                OraxenBlocks.place((String)id, (Location)location);
                return true;
            }
        }
        return false;
    }

    public void removeBlock(Block block, Optional<Entity> blockEntity) {
        if (SCore.hasOraxen) {
            if (blockEntity.isPresent()) {
                Entity entity = blockEntity.get();
                if (OraxenFurniture.isFurniture((Entity)entity)) {
                    SsomarDev.testMsg("isFurniture IF", true);
                    OraxenFurniture.remove((Entity)entity, null);
                    return;
                }
            } else if (OraxenFurniture.isFurniture((Block)block)) {
                SsomarDev.testMsg("isFurniture", true);
                OraxenFurniture.remove((Location)block.getLocation(), null);
            } else if (OraxenBlocks.isOraxenBlock((Block)block)) {
                SsomarDev.testMsg("isOraxenBlock", true);
                OraxenBlocks.remove((Location)block.getLocation(), null);
            } else {
                SsomarDev.testMsg("isNothing", true);
            }
        }
    }

    @Override
    public OraxenFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 3];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 3] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 2] = "&8>> &6SHIFT : &eBOOST SCROLL";
        finalDescription[finalDescription.length - 1] = "&8>> &6UP: &eRIGHT | &6DOWN: &eLEFT";
        ItemStack item = new ItemStack(this.getEditorMaterial());
        if (((Optional)this.getValue()).isPresent()) {
            item = this.getItemStack().get();
        }
        gui.createItem(item, 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        if (SCore.hasOraxen) {
            if (((Optional)this.getValue()).isPresent()) {
                this.updateOraxen(this.value.get(), gui);
            } else {
                this.updateOraxen(this.getSortOraxen().get(0), gui);
            }
        } else {
            this.updateOraxen(null, gui);
        }
    }

    @Override
    public OraxenFeature clone(FeatureParentInterface newParent) {
        OraxenFeature clone = new OraxenFeature(newParent, this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = Optional.empty();
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        if (SCore.hasOraxen) {
            String id = this.getOraxen((GUI)manager.getCache().get(editor)).get();
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            id = this.nextOraxen(id);
            this.updateOraxen(id, (GUI)manager.getCache().get(editor));
        }
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        if (SCore.hasOraxen) {
            String id = this.getOraxen((GUI)manager.getCache().get(editor)).get();
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            id = this.prevOraxen(id);
            this.updateOraxen(id, (GUI)manager.getCache().get(editor));
        }
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        if (SCore.hasOraxen) {
            this.updateOraxen(this.nextOraxen(this.getOraxen((GUI)manager.getCache().get(editor)).get()), (GUI)manager.getCache().get(editor));
        }
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        if (SCore.hasOraxen) {
            this.updateOraxen(this.prevOraxen(this.getOraxen((GUI)manager.getCache().get(editor)).get()), (GUI)manager.getCache().get(editor));
        }
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public String nextOraxen(String id) {
        boolean next = false;
        for (String check : this.getSortOraxen()) {
            if (check.equals(id)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortOraxen().get(0);
    }

    public String prevOraxen(String id) {
        int i = -1;
        int cpt = 0;
        for (String check : this.getSortOraxen()) {
            if (check.equals(id)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortOraxen().get(this.getSortOraxen().size() - 1);
        }
        return this.getSortOraxen().get(cpt - 1);
    }

    public void updateOraxen(String id, GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        int slot = gui.getInv().first(item);
        this.initItemParentEditor(gui, slot);
        item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 3);
        if (id == null) {
            id = "NULLLLL";
        }
        this.value = Optional.of(id);
        if (SCore.hasOraxen) {
            boolean find = false;
            for (String check : this.getSortOraxen()) {
                if (id.equals(check)) {
                    lore.add(StringConverter.coloredString("&2\u27a4 &a" + id));
                    find = true;
                    continue;
                }
                if (!find) continue;
                if (lore.size() == 17) break;
                lore.add(StringConverter.coloredString("&6\u2726 &e" + check));
            }
            for (String check : this.getSortOraxen()) {
                if (lore.size() != 17) {
                    lore.add(StringConverter.coloredString("&6\u2726 &e" + check));
                    continue;
                }
                break;
            }
        } else {
            lore.add(StringConverter.coloredString("&4\u27a4 &cYou must have &6Oraxen"));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public Optional<String> getOraxen(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            if (str.contains("You must have &6Oraxen")) {
                return Optional.empty();
            }
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return Optional.ofNullable(str.split("\u27a4 ")[1]);
        }
        return Optional.empty();
    }

    public List<String> getSortOraxen() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (SCore.hasOraxen) {
            for (String c : OraxenItems.getItemNames()) {
                map.put(c, c);
            }
        }
        return new ArrayList<String>(map.values());
    }

    @Generated
    public void setValue(Optional<String> value) {
        this.value = value;
    }
}

