/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOneMessageInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class UncoloredStringFeature
extends FeatureAbstract<Optional<String>, UncoloredStringFeature>
implements FeatureRequireOneMessageInEditor {
    private Optional<String> value;
    private Optional<String> defaultValue;
    private boolean notSaveIfEqualsToDefaultValue;

    public UncoloredStringFeature(FeatureParentInterface parent, Optional<String> defaultValue, FeatureSettingsInterface featureSettings, boolean notSaveIfEqualsToDefaultValue) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.notSaveIfEqualsToDefaultValue = notSaveIfEqualsToDefaultValue;
        this.reset();
    }

    public static UncoloredStringFeature buildNull() {
        return new UncoloredStringFeature(null, Optional.empty(), null, false);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String valueStr = config.getString(this.getName(), "<<NULL>>");
        if (valueStr.equals("<<NULL>>")) {
            if (this.defaultValue.isPresent()) {
                valueStr = this.defaultValue.get();
                this.value = this.defaultValue;
            } else {
                valueStr = "";
                this.value = Optional.empty();
            }
        } else {
            this.value = (valueStr = StringConverter.decoloredString(valueStr)).isEmpty() ? Optional.empty() : Optional.of(valueStr);
        }
        FeatureReturnCheckPremium<String> checkPremium = this.checkPremium("Uncolored String", valueStr, this.defaultValue, isPremiumLoading);
        if (checkPremium.isHasError()) {
            this.value = Optional.ofNullable(checkPremium.getNewValue());
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        if (((Optional)value).isPresent()) {
            if (this.notSaveIfEqualsToDefaultValue && this.defaultValue.isPresent() && ((String)((Optional)value).get()).equals(this.defaultValue.get())) {
                config.set(this.getName(), null);
                return;
            }
            config.set(this.getName(), ((Optional)value).get());
        } else {
            config.set(this.getName(), null);
        }
    }

    @Override
    public Optional<String> getValue() {
        return this.value;
    }

    @Override
    public UncoloredStringFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = !this.isPremium() && this.isRequirePremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        if (this.value.isPresent() && !StringConverter.decoloredString(this.value.get()).isEmpty()) {
            gui.updateCurrently(this.getEditorName(), (String)((Optional)this.getValue()).get(), true);
        } else {
            gui.updateCurrently(this.getEditorName(), "&cEMPTY STRING", true);
        }
    }

    @Override
    public UncoloredStringFeature clone(FeatureParentInterface newParent) {
        UncoloredStringFeature clone = new UncoloredStringFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.notSaveIfEqualsToDefaultValue);
        clone.setValue((Optional<String>)this.getValue());
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void askInEditor(Player editor, NewGUIManager manager) {
        if (this.isRequirePremium() && !this.isPremium()) {
            return;
        }
        manager.requestWriting.put(editor, this.getEditorName());
        editor.closeInventory();
        UncoloredStringFeature.space(editor);
        TextComponent message = new TextComponent(StringConverter.coloredString("&a&l[Editor] &aEnter a string or &aedit &athe &aactual: "));
        TextComponent edit = new TextComponent(StringConverter.coloredString("&e&l[EDIT]"));
        edit.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, StringConverter.deconvertColor(((GUI)manager.getCache().get(editor)).getCurrentlyWithColor(this.getEditorName()))));
        edit.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&eClick here to edit the current string")).create()));
        TextComponent newName = new TextComponent(StringConverter.coloredString("&a&l[NEW]"));
        newName.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "Type the new string here.."));
        newName.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick here to set new string")).create()));
        TextComponent noValue = new TextComponent(StringConverter.coloredString("&c&l[NO VALUE / EXIT]"));
        noValue.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/score interact NO VALUE / EXIT"));
        noValue.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&cClick here to exit or don't set a value")).create()));
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)edit);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)newName);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)noValue);
        editor.spigot().sendMessage((BaseComponent)message);
        UncoloredStringFeature.space(editor);
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        return Optional.empty();
    }

    @Override
    public void finishEditInEditor(Player editor, NewGUIManager manager, String message) {
        String valueStr = StringConverter.decoloredString(message);
        this.value = message.contains("EMPTY STRING") ? Optional.of("") : (valueStr.isEmpty() ? Optional.empty() : Optional.of(valueStr));
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Override
    public void finishEditInEditorNoValue(Player editor, NewGUIManager manager) {
        this.value = Optional.empty();
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Generated
    public Optional<String> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public boolean isNotSaveIfEqualsToDefaultValue() {
        return this.notSaveIfEqualsToDefaultValue;
    }

    @Generated
    public void setValue(Optional<String> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<String> defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setNotSaveIfEqualsToDefaultValue(boolean notSaveIfEqualsToDefaultValue) {
        this.notSaveIfEqualsToDefaultValue = notSaveIfEqualsToDefaultValue;
    }
}

