/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.SCore;
import com.ssomar.score.api.executableitems.ExecutableItemsAPI;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ListExecutableItemsFeature
extends ListFeatureAbstract<String, ListExecutableItemsFeature> {
    public ListExecutableItemsFeature(FeatureParentInterface parent, List<String> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, "List of ExecutableItems", defaultValue, featureSettings);
        this.reset();
    }

    @Override
    public List<String> loadValues(List<String> entries, List<String> errors) {
        List<Object> result = new ArrayList();
        result = entries;
        if (!SCore.hasExecutableItems && entries.size() > 0) {
            errors.add("&cERROR, Couldn't load the List of ExecutableItems of " + this.getName() + " from config &7&o" + this.getParent().getParentInfo() + " &6>> You haven't ExecutableItems !");
            return errors;
        }
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, StringConverter.decoloredString((String)result.get(i)));
        }
        return result;
    }

    @Override
    public String transfromToString(String value) {
        return value;
    }

    @Override
    public ListExecutableItemsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = !SCore.hasExecutableItems ? "&4&l\u25cf &c&lRequire ExecutableItems" : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public ListExecutableItemsFeature clone(FeatureParentInterface newParent) {
        ListExecutableItemsFeature clone = new ListExecutableItemsFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    public boolean isValid(ItemStack itemStack) {
        if (this.getValues().size() == 0) {
            return true;
        }
        if (SCore.hasExecutableItems) {
            Optional<ExecutableItemInterface> executableItem = ExecutableItemsAPI.getExecutableItemsManager().getExecutableItem(itemStack);
            return executableItem.filter(executableItemInterface -> this.getValues().contains(executableItemInterface.getId())).isPresent();
        }
        return true;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        if (SCore.hasExecutableItems) {
            message = StringConverter.decoloredString(message.trim());
            if (ExecutableItemsAPI.getExecutableItemsManager().isValidID(message)) {
                return Optional.empty();
            }
            return Optional.of("&4&l[ERROR] &cThe message you entered is not a valid ExecutableItems ID ! (The id is word before the .yml) ");
        }
        return Optional.empty();
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return null;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        if (SCore.hasExecutableItems) {
            for (String s : ExecutableItemsAPI.getExecutableItemsManager().getExecutableItemIdsList()) {
                suggestions.add(new Suggestion(s, "&6[&e" + s + "&6]", "&7Add ExecutableItem : &e" + s));
            }
        }
        return new ArrayList<Suggestion>();
    }

    @Override
    public String getTips() {
        return "";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, false, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }
}

