/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.projectiles;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.custom.firework.FireworkFeatures;
import com.ssomar.score.features.custom.particles.group.ParticlesGroupFeature;
import com.ssomar.score.features.custom.potionsettings.PotionSettingsFeature;
import com.ssomar.score.projectiles.features.BounceFeature;
import com.ssomar.score.projectiles.features.ChargedFeature;
import com.ssomar.score.projectiles.features.ColorFeature;
import com.ssomar.score.projectiles.features.CriticalFeature;
import com.ssomar.score.projectiles.features.CustomModelDataFeature;
import com.ssomar.score.projectiles.features.CustomNameFeature;
import com.ssomar.score.projectiles.features.CustomNameVisisbleFeature;
import com.ssomar.score.projectiles.features.DamageFeature;
import com.ssomar.score.projectiles.features.DespawnFeature;
import com.ssomar.score.projectiles.features.EnchantmentsFeature;
import com.ssomar.score.projectiles.features.FireFeature;
import com.ssomar.score.projectiles.features.GlowDurationFeature;
import com.ssomar.score.projectiles.features.GlowingFeature;
import com.ssomar.score.projectiles.features.GravityFeature;
import com.ssomar.score.projectiles.features.HitSoundFeature;
import com.ssomar.score.projectiles.features.IncendiaryFeature;
import com.ssomar.score.projectiles.features.InvisibleFeature;
import com.ssomar.score.projectiles.features.ItemModelFeature;
import com.ssomar.score.projectiles.features.KnockbackStrengthFeature;
import com.ssomar.score.projectiles.features.PickupFeature;
import com.ssomar.score.projectiles.features.PierceLevelFeature;
import com.ssomar.score.projectiles.features.RadiusFeature;
import com.ssomar.score.projectiles.features.RemoveWhenHitBlockFeature;
import com.ssomar.score.projectiles.features.SilentFeature;
import com.ssomar.score.projectiles.features.VelocityFeature;
import com.ssomar.score.projectiles.features.visualItemFeature.VisualItemFeature;
import com.ssomar.score.utils.FixedMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SizedFireball;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.SplashPotion;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.Trident;
import org.bukkit.entity.WindCharge;
import org.bukkit.entity.WitherSkull;

public enum SProjectileType {
    ARROW(FixedMaterial.getMaterial(Arrays.asList("ARROW")), "ARROW"),
    EGG(FixedMaterial.getMaterial(Arrays.asList("EGG")), "EGG"),
    FIREBALL(FixedMaterial.getMaterial(Arrays.asList("FIRE_CHARGE")), "FIREBALL", "SMALL_FIREBALL"),
    SPLASH_POTION(FixedMaterial.getMaterial(Arrays.asList("SPLASH_POTION")), "SPLASH_POTION"),
    LINGERING_POTION(FixedMaterial.getMaterial(Arrays.asList("LINGERING_POTION")), "LINGERING_POTION"),
    ENDER_PEARL(FixedMaterial.getMaterial(Arrays.asList("ENDER_PEARL")), "ENDER_PEARL"),
    SHULKER_BULLET(FixedMaterial.getMaterial(Arrays.asList("PURPLE_SHULKER_BOX")), "SHULKER_BULLET"),
    SNOWBALL(FixedMaterial.getMaterial(Arrays.asList("SNOWBALL", "SNOW_BALL")), "SNOWBALL"),
    TRIDENT(FixedMaterial.getMaterial(Arrays.asList("TRIDENT")), "TRIDENT"),
    WITHER_SKULL(FixedMaterial.getMaterial(Arrays.asList("WITHER_SKELETON_SKULL")), "WITHER_SKULL"),
    DRAGON_FIREBALL(FixedMaterial.getMaterial(Arrays.asList("DRAGON_HEAD")), "DRAGON_FIREBALL"),
    THROWNEXPBOTTLE(FixedMaterial.getMaterial(Arrays.asList("EXPERIENCE_BOTTLE", "EXP_BOTTLE")), "THROWNEXPBOTTLE"),
    FIREWORK(FixedMaterial.getMaterial(Arrays.asList("FIREWORK_ROCKET")), "FIREWORK"),
    SPECTRAL_ARROW(FixedMaterial.getMaterial(Arrays.asList("SPECTRAL_ARROW")), "SPECTRAL_ARROW"),
    WIND_CHARGE(FixedMaterial.getMaterial(Arrays.asList("WIND_CHARGE")), "WIND_CHARGE"),
    LLAMA_SPIT(FixedMaterial.getMaterial(Arrays.asList("GHAST_TEAR")), "LLAMASPIT", "LLAMA_SPIT", "LAMASPIT", "LAMA_SPIT"),
    FISHHOOK(FixedMaterial.getMaterial(Arrays.asList("FISHING_ROD")), "FISHHOOK");

    private Material material;
    private final String[] validNames;

    private SProjectileType(Material material, String ... validNames) {
        this.material = material;
        this.validNames = validNames;
    }

    public static SProjectileType valueOfCustom(String str) {
        for (SProjectileType type : SProjectileType.values()) {
            for (String name : type.validNames) {
                if (!name.equalsIgnoreCase(str)) continue;
                return type;
            }
        }
        return null;
    }

    public List<FeatureAbstract> getFeatures(FeatureParentInterface parent) {
        ArrayList<FeatureAbstract> features = new ArrayList<FeatureAbstract>();
        features.add(new CustomNameVisisbleFeature(parent));
        features.add(new CustomNameFeature(parent));
        features.add(new InvisibleFeature(parent));
        features.add(new GlowingFeature(parent));
        features.add(new BounceFeature(parent));
        features.add(new DespawnFeature(parent));
        features.add(new VelocityFeature(parent));
        features.add(new SilentFeature(parent));
        if (!SCore.is1v13Less()) {
            features.add(new RemoveWhenHitBlockFeature(parent));
        }
        if (SCore.is1v17Plus()) {
            features.add(new FireFeature(parent));
        }
        if (SCore.is1v20v5Plus()) {
            // empty if block
        }
        if (this == SPECTRAL_ARROW && SCore.is1v20v5Plus()) {
            features.add(new GlowDurationFeature(parent));
        }
        switch (this.ordinal()) {
            case 0: 
            case 13: {
                features.add(new GravityFeature(parent));
                if (SCore.is1v13Less()) break;
                features.add(new ColorFeature(parent));
                features.add(new PierceLevelFeature(parent));
                features.add(new CriticalFeature(parent));
                features.add(new DamageFeature(parent));
                features.add(new KnockbackStrengthFeature(parent));
                features.add(new PickupFeature(parent));
                if (!SCore.is1v20v5Plus() || !SCore.isPaperOrFork()) break;
                features.add(new HitSoundFeature(parent));
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: {
                features.add(new GravityFeature(parent));
                if (!SCore.is1v13Less()) {
                    features.add(new VisualItemFeature(parent));
                    features.add(new CustomModelDataFeature(parent));
                }
                if (!SCore.is1v21v2Plus()) break;
                features.add(new ItemModelFeature(parent));
                break;
            }
            case 2: 
            case 10: {
                features.add(new GravityFeature(parent));
                features.add(new RadiusFeature(parent));
                features.add(new IncendiaryFeature(parent));
                break;
            }
            case 3: 
            case 4: {
                features.add(new GravityFeature(parent));
                features.add(new PotionSettingsFeature(parent));
                break;
            }
            case 6: 
            case 14: {
                features.add(new GravityFeature(parent));
                break;
            }
            case 8: {
                features.add(new GravityFeature(parent));
                if (!SCore.is1v13Less()) {
                    features.add(new PierceLevelFeature(parent));
                    features.add(new CriticalFeature(parent));
                    features.add(new KnockbackStrengthFeature(parent));
                    features.add(new PickupFeature(parent));
                    features.add(new CustomModelDataFeature(parent));
                }
                if (SCore.is1v21v2Plus()) {
                    features.add(new ItemModelFeature(parent));
                }
                if (SCore.is1v12Less()) break;
                features.add(new EnchantmentsFeature(parent, false));
                break;
            }
            case 9: {
                features.add(new GravityFeature(parent));
                features.add(new RadiusFeature(parent));
                features.add(new IncendiaryFeature(parent));
                features.add(new ChargedFeature(parent));
                break;
            }
            case 12: {
                features.add(new FireworkFeatures(parent));
            }
        }
        if (!SCore.is1v11Less()) {
            features.add(new ParticlesGroupFeature(parent, false));
        }
        return features;
    }

    public static Map<String, Class> getProjectilesClasses() {
        HashMap<String, Class> projectiles = new HashMap<String, Class>();
        try {
            projectiles.put("ARROW", Arrow.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("SPECTRALARROW", SpectralArrow.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("FISHHOOK", FishHook.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("SPECTRAL_ARROW", SpectralArrow.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("DRAGONFIREBALL", DragonFireball.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("DRAGON_FIREBALL", DragonFireball.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("FIREBALL", Fireball.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("SMALLFIREBALL", SmallFireball.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("LARGEFIREBALL", LargeFireball.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("LARGE_FIREBALL", LargeFireball.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("SIZEDFIREBALL", SizedFireball.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("SIZED_FIREBALL", SizedFireball.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("SNOWBALL", Snowball.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("THROWNEXPBOTTLE", ThrownExpBottle.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("WITHERSKULL", WitherSkull.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("WITHER_SKULL", WitherSkull.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("EGG", Egg.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("ENDERPEARL", EnderPearl.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("ENDER_PEARL", EnderPearl.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("LINGERINGPOTION", LingeringPotion.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("LINGERING_POTION", LingeringPotion.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("SPLASHPOTION", SplashPotion.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("SPLASH_POTION", SplashPotion.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("LLAMASPIT", LlamaSpit.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("LLAMA_SPIT", LlamaSpit.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("SHULKERBULLET", ShulkerBullet.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("SHULKER_BULLET", ShulkerBullet.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("TRIDENT", Trident.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("FIREWORK", Firework.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("SPECTRAL_ARROW", SpectralArrow.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        try {
            projectiles.put("WIND_CHARGE", WindCharge.class);
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
        return projectiles;
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public String[] getValidNames() {
        return this.validNames;
    }
}

