/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.projectiles.features;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.projectiles.features.SProjectileFeatureInterface;
import com.ssomar.score.utils.numbers.NTools;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class CustomModelDataFeature
extends UncoloredStringFeature
implements SProjectileFeatureInterface {
    public CustomModelDataFeature(FeatureParentInterface parent) {
        super(parent, Optional.empty(), FeatureSettingsSCore.customModelData, false);
    }

    @Override
    public void transformTheProjectile(Entity e, Player launcher, Material materialLaunched) {
        if (((Optional)this.getValue()).isPresent() && e instanceof ThrowableProjectile) {
            ItemStack item = ((ThrowableProjectile)e).getItem();
            ItemMeta meta = item.getItemMeta();
            if (SCore.is1v21v4Plus()) {
                String[] split = ((String)((Optional)this.getValue()).get()).split(";");
                ArrayList<Float> floats = new ArrayList<Float>();
                ArrayList<Boolean> booleans = new ArrayList<Boolean>();
                ArrayList<String> strings = new ArrayList<String>();
                for (String s : split) {
                    Optional<Float> f = NTools.getFloat(s);
                    if (f.isPresent()) {
                        floats.add(f.get());
                        continue;
                    }
                    if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false")) {
                        booleans.add(Boolean.parseBoolean(s));
                        continue;
                    }
                    strings.add(s);
                }
                CustomModelDataComponent customModelDataComponent = meta.getCustomModelDataComponent();
                customModelDataComponent.setStrings(strings);
                customModelDataComponent.setFloats(floats);
                customModelDataComponent.setFlags(booleans);
                meta.setCustomModelDataComponent(customModelDataComponent);
            } else {
                Optional<Integer> integerOptional = NTools.getInteger((String)((Optional)this.getValue()).get());
                if (integerOptional.isPresent()) {
                    meta.setCustomModelData(integerOptional.get());
                }
            }
            item.setItemMeta(meta);
            ((ThrowableProjectile)e).setItem(item);
        }
    }

    @Override
    public CustomModelDataFeature clone(FeatureParentInterface newParent) {
        CustomModelDataFeature clone = new CustomModelDataFeature(newParent);
        clone.setValue((Optional<String>)this.getValue());
        return clone;
    }
}

