/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.usedapi;

import com.ssomar.score.SCore;
import com.ssomar.score.configs.messages.Message;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.strings.StringConverter;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultAPI {
    private static Economy econ = null;
    public final SendMessage sm = new SendMessage();

    public boolean verifEconomy(Player p) {
        if (SCore.hasVault) {
            RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp == null) {
                p.sendMessage(StringConverter.coloredString("&4&l[SCore] &cPlease contact your administrator, Vault dont find an Economy plugin !"));
                SCore.plugin.getServer().getLogger().severe("[SCore] Vault dont find an Economy plugin !");
                return false;
            }
            econ = (Economy)rsp.getProvider();
            if (econ == null) {
                p.sendMessage(StringConverter.coloredString("&4&l[SCore] &cPlease contact your administrator, Vault has problem with the Economy plugin !"));
                SCore.plugin.getServer().getLogger().severe("[SCore] Vault has problem with the Economy plugin !");
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasMoney(Player p, double amount, String customMessage) {
        if (!SCore.hasVault) {
            return false;
        }
        if (!econ.has((OfflinePlayer)p, amount)) {
            DecimalFormat df = new DecimalFormat("#.##");
            df.setRoundingMode(RoundingMode.CEILING);
            if (customMessage.length() == 0) {
                this.sm.sendMessage(p, StringConverter.coloredString(MessageMain.getInstance().getMessage((Plugin)SCore.plugin, Message.ERROR_MONEY).replaceAll("%amount%", amount + "").replaceAll("%balance%", df.format(econ.getBalance((OfflinePlayer)p)) + "")));
            } else {
                this.sm.sendMessage(p, StringConverter.coloredString(customMessage.replaceAll("%amount%", amount + "").replaceAll("%balance%", df.format(econ.getBalance((OfflinePlayer)p)) + "")));
            }
        }
        return econ.has((OfflinePlayer)p, amount);
    }

    public void takeMoney(Player p, double amount) {
        if (!SCore.hasVault) {
            return;
        }
        econ.withdrawPlayer((OfflinePlayer)p, amount);
        DecimalFormat df = new DecimalFormat("#.##");
        df.setRoundingMode(RoundingMode.CEILING);
        this.sm.sendMessage(p, StringConverter.coloredString(MessageMain.getInstance().getMessage((Plugin)SCore.plugin, Message.NEW_BALANCE_NEGATIVE).replaceAll("%amount%", amount + "").replaceAll("%balance%", df.format(econ.getBalance((OfflinePlayer)p)) + "")));
    }

    public void addMoney(Player p, double amount) {
        if (!SCore.hasVault) {
            return;
        }
        econ.depositPlayer((OfflinePlayer)p, amount);
        DecimalFormat df = new DecimalFormat("#.##");
        df.setRoundingMode(RoundingMode.CEILING);
        this.sm.sendMessage(p, StringConverter.coloredString(MessageMain.getInstance().getMessage((Plugin)SCore.plugin, Message.NEW_BALANCE_POSITIVE).replaceAll("%amount%", amount + "").replaceAll("%balance%", df.format(econ.getBalance((OfflinePlayer)p)) + "")));
    }
}

