/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public class CheckVersionSpigot {
    public static String getNameFromJson(String urlString) throws Exception {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            return "Error: Unable to fetch last version";
        }
        try {
            String string;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String inputLine;
                StringBuilder content = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
                JSONObject jsonObject = new JSONObject(content.toString());
                string = jsonObject.getString("name");
            }
            return string;
        }
        finally {
            connection.disconnect();
        }
    }

    public static String getVersionOf(String resourceId) {
        try {
            String str = CheckVersionSpigot.getNameFromJson("https://api.spiget.org/v2/resources/" + resourceId + "/versions/latest");
            if (str.contains("[")) {
                str = str.split("\\[")[0];
            }
            str = str.trim();
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

