/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.sevents.events.player.kill.entity;

import com.ssomar.sevents.events.player.kill.entity.PlayerKillEntityEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerKillEntityListener
implements Listener {
    private Map<UUID, UUID> playerKilledArmorStand = new HashMap<UUID, UUID>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler
    public void onEntityDeathEvent(EntityDeathEvent e) {
        Player p;
        LivingEntity entity = e.getEntity();
        if (entity instanceof Player) {
            return;
        }
        if (e.getEntity() instanceof ArmorStand) {
            if (!this.playerKilledArmorStand.containsKey(e.getEntity().getUniqueId())) return;
            p = Bukkit.getPlayer((UUID)this.playerKilledArmorStand.get(e.getEntity().getUniqueId()));
            this.playerKilledArmorStand.remove(e.getEntity().getUniqueId());
        } else {
            p = entity.getKiller();
            if (p == null) {
                return;
            }
        }
        if (p == null) return;
        PlayerKillEntityEvent playerKillEntityEvent = new PlayerKillEntityEvent(p, (Entity)entity, e.getDroppedExp(), e.getDrops());
        Bukkit.getServer().getPluginManager().callEvent((Event)playerKillEntityEvent);
        e.setDroppedExp(playerKillEntityEvent.getDroppedExp());
    }

    @EventHandler
    public void ArmorStandKiller(EntityDamageByEntityEvent e) {
        if (!(e.getEntity() instanceof ArmorStand) || !(e.getDamager() instanceof Player)) {
            return;
        }
        this.playerKilledArmorStand.put(e.getEntity().getUniqueId(), e.getDamager().getUniqueId());
    }

    @EventHandler
    public void onHangingBreakByEntityEvent(HangingBreakByEntityEvent e) {
        if (e.getEntity() instanceof Player || !(e.getRemover() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getRemover();
        if (p == null) {
            return;
        }
        if (p != null) {
            PlayerKillEntityEvent playerKillEntityEvent = new PlayerKillEntityEvent(p, (Entity)e.getEntity(), 0, new ArrayList<ItemStack>());
            playerKillEntityEvent.setCancelled(e.isCancelled());
            Bukkit.getServer().getPluginManager().callEvent((Event)playerKillEntityEvent);
            if (playerKillEntityEvent.isCancelled()) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onVehicleDestroyEvent(VehicleDestroyEvent e) {
        if (!(e.getAttacker() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getAttacker();
        if (p == null) {
            return;
        }
        if (p != null) {
            PlayerKillEntityEvent playerKillEntityEvent = new PlayerKillEntityEvent(p, (Entity)e.getVehicle(), 0, new ArrayList<ItemStack>());
            playerKillEntityEvent.setCancelled(e.isCancelled());
            Bukkit.getServer().getPluginManager().callEvent((Event)playerKillEntityEvent);
            if (playerKillEntityEvent.isCancelled()) {
                e.setCancelled(true);
            }
        }
    }
}

