/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.CommmandThatRunsCommand;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Around
extends BlockCommand {
    private static final Boolean DEBUG = false;

    public Around() {
        CommandSetting distance = new CommandSetting("distance", 0, Double.class, (Object)3.0);
        CommandSetting displayMsgIfNoPlayer = new CommandSetting("affectThePlayerThatActivesTheActivator", 1, Boolean.class, (Object)true, true);
        CommandSetting throughBlocks = new CommandSetting("throughBlocks", -1, Boolean.class, (Object)true);
        CommandSetting limit = new CommandSetting("limit", -1, Integer.class, (Object)-1);
        CommandSetting sort = new CommandSetting("sort", -1, String.class, (Object)"NEAREST");
        List<CommandSetting> settings = this.getSettings();
        settings.add(distance);
        settings.add(displayMsgIfNoPlayer);
        settings.add(throughBlocks);
        settings.add(limit);
        settings.add(sort);
        this.setNewSettingsMode(true);
        this.setCanExecuteCommands(true);
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        String error = "";
        String around = "AROUND {distance} [affectThePlayerThatActivesTheActivator true or false] {Your commands here}";
        if (args.size() < 2) {
            error = "&cThere is &6not enough args &cfor the command: &e" + around;
        } else if (args.size() > 2) {
            try {
                Double.valueOf(args.get(0));
            }
            catch (NumberFormatException e) {
                error = "&cA SCommand contains an &6invalid distance&c: &e" + args.get(0) + " for command: " + around;
            }
        }
        return error.isEmpty() ? Optional.empty() : Optional.of(error);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("AROUND");
        return names;
    }

    @Override
    public String getTemplate() {
        return "AROUND {distance} [affectThePlayerThatActivesTheActivator true or false] {Your commands here}";
    }

    @Override
    public ChatColor getColor() {
        return ChatColor.LIGHT_PURPLE;
    }

    @Override
    public ChatColor getExtraColor() {
        return ChatColor.DARK_PURPLE;
    }

    @Override
    public void run(final Player p, final @NotNull Block block, final SCommandToExec sCommandToExec) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    double distance = (Double)sCommandToExec.getSettingValue("distance");
                    boolean affectThePlayerThatActivesTheActivator = (Boolean)sCommandToExec.getSettingValue("affectThePlayerThatActivesTheActivator");
                    boolean throughBlocks = (Boolean)sCommandToExec.getSettingValue("throughBlocks");
                    int limit = (Integer)sCommandToExec.getSettingValue("limit");
                    String sort = (String)sCommandToExec.getSettingValue("sort");
                    List<Player> targets = new ArrayList();
                    for (Entity e : block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 0.5, 0.5), distance, distance, distance)) {
                        Player target;
                        if (!(e instanceof Player)) continue;
                        Location receiverLoc = e.getLocation();
                        if (!throughBlocks) {
                            ArrayList<Location> centerLocationOfEachFaces = new ArrayList<Location>();
                            centerLocationOfEachFaces.add(block.getLocation().add(0.0, 0.5, 0.5));
                            centerLocationOfEachFaces.add(block.getLocation().add(1.0, 0.5, 0.5));
                            centerLocationOfEachFaces.add(block.getLocation().add(0.5, 0.0, 0.5));
                            centerLocationOfEachFaces.add(block.getLocation().add(0.5, 1.0, 0.5));
                            centerLocationOfEachFaces.add(block.getLocation().add(0.5, 0.5, 0.0));
                            centerLocationOfEachFaces.add(block.getLocation().add(0.5, 0.5, 1.0));
                            boolean valid = false;
                            for (Location loc : centerLocationOfEachFaces) {
                                double distanceBetween = receiverLoc.distance(loc);
                                Vector direction = loc.toVector().subtract(receiverLoc.toVector()).normalize();
                                RayTraceResult rayTraceResult = receiverLoc.getWorld().rayTraceBlocks(receiverLoc, direction, distanceBetween, FluidCollisionMode.NEVER, true);
                                if (rayTraceResult != null) continue;
                                valid = true;
                                break;
                            }
                            if (!valid) continue;
                        }
                        if ((target = (Player)e).hasMetadata("NPC") || !affectThePlayerThatActivesTheActivator && p != null && p.equals((Object)target)) continue;
                        targets.add(target);
                    }
                    if (sort.equalsIgnoreCase("NEAREST")) {
                        targets.sort((p1, p2) -> {
                            double d1 = p1.getLocation().distance(block.getLocation());
                            double d2 = p2.getLocation().distance(block.getLocation());
                            return Double.compare(d1, d2);
                        });
                    } else if (sort.equalsIgnoreCase("RANDOM")) {
                        Collections.shuffle(targets);
                    }
                    if (limit > 0 && targets.size() > limit) {
                        targets = targets.subList(0, limit);
                    }
                    CommmandThatRunsCommand.runPlayerCommands(targets, sCommandToExec.getOtherArgs(), sCommandToExec.getActionInfo());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        SCore.schedulerHook.runTask(runnable, 0L);
    }
}

